/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.content.Context;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.Version;

public final class AdRegistration {
    private static final String LOG_TAG = "AdRegistration";

    protected AdRegistration() {
    }

    public static final void setAppKey(String appKey) throws IllegalArgumentException {
        InternalAdRegistration.getInstance().getRegistrationInfo().putAppKey(appKey);
    }

    public static final void enableLogging(boolean enable) {
        Log.enableLoggingWithSetterNotification(LOG_TAG, enable);
    }

    public static final void enableTesting(boolean enable) {
        Settings.getInstance().putTransientBoolean("testingEnabled", enable);
        Log.logSetterNotification(LOG_TAG, "Test mode", enable);
    }

    public static final String getVersion() {
        return Version.getSDKVersion();
    }

    public static final void registerApp(Context context) {
        if (!PermissionChecker.getInstance().passesInternetPermissionCheck(context, LOG_TAG)) {
            return;
        }
        InternalAdRegistration.getInstance().contextReceived(context);
        InternalAdRegistration.getInstance().register();
    }
}

