/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdData;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.Version;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

class AdMetrics {
    public static final String LOG_TAG = "AdMetrics";
    private AdData adData;
    private MetricsCollector globalMetrics;

    public AdMetrics(AdData adData) {
        this.adData = adData;
    }

    private String getAaxUrlAndResetAdMetrics() {
        String json = this.getAaxJson();
        json = Utils.getURLEncodedString(json);
        String url = this.adData.getInstrumentationPixelUrl() + json;
        this.adData.resetMetricsCollector();
        return url;
    }

    public WebRequest getAaxWebRequestAndResetAdMetrics() {
        WebRequest webRequest = WebRequest.createNewWebRequest();
        webRequest.setUrlString(this.getAaxUrlAndResetAdMetrics());
        return webRequest;
    }

    public boolean canSubmit() {
        if (this.adData == null) {
            return false;
        }
        String pixelUrl = this.adData.getInstrumentationPixelUrl();
        if (pixelUrl == null || pixelUrl.equals("")) {
            return false;
        }
        String appKey = InternalAdRegistration.getInstance().getRegistrationInfo().getAppKey();
        return appKey != null && !appKey.equals("123");
    }

    public void addGlobalMetrics(MetricsCollector globalMetrics) {
        this.globalMetrics = globalMetrics;
    }

    protected String getAaxJson() {
        JSONObject json = new JSONObject();
        JSONUtils.put(json, "c", "msdk");
        JSONUtils.put(json, "v", Version.getRawSDKVersion());
        AdMetrics.addMetricsToJSON(json, this.adData.getMetricsCollector());
        AdMetrics.addMetricsToJSON(json, this.globalMetrics);
        String jsonString = json.toString();
        String bracesRemovedJsonString = jsonString.substring(1, jsonString.length() - 1);
        return bracesRemovedJsonString;
    }

    protected static void addMetricsToJSON(JSONObject json, MetricsCollector metricsCollector) {
        if (metricsCollector == null) {
            return;
        }
        HashMap<Metrics.MetricType, Long> startedMetricHits = new HashMap<Metrics.MetricType, Long>();
        HashMap<Metrics.MetricType, Integer> incrementedMetricHits = new HashMap<Metrics.MetricType, Integer>();
        String adTypeMetricTag = metricsCollector.getAdTypeMetricTag();
        if (adTypeMetricTag != null) {
            adTypeMetricTag = adTypeMetricTag + "_";
        }
        MetricsCollector.MetricHit[] tempMetricHits = metricsCollector.getMetricHits().toArray(new MetricsCollector.MetricHit[metricsCollector.getMetricHits().size()]);
        String metricName = null;
        for (MetricsCollector.MetricHit metricHit : tempMetricHits) {
            metricName = metricHit.metric.getAaxName();
            if (adTypeMetricTag != null && metricHit.metric.isAdTypeSpecific()) {
                metricName = adTypeMetricTag + metricName;
            }
            if (metricHit instanceof MetricsCollector.MetricHitStartTime) {
                MetricsCollector.MetricHitStartTime metricHitStartTime = (MetricsCollector.MetricHitStartTime)metricHit;
                startedMetricHits.put(metricHit.metric, metricHitStartTime.startTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitStopTime) {
                MetricsCollector.MetricHitStopTime metricHitStopTime = (MetricsCollector.MetricHitStopTime)metricHit;
                Long startTime = (Long)startedMetricHits.get((Object)metricHit.metric);
                if (startTime == null) continue;
                long totalTime = metricHitStopTime.stopTime - startTime;
                JSONUtils.put(json, metricName, totalTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitTotalTime) {
                MetricsCollector.MetricHitTotalTime metricHitTotalTime = (MetricsCollector.MetricHitTotalTime)metricHit;
                JSONUtils.put(json, metricName, metricHitTotalTime.totalTime);
                continue;
            }
            if (metricHit instanceof MetricsCollector.MetricHitIncrement) {
                MetricsCollector.MetricHitIncrement metricHitIncrement = (MetricsCollector.MetricHitIncrement)metricHit;
                Integer increment = (Integer)incrementedMetricHits.get((Object)metricHit.metric);
                increment = increment == null ? metricHitIncrement.increment : increment + metricHitIncrement.increment;
                incrementedMetricHits.put(metricHit.metric, increment);
                continue;
            }
            if (!(metricHit instanceof MetricsCollector.MetricHitString)) continue;
            MetricsCollector.MetricHitString metricHitString = (MetricsCollector.MetricHitString)metricHit;
            JSONUtils.put(json, metricName, metricHitString.text);
        }
        for (Map.Entry incrementedMetric : incrementedMetricHits.entrySet()) {
            metricName = ((Metrics.MetricType)((Object)incrementedMetric.getKey())).getAaxName();
            if (adTypeMetricTag != null && ((Metrics.MetricType)((Object)incrementedMetric.getKey())).isAdTypeSpecific()) {
                metricName = adTypeMetricTag + metricName;
            }
            JSONUtils.put(json, metricName, (Integer)incrementedMetric.getValue());
        }
    }
}

