/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRequest;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Assets;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.IAdLoaderCallback;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.MetricsCollector;
import com.amazon.device.ads.StartUpWaiter;
import com.amazon.device.ads.ThreadUtils;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SuppressLint(value={"UseSparseArrays"})
class AdLoader {
    protected static final String LOG_TAG = AdLoader.class.getSimpleName();
    public static final int AD_QUEUED = 0;
    public static final int AD_FAILED = -1;
    public static final int AD_NOT_READY = 1;
    private static AdLoaderFactory adLoaderFactory = new AdLoaderFactory();
    protected final AdRequest adRequest;
    protected final Map<Integer, AdSlot> slots;
    protected int timeout = 20000;
    protected AdError error = null;
    protected MetricsCollector.CompositeMetricsCollector compositeMetricsCollector = null;

    public AdLoader(AdRequest adRequest, Map<Integer, AdSlot> slots) {
        this.adRequest = adRequest;
        this.slots = slots;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    protected static void setAdLoaderFactory(AdLoaderFactory adLoaderFactory) {
        AdLoader.adLoaderFactory = adLoaderFactory;
    }

    public void beginFetchAd() {
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_LOADAD_TO_FETCH_THREAD_REQUEST_START);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_SPIN_UP);
        this.startFetchAdThread();
    }

    protected void startFetchAdThread() {
        ThreadUtils.executeRunnable(new Runnable(){

            public void run() {
                AdLoader.this.fetchAd();
                AdLoader.this.beginFinalizeFetchAd();
            }
        });
    }

    private void beginFinalizeFetchAd() {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            public void run() {
                AdLoader.this.finalizeFetchAd();
            }
        });
    }

    protected void fetchAd() {
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_SPIN_UP);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_START_TO_AAX_GET_AD_START);
        if (!Assets.getInstance().ensureAssetsCreated()) {
            String msg = "Unable to create the assets needed to display ads";
            this.error = new AdError(AdError.ErrorCode.REQUEST_ERROR, "Unable to create the assets needed to display ads");
            Log.e(LOG_TAG, "Unable to create the assets needed to display ads");
            this.setErrorForAllSlots(this.error);
            return;
        }
        WebRequest.WebResponse response = null;
        try {
            response = this.fetchResponseFromNetwork();
        }
        catch (AdFetchException e) {
            this.error = e.getAdError();
            Log.e(LOG_TAG, e.getAdError().getMessage());
            this.setErrorForAllSlots(this.error);
            return;
        }
        if (!response.isHttpStatusCodeOK()) {
            String msg = response.getHttpStatusCode() + " - " + response.getHttpStatus();
            this.error = new AdError(AdError.ErrorCode.NETWORK_ERROR, msg);
            Log.e(LOG_TAG, msg);
            this.setErrorForAllSlots(this.error);
            return;
        }
        JSONObject jsonResponse = response.getJSONObjectBody();
        if (jsonResponse == null) {
            String msg = "Unable to parse response";
            this.error = new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Unable to parse response");
            Log.e(LOG_TAG, "Unable to parse response");
            this.setErrorForAllSlots(this.error);
            return;
        }
        this.parseResponse(jsonResponse);
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_AAX_GET_AD_END_TO_FETCH_THREAD_END);
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_SPIN_UP);
    }

    private WebRequest getAdRequest() throws AdFetchException {
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_CREATE_AAX_GET_AD_URL);
        WebRequest request = this.adRequest.getWebRequest();
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_CREATE_AAX_GET_AD_URL);
        return request;
    }

    private void parseResponse(JSONObject jsonResponse) {
        long currentTime = System.currentTimeMillis();
        String status = JSONUtils.getStringFromJSON(jsonResponse, "status", null);
        HashSet<Integer> slotsNotReceived = new HashSet<Integer>(this.slots.keySet());
        AdError adError = this.getAdError(jsonResponse);
        String errorCode = JSONUtils.getStringFromJSON(jsonResponse, "errorCode", "No Ad Received");
        this.adRequest.setInstrumentationPixelURL(JSONUtils.getStringFromJSON(jsonResponse, "instrPixelURL", null));
        if (status != null && status.equals("ok")) {
            JSONArray adsArray = JSONUtils.getJSONArrayFromJSON(jsonResponse, "ads");
            for (int i = 0; i < adsArray.length(); ++i) {
                long expiration;
                int slotId;
                AdSlot adSlot;
                JSONObject slot = JSONUtils.getJSONObjectFromJSONArray(adsArray, i);
                if (slot == null || (adSlot = this.slots.get(slotId = JSONUtils.getIntegerFromJSON(slot, "slotId", -1))) == null) continue;
                slotsNotReceived.remove(slotId);
                String adPixelUrl = JSONUtils.getStringFromJSON(slot, "instrPixelURL", this.adRequest.getInstrumentationPixelURL());
                adSlot.getAdData().setInstrumentationPixelUrl(adPixelUrl);
                String impPixelUrl = JSONUtils.getStringFromJSON(slot, "impPixelURL", null);
                adSlot.getAdData().setImpressionPixelUrl(impPixelUrl);
                if (adSlot.getAdData().getRequestedAdSize().isAuto()) {
                    adSlot.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_AUTO_AD_SIZE);
                }
                String creative = JSONUtils.getStringFromJSON(slot, "html", "");
                JSONArray creativeTypes = JSONUtils.getJSONArrayFromJSON(slot, "creativeTypes");
                HashSet<AdData.AAXCreative> creativeSet = new HashSet<AdData.AAXCreative>();
                if (creativeTypes != null) {
                    for (int j = 0; j < creativeTypes.length(); ++j) {
                        int creativeType = JSONUtils.getIntegerFromJSONArray(creativeTypes, j, 0);
                        AdData.AAXCreative aaxCreative = AdData.AAXCreative.getCreative(creativeType);
                        if (aaxCreative == null) continue;
                        creativeSet.add(aaxCreative);
                    }
                }
                if (creativeSet.isEmpty()) {
                    String msg = "No valid creative types found";
                    adSlot.setAdError(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "No valid creative types found"));
                    Log.e(LOG_TAG, "No valid creative types found");
                    continue;
                }
                String size = JSONUtils.getStringFromJSON(slot, "size", "");
                int adWidth = 0;
                int adHeight = 0;
                if (!creativeSet.contains((Object)AdData.AAXCreative.INTERSTITIAL)) {
                    String[] sizes;
                    boolean sizeIsInvalid = false;
                    String[] stringArray = sizes = size != null ? size.split("x") : null;
                    if (sizes == null || sizes.length != 2) {
                        sizeIsInvalid = true;
                    } else {
                        try {
                            adWidth = Integer.parseInt(sizes[0]);
                            adHeight = Integer.parseInt(sizes[1]);
                        }
                        catch (NumberFormatException e) {
                            sizeIsInvalid = true;
                        }
                    }
                    if (sizeIsInvalid) {
                        String msg = "Server returned an invalid ad size";
                        adSlot.setAdError(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Server returned an invalid ad size"));
                        Log.e(LOG_TAG, "Server returned an invalid ad size");
                        continue;
                    }
                }
                if ((expiration = JSONUtils.getLongFromJSON(slot, "cacheTTL", -1L)) > -1L) {
                    long expirationTimeMs = currentTime + 1000L * expiration;
                    adSlot.getAdData().setExpirationTimeMillis(expirationTimeMs);
                }
                AdProperties props = new AdProperties(creativeTypes);
                adSlot.getAdData().setHeight(adHeight);
                adSlot.getAdData().setWidth(adWidth);
                adSlot.getAdData().setCreative(creative);
                adSlot.getAdData().setCreativeTypes(creativeSet);
                adSlot.getAdData().setProperties(props);
                adSlot.getAdData().setFetched(true);
            }
        }
        for (Integer slotId : slotsNotReceived) {
            this.slots.get(slotId).setAdError(adError);
            this.slots.get(slotId).getAdData().setInstrumentationPixelUrl(this.adRequest.getInstrumentationPixelURL());
            Log.w(LOG_TAG, "%s; code: %s", adError.getMessage(), errorCode);
        }
    }

    protected AdError getAdError(JSONObject jsonResponse) {
        int noRetryTtlSeconds = this.retrieveNoRetryTtlSeconds(jsonResponse);
        InternalAdRegistration.getInstance().setNoRetryTtl(noRetryTtlSeconds);
        String errorMsg = JSONUtils.getStringFromJSON(jsonResponse, "errorMessage", "No Ad Received");
        InternalAdRegistration.getInstance().setIsAppDisabled(errorMsg.equalsIgnoreCase(Utils.getDisabledAppServerMessage()));
        String msg = "Server Message: " + errorMsg;
        AdError adError = null;
        if (noRetryTtlSeconds > 0) {
            this.getCompositeMetricsCollector().publishMetricInMilliseconds(Metrics.MetricType.AD_NO_RETRY_TTL_RECEIVED, noRetryTtlSeconds * 1000);
        }
        if (noRetryTtlSeconds > 0 && !InternalAdRegistration.getInstance().getIsAppDisabled()) {
            msg = msg + ". Try again in " + noRetryTtlSeconds + " seconds";
            adError = new AdError(AdError.ErrorCode.NO_FILL, msg);
        } else {
            adError = errorMsg.equals("no results") ? new AdError(AdError.ErrorCode.NO_FILL, msg) : new AdError(AdError.ErrorCode.INTERNAL_ERROR, msg);
        }
        return adError;
    }

    private void setErrorForAllSlots(AdError error) {
        for (AdSlot slot : this.slots.values()) {
            slot.setAdError(error);
        }
    }

    protected int retrieveNoRetryTtlSeconds(JSONObject jsonResponse) {
        int noRetryTtlSeconds = JSONUtils.getIntegerFromJSON(jsonResponse, "noretryTTL", 0);
        noRetryTtlSeconds = DebugProperties.getDebugPropertyAsInteger("debug.noRetryTTL", noRetryTtlSeconds);
        return noRetryTtlSeconds;
    }

    protected void finalizeFetchAd() {
        for (Map.Entry<Integer, AdSlot> entry : this.slots.entrySet()) {
            AdSlot slot = entry.getValue();
            IAdLoaderCallback adLoaderCallback = slot.getAdLoaderCallback();
            AdData adData = slot.getAdData();
            adData.getMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_SPIN_UP);
            if (!adData.getIsFetched()) {
                adData.getMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_FAILURE);
                if (slot.getAdError() != null) {
                    adLoaderCallback.adFailed(slot.getAdError());
                    continue;
                }
                adLoaderCallback.adFailed(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "Unknown error occurred."));
                continue;
            }
            adData.getMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_FINALIZE_FETCH_START_TO_RENDER_START);
            adLoaderCallback.handleResponse();
        }
    }

    protected WebRequest.WebResponse fetchResponseFromNetwork() throws AdFetchException {
        WebRequest request = this.getAdRequest();
        request.setMetricsCollector(this.getCompositeMetricsCollector());
        request.setServiceCallLatencyMetric(Metrics.MetricType.AAX_LATENCY_GET_AD);
        request.setTimeout(this.timeout);
        this.getCompositeMetricsCollector().stopMetric(Metrics.MetricType.AD_LOAD_LATENCY_FETCH_THREAD_START_TO_AAX_GET_AD_START);
        WebRequest.WebResponse response = null;
        this.getCompositeMetricsCollector().incrementMetric(Metrics.MetricType.TLS_ENABLED);
        try {
            response = request.makeCall();
        }
        catch (WebRequest.WebRequestException e) {
            AdError error = null;
            error = e.getStatus() == WebRequest.WebRequestStatus.NETWORK_FAILURE ? new AdError(AdError.ErrorCode.NETWORK_ERROR, "Could not contact Ad Server") : (e.getStatus() == WebRequest.WebRequestStatus.NETWORK_TIMEOUT ? new AdError(AdError.ErrorCode.NETWORK_TIMEOUT, "Connection to Ad Server timed out") : new AdError(AdError.ErrorCode.INTERNAL_ERROR, e.getMessage()));
            throw new AdFetchException(error);
        }
        this.getCompositeMetricsCollector().startMetric(Metrics.MetricType.AD_LOAD_LATENCY_AAX_GET_AD_END_TO_FETCH_THREAD_END);
        return response;
    }

    private MetricsCollector getCompositeMetricsCollector() {
        if (this.compositeMetricsCollector == null) {
            ArrayList<MetricsCollector> collectors = new ArrayList<MetricsCollector>();
            for (Map.Entry<Integer, AdSlot> entry : this.slots.entrySet()) {
                collectors.add(entry.getValue().getAdData().getMetricsCollector());
            }
            this.compositeMetricsCollector = new MetricsCollector.CompositeMetricsCollector(collectors);
        }
        return this.compositeMetricsCollector;
    }

    protected static boolean[] loadAds(int timeout, AdTargetingOptions requestOptions, AdSlot ... adSlots) {
        if (requestOptions == null) {
            requestOptions = new AdTargetingOptions();
        }
        boolean[] responses = new boolean[adSlots.length];
        if (AdLoader.isNoRetry(adSlots)) {
            Arrays.fill(responses, true);
            return responses;
        }
        AtomicInteger numberOfAdsNotReadyYet = new AtomicInteger(adSlots.length);
        AdReadyToLoadListener listener = new AdReadyToLoadListener(timeout, numberOfAdsNotReadyYet, requestOptions, adSlots);
        int numberOfAdsStartedPreparing = 0;
        for (AdSlot adSlot : adSlots) {
            adSlot.setSlotNumber(numberOfAdsStartedPreparing + 1);
            int response = adSlot.getAdWrapper().prepareAd(listener);
            if (response != 0) {
                AdLoader.adFailedToBeReady(timeout, numberOfAdsNotReadyYet, requestOptions, adSlots, numberOfAdsStartedPreparing);
                responses[numberOfAdsStartedPreparing] = response != -1;
            } else {
                responses[numberOfAdsStartedPreparing] = true;
            }
            ++numberOfAdsStartedPreparing;
        }
        return responses;
    }

    protected static boolean[] loadAds(int timeout, AdTargetingOptions requestOptions, Ad ... ads) {
        AdSlot[] slots = new AdSlot[ads.length];
        for (int i = 0; i < ads.length; ++i) {
            slots[i] = new AdSlot(ads[i], new AdTargetingOptions());
        }
        return AdLoader.loadAds(timeout, requestOptions, slots);
    }

    protected static void adFailedToBeReady(int timeout, AtomicInteger waitCount, AdTargetingOptions requestOptions, AdSlot[] adSlots, int slotId) {
        adSlots[slotId].setSlotNumber(-1);
        AdLoader.decrementCount(timeout, waitCount, requestOptions, adSlots);
    }

    protected static void decrementCount(final int timeout, AtomicInteger waitCount, final AdTargetingOptions requestOptions, final AdSlot[] adSlots) {
        if (waitCount.decrementAndGet() == 0) {
            StartUpWaiter waiter = new StartUpWaiter(){

                protected void startUpReady() {
                    InternalAdRegistration.getInstance().register();
                    AdLoader.beginFetchAds(timeout, requestOptions, adSlots);
                }

                protected void startUpFailed() {
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        public void run() {
                            AdError adError = new AdError(AdError.ErrorCode.NETWORK_ERROR, "The configuration was unable to be loaded");
                            AdLoader.failAds(adError, adSlots);
                        }
                    });
                }
            };
            waiter.start();
        }
    }

    private static void beginFetchAds(int timeout, AdTargetingOptions requestOptions, AdSlot[] adSlots) {
        AdvertisingIdentifier advertisingIdentifier = new AdvertisingIdentifier();
        AdvertisingIdentifier.Info advertisingIdentifierInfo = advertisingIdentifier.getAdvertisingIdentifierInfo();
        if (!advertisingIdentifierInfo.canDo()) {
            AdLoader.failAds(new AdError(AdError.ErrorCode.INTERNAL_ERROR, "An internal request was not made on a background thread."), adSlots);
            return;
        }
        AdRequest request = new AdRequest(requestOptions).setAdvertisingIdentifierInfo(advertisingIdentifierInfo);
        HashMap<Integer, AdSlot> goodAdSlots = new HashMap<Integer, AdSlot>();
        for (AdSlot slot : adSlots) {
            if (slot.getSlotNumber() == -1) continue;
            goodAdSlots.put(slot.getSlotNumber(), slot);
            slot.getAdData().setSlotId(slot.getSlotNumber());
            request.putSlot(slot.getAdData(), slot.getAdTargetingOptions());
        }
        if (goodAdSlots.size() > 0) {
            AdLoader adLoader = adLoaderFactory.createAdLoader(request, goodAdSlots);
            adLoader.setTimeout(timeout);
            adLoader.beginFetchAd();
        }
    }

    private static void failAds(AdError adError, AdSlot[] adSlots) {
        int adFailCount = 0;
        for (AdSlot slot : adSlots) {
            if (slot.getSlotNumber() == -1) continue;
            slot.getAdLoaderCallback().adFailed(adError);
            ++adFailCount;
        }
        if (adFailCount > 0) {
            Log.w(LOG_TAG, "%s; code: %s", new Object[]{adError.getMessage(), adError.getCode()});
        }
    }

    private static boolean isNoRetry(AdSlot[] adSlots) {
        int noRetryTtlRemainingMillis = InternalAdRegistration.getInstance().getNoRetryTtlRemainingMillis();
        if (noRetryTtlRemainingMillis > 0) {
            AdError.ErrorCode errorCode;
            int noRetryTtlRemainingSecs = noRetryTtlRemainingMillis / 1000;
            String errorMessage = "SDK Message: ";
            if (InternalAdRegistration.getInstance().getIsAppDisabled()) {
                errorMessage = errorMessage + Utils.getDisabledAppServerMessage();
                errorCode = AdError.ErrorCode.INTERNAL_ERROR;
            } else {
                errorMessage = errorMessage + "no results. Try again in " + noRetryTtlRemainingSecs + " seconds.";
                errorCode = AdError.ErrorCode.NO_FILL;
            }
            Log.e(LOG_TAG, errorMessage);
            AdError adError = new AdError(errorCode, errorMessage);
            for (AdSlot adSlot : adSlots) {
                if (adSlot.getAdData() != null && adSlot.getAdData().getMetricsCollector() != null) {
                    adSlot.getAdData().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_COUNTER_FAILED_DUE_TO_NO_RETRY);
                }
                if (adSlot.getAdLoaderCallback() == null) continue;
                adSlot.getAdLoaderCallback().adFailed(adError);
            }
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AdLoaderFactory {
        protected AdLoaderFactory() {
        }

        public AdLoader createAdLoader(AdRequest adRequest, Map<Integer, AdSlot> slots) {
            return new AdLoader(adRequest, slots);
        }
    }

    protected static class AdReadyToLoadListener {
        private final AtomicInteger waitCount;
        private final AdTargetingOptions requestOptions;
        private final AdSlot[] adSlots;
        private final int timeout;

        public AdReadyToLoadListener(int timeout, AtomicInteger waitCount, AdTargetingOptions requestOptions, AdSlot ... adSlots) {
            this.waitCount = waitCount;
            this.requestOptions = requestOptions;
            this.adSlots = adSlots;
            this.timeout = timeout;
        }

        public void onAdReady(Ad ad) {
            AdLoader.decrementCount(this.timeout, this.waitCount, this.requestOptions, this.adSlots);
        }
    }

    protected class AdFetchException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final AdError adError;

        public AdFetchException(AdError adError) {
            this.adError = adError;
        }

        public AdFetchException(AdError adError, Throwable throwable) {
            super(throwable);
            this.adError = adError;
        }

        public AdError getAdError() {
            return this.adError;
        }
    }
}

