/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.webkit.WebViewDatabase;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.amazon.device.ads.Ad;
import com.amazon.device.ads.AdController;
import com.amazon.device.ads.AdError;
import com.amazon.device.ads.AdListener;
import com.amazon.device.ads.AdLoader;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.AdSlot;
import com.amazon.device.ads.AdTargetingOptions;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.IAdController;
import com.amazon.device.ads.IAdLoaderCallback;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.PermissionChecker;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebViewFactory;
import java.util.Locale;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class AdLayout
extends FrameLayout
implements Ad {
    public static final int DEFAULT_TIMEOUT = 20000;
    private static final String LOG_TAG = "AdLayout";
    private BroadcastReceiver screenStateReceiver;
    private boolean isInForeground;
    private Context context;
    private AdSize adSize;
    private IAdController controller;
    private boolean hasRegisterBroadcastReciever = false;
    private boolean attached = false;
    private int lastVisibility = 8;
    private AtomicBoolean needsToLoadAdOnLayout = new AtomicBoolean(false);
    private AdLoader.AdReadyToLoadListener listenerOnLayout = null;
    private boolean isParentViewMissingAtLoadTime = false;
    private View activityRootView = null;
    private boolean hasPassedActivityValidationCheck = false;
    private long loadAdStartTime = 0L;
    private static ScheduledThreadPoolExecutor threadPool = new ScheduledThreadPoolExecutor(3);
    private boolean shouldDisableWebViewHardwareAcceleration;

    public AdLayout(Activity activity) {
        this(activity, AdSize.SIZE_AUTO);
    }

    public AdLayout(Activity activity, AdSize adSize) {
        super((Context)activity);
        this.initialize((Context)activity, adSize);
    }

    public AdLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize(context, attrs);
    }

    public AdLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialize(context, attrs);
    }

    AdLayout(IAdController adController) {
        super(null);
        this.controller = adController;
        Context context = null;
        AdSize adSize = null;
        this.initialize(context, adSize);
    }

    private void initialize(Context context, AttributeSet attrs) {
        String oldAdsXmlNamespace;
        String adSizeAttributeName = "adSize";
        String adsXmlNamespace = "http://schemas.android.com/apk/lib/com.amazon.device.ads";
        String adSizeAttributeValue = AdLayout.getAttributeValue(attrs, "http://schemas.android.com/apk/lib/com.amazon.device.ads", "adSize");
        if (adSizeAttributeValue == null && (adSizeAttributeValue = AdLayout.getAttributeValue(attrs, oldAdsXmlNamespace = "http://schemas.android.com/apk/res/" + context.getPackageName(), "adSize")) != null) {
            Log.w(true, LOG_TAG, "DEPRECATED - Please use the XML namespace \"http://schemas.android.com/apk/lib/com.amazon.device.ads\" for specifying AdLayout properties.");
            if (adSizeAttributeValue.toLowerCase(Locale.US).equals("custom")) {
                String msg = "Using \"custom\" or \"CUSTOM\" for the \"adSize\" property is no longer supported. Please specifiy a size or remove the property to use Auto Ad Size.";
                Log.e(true, LOG_TAG, msg);
                throw new IllegalArgumentException(msg);
            }
        }
        AdSize adSize = AdLayout.parseAdSize(adSizeAttributeValue);
        this.initialize(context, adSize);
    }

    boolean shouldDisableWebViewHardwareAcceleration() {
        return this.shouldDisableWebViewHardwareAcceleration;
    }

    void setShouldDisableWebViewHardwareAcceleration(boolean shouldDisableWebViewHardwareAcceleration) {
        this.shouldDisableWebViewHardwareAcceleration = shouldDisableWebViewHardwareAcceleration;
    }

    private void initialize(Context context, AdSize size) {
        InternalAdRegistration.getInstance().contextReceived(context);
        if (size == null) {
            size = AdSize.SIZE_AUTO;
        }
        this.adSize = size;
        this.context = context;
        if (this.isInEditMode()) {
            TextView textView = new TextView(this.context);
            textView.setText((CharSequence)LOG_TAG);
            textView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            textView.setGravity(17);
            this.addView((View)textView);
            return;
        }
        this.isInForeground = this.getVisibility() == 0;
        this.setHorizontalScrollBarEnabled(false);
        this.setVerticalScrollBarEnabled(false);
        if (this.isWebViewDatabaseNull(this.context)) {
            Log.e(true, LOG_TAG, "Disabling ads. Local cache file is inaccessible so ads will fail if we try to create a WebView. Details of this Android bug found at: http://code.google.com/p/android/issues/detail?id=10789");
            return;
        }
        if (this.controller == null) {
            this.controller = this.createAdController(this.adSize, this.context);
        }
        this.hasPassedActivityValidationCheck = AdUtils.checkDefinedActivities(this.context);
    }

    private static String getAttributeValue(AttributeSet attrs, String namespace, String name) {
        return attrs.getAttributeValue(namespace, name);
    }

    private static AdSize parseAdSize(String string) {
        AdSize adSize = AdSize.SIZE_AUTO;
        if (string != null && !(string = string.toLowerCase(Locale.US)).equals("auto")) {
            String[] sizes = string.split("x");
            int width = 0;
            int height = 0;
            if (sizes.length == 2) {
                width = Utils.parseInt(sizes[0], width);
                height = Utils.parseInt(sizes[1], height);
            }
            adSize = new AdSize(width, height);
        }
        return adSize;
    }

    IAdController createAdController(AdSize size, Context context) {
        return new AdController(this, size, context);
    }

    boolean isWebViewDatabaseNull(Context context) {
        return WebViewDatabase.getInstance((Context)context) == null;
    }

    private void registerScreenStateBroadcastReceiver() {
        if (this.hasRegisterBroadcastReciever) {
            return;
        }
        this.hasRegisterBroadcastReciever = true;
        this.screenStateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.SCREEN_OFF") && AdLayout.this.isInForeground) {
                    AdLayout.this.controller.sendCommand("close", null);
                }
            }
        };
        IntentFilter filter = new IntentFilter("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        this.context.getApplicationContext().registerReceiver(this.screenStateReceiver, filter);
    }

    private void unregisterScreenStateBroadcastReceiver() {
        if (this.hasRegisterBroadcastReciever) {
            this.hasRegisterBroadcastReciever = false;
            this.context.getApplicationContext().unregisterReceiver(this.screenStateReceiver);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.isInEditMode()) {
            return;
        }
        this.attached = true;
        this.registerScreenStateBroadcastReceiver();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.attached = false;
        this.unregisterScreenStateBroadcastReceiver();
        this.controller.prepareToGoAway();
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (this.attached && this.lastVisibility != visibility) {
            if (visibility != 0) {
                this.isInForeground = false;
                this.unregisterScreenStateBroadcastReceiver();
            } else if (visibility == 0) {
                this.isInForeground = true;
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        super.onLayout(changed, left, top, right, bottom);
        if (this.isInEditMode()) {
            return;
        }
        this.controller.setWindowDimensions(w, h);
        if (this.needsToLoadAdOnLayout.getAndSet(false)) {
            this.loadAdFromAdController(this.listenerOnLayout);
            this.listenerOnLayout = null;
        }
    }

    public int getTimeout() {
        return this.controller.getTimeout();
    }

    public void setTimeout(int timeout) {
        this.controller.setTimeout(timeout);
    }

    public AdSize getAdSize() {
        return this.adSize;
    }

    public boolean loadAd() {
        return this.loadAd(new AdTargetingOptions());
    }

    public boolean loadAd(AdTargetingOptions options) {
        if (options == null) {
            options = new AdTargetingOptions();
        }
        return AdLoader.loadAds(this.controller.getTimeout(), options, new AdSlot(this, options))[0];
    }

    int prepareAd(AdLoader.AdReadyToLoadListener listener) {
        this.loadAdStartTime = System.nanoTime();
        if (this.controller.isAdLoading() || this.needsToLoadAdOnLayout.get()) {
            Log.e(LOG_TAG, "Can't load an ad because ad loading is already in progress");
            return -1;
        }
        if (this.controller.isAdExpanded()) {
            Log.e(LOG_TAG, "Can't load an ad because another ad is currently expanded");
            return -1;
        }
        if (!this.hasPassedActivityValidationCheck) {
            String msg = "Ads cannot load unless \"com.amazon.device.ads.AdActivity\" is correctly declared as an activity in AndroidManifest.xml. Consult the online documentation for more info.";
            this.onRequestError(msg);
            return 1;
        }
        if (!this.passesInternetPermissionCheck(this.context)) {
            String msg = "Ads cannot load because the INTERNET permission is missing from the app's manifest.";
            this.onRequestError(msg);
            return 1;
        }
        String appKey = InternalAdRegistration.getInstance().getRegistrationInfo().getAppKey();
        if (appKey == null) {
            String msg = "Can't load an ad because Application Key has not been set. Did you forget to call AdRegistration.setAppKey( ... )?";
            this.onRequestError(msg);
            return 1;
        }
        if (!this.isWebViewOk(this.context)) {
            String msg = "We will be unable to create a WebView for rendering an ad due to an unknown issue with the WebView.";
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_UNKNOWN_WEBVIEW_ISSUE);
            this.onRequestError(msg);
            return 1;
        }
        if (this.adSize.isAuto()) {
            String msg = "Ad size to be determined automatically.";
            Log.d(LOG_TAG, msg);
        }
        this.setIsParentViewMissingAtLoadTime();
        if (this.isLayoutRequested() && this.adSize.isAuto() && !this.isParentViewMissingAtLoadTime()) {
            this.deferAdLoadToLayoutEvent(listener);
        } else if (this.isParentViewMissingAtLoadTime()) {
            this.loadAdWhenParentViewMissing(listener);
        } else {
            this.loadAdFromAdController(listener);
        }
        return 0;
    }

    private void loadAdWhenParentViewMissing(AdLoader.AdReadyToLoadListener listener) {
        if (this.getLayoutParams() == null) {
            String msg = "Can't load an ad because layout parameters are blank. Use setLayoutParams() to specify dimensions for this AdLayout.";
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_NULL_LAYOUT_PARAMS);
            this.onRequestError(msg);
            return;
        }
        if (Utils.isAtLeastAndroidAPI(11)) {
            this.setActivityRootView();
            if (this.isActivityRootViewNull()) {
                String msg = "Ad load failed because root view could not be obtained from the activity.";
                this.onRequestError(msg);
                return;
            }
            if (this.isActivityRootViewLayoutRequested()) {
                this.deferAdLoadToLayoutEvent(listener);
                this.setOnLayoutChangeListenerForRoot(listener);
            } else {
                this.setFloatingWindowDimensions();
                this.loadAdFromAdController(listener);
            }
        } else {
            this.setFloatingWindowDimensions();
            this.loadAdFromAdController(listener);
        }
    }

    void setOnLayoutChangeListenerForRoot(AdLoader.AdReadyToLoadListener listener) {
        OnLayoutChangeListenerUtil.setOnLayoutChangeListenerForRoot(this, listener);
    }

    void setFloatingWindowDimensions() {
        int floatingWindowWidth = this.resolveLayoutParamForFloatingAd(true);
        int floatingWindowHeight = this.resolveLayoutParamForFloatingAd(false);
        this.controller.setWindowDimensions(floatingWindowWidth, floatingWindowHeight);
    }

    int resolveLayoutParamForFloatingAd(boolean isWidth) {
        int value;
        int n = value = isWidth ? this.getLayoutParams().width : this.getLayoutParams().height;
        if (value == -1) {
            if (this.isActivityRootViewNull()) {
                return this.getRawScreenDimension(isWidth);
            }
            return this.getActivityRootViewDimension(isWidth);
        }
        if (value == -2) {
            return 0;
        }
        return value;
    }

    int getRawScreenDimension(boolean isWidth) {
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        DisplayMetrics metrics = new DisplayMetrics();
        wm.getDefaultDisplay().getMetrics(metrics);
        return isWidth ? metrics.widthPixels : metrics.heightPixels;
    }

    boolean isWebViewOk(Context context) {
        return WebViewFactory.isWebViewOk(context);
    }

    protected boolean passesInternetPermissionCheck(Context context) {
        return PermissionChecker.getInstance().passesInternetPermissionCheck(context);
    }

    void deferAdLoadToLayoutEvent(AdLoader.AdReadyToLoadListener listener) {
        this.needsToLoadAdOnLayout.set(true);
        this.listenerOnLayout = listener;
        this.scheduleTaskForCheckingIfLayoutHasRun();
    }

    void scheduleTaskForCheckingIfLayoutHasRun() {
        Runnable runnable = new Runnable(){

            public void run() {
                AdLayout.this.failLoadIfLayoutHasNotRun();
            }
        };
        threadPool.schedule(runnable, (long)this.getTimeout(), TimeUnit.MILLISECONDS);
    }

    void failLoadIfLayoutHasNotRun() {
        if (this.needsToLoadAdOnLayout.getAndSet(false)) {
            String msg = "Can't load an ad because the view size cannot be determined.";
            Metrics.getInstance().getMetricsCollector().incrementMetric(Metrics.MetricType.AD_FAILED_LAYOUT_NOT_RUN);
            this.onRequestError(msg);
        }
    }

    void onRequestError(String message) {
        Log.e(LOG_TAG, message);
        ((IAdLoaderCallback)((Object)this.controller)).adFailed(new AdError(AdError.ErrorCode.REQUEST_ERROR, message));
    }

    void loadAdFromAdController(AdLoader.AdReadyToLoadListener listener) {
        this.controller.prepareAd(this.loadAdStartTime);
        listener.onAdReady(this);
    }

    boolean getNeedsToLoadAdOnLayout() {
        return this.needsToLoadAdOnLayout.get();
    }

    void setNeedsToLoadAdOnLayout(boolean value) {
        this.needsToLoadAdOnLayout.set(value);
    }

    AdController getAdController() {
        return (AdController)this.controller;
    }

    boolean isParentViewMissingAtLoadTime() {
        return this.isParentViewMissingAtLoadTime;
    }

    void setIsParentViewMissingAtLoadTime() {
        this.isParentViewMissingAtLoadTime = this.getParent() == null;
    }

    void setIsParentViewMissingAtLoadTime(boolean parentViewMissingAtLoadTime) {
        this.isParentViewMissingAtLoadTime = parentViewMissingAtLoadTime;
    }

    View getActivityRootView() {
        return this.activityRootView;
    }

    void setActivityRootView() {
        this.activityRootView = ((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002).getRootView();
    }

    boolean isActivityRootViewLayoutRequested() {
        return this.activityRootView.isLayoutRequested();
    }

    boolean isActivityRootViewNull() {
        return this.activityRootView == null;
    }

    int getActivityRootViewDimension(boolean isWidth) {
        return isWidth ? this.activityRootView.getWidth() : this.activityRootView.getHeight();
    }

    public void setListener(AdListener listener) {
        this.controller.setListener(listener);
    }

    public boolean collapseAd() {
        return this.controller.sendCommand("close", null);
    }

    public boolean isLoading() {
        return this.controller.isAdLoading();
    }

    public boolean isAdLoading() {
        return this.isLoading();
    }

    public void destroy() {
        Log.d(LOG_TAG, "Destroying the AdLayout");
        this.unregisterScreenStateBroadcastReceiver();
        this.controller.destroy();
    }

    private static class OnLayoutChangeListenerUtil {
        private OnLayoutChangeListenerUtil() {
        }

        @TargetApi(value=11)
        protected static void setOnLayoutChangeListenerForRoot(final AdLayout adLayout, final AdLoader.AdReadyToLoadListener loadListener) {
            View.OnLayoutChangeListener listener = new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (adLayout.needsToLoadAdOnLayout.getAndSet(false)) {
                        adLayout.setFloatingWindowDimensions();
                        adLayout.loadAdFromAdController(loadListener);
                        adLayout.activityRootView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    }
                }
            };
            adLayout.activityRootView.addOnLayoutChangeListener(listener);
        }
    }
}

