/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdSize;
import com.amazon.device.ads.MetricsCollector;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdData {
    public static final int CAN_PLAY_AUDIO1_CT = 1001;
    public static final int CAN_PLAY_AUDIO2_CT = 1002;
    public static final int CAN_EXPAND1_CT = 1003;
    public static final int CAN_EXPAND2_CT = 1004;
    public static final int HTML_CT = 1007;
    public static final int INTERSTITIAL_CT = 1008;
    public static final int CAN_PLAY_VIDEO_CT = 1014;
    public static final int MRAID1_CT = 1016;
    public static final int MRAID2_CT = 1017;
    private final AdSize requestedAdSize;
    private String instrPixelUrl;
    private String impPixelUrl;
    private String creative;
    private AdProperties properties;
    private Set<AAXCreative> creativeTypes;
    private int height = 0;
    private int width = 0;
    private int screenHeight = 0;
    private int screenWidth = 0;
    private boolean isRendering;
    private boolean fetched;
    private String connectionType;
    private String maxSize;
    private int slotId;
    private long expirationTimeMs = -1L;
    private MetricsCollector metricsCollector;

    public AdData(AdSize requestedAdSize) {
        this.requestedAdSize = requestedAdSize;
        this.metricsCollector = new MetricsCollector();
    }

    protected AdSize getRequestedAdSize() {
        return this.requestedAdSize;
    }

    protected String getCreative() {
        return this.creative;
    }

    protected void setCreative(String creative) {
        this.creative = creative;
    }

    protected AdProperties getProperties() {
        return this.properties;
    }

    protected void setProperties(AdProperties properties) {
        this.properties = properties;
    }

    protected Set<AAXCreative> getCreativeTypes() {
        return this.creativeTypes;
    }

    protected void setCreativeTypes(Set<AAXCreative> creativeTypes) {
        this.creativeTypes = creativeTypes;
    }

    protected int getHeight() {
        return this.height;
    }

    protected void setHeight(int height) {
        this.height = height;
    }

    protected int getWidth() {
        return this.width;
    }

    protected void setWidth(int width) {
        this.width = width;
    }

    protected int getScreenHeight() {
        return this.screenHeight;
    }

    protected void setScreenHeight(int screenHeight) {
        this.screenHeight = screenHeight;
    }

    protected int getScreenWidth() {
        return this.screenWidth;
    }

    protected void setScreenWidth(int screenWidth) {
        this.screenWidth = screenWidth;
    }

    protected String getInstrumentationPixelUrl() {
        return this.instrPixelUrl;
    }

    protected void setInstrumentationPixelUrl(String instrPixelUrl) {
        this.instrPixelUrl = instrPixelUrl;
    }

    protected String getImpressionPixelUrl() {
        return this.impPixelUrl;
    }

    protected void setImpressionPixelUrl(String impPixelUrl) {
        this.impPixelUrl = impPixelUrl;
    }

    protected boolean getIsRendering() {
        return this.isRendering;
    }

    protected void setIsRendering(boolean isRendering) {
        this.isRendering = isRendering;
    }

    public boolean getIsFetched() {
        return this.fetched;
    }

    public void setFetched(boolean fetched) {
        this.fetched = fetched;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setSlotId(int slotId) {
        this.slotId = slotId;
    }

    public int getSlotId() {
        return this.slotId;
    }

    protected void setExpirationTimeMillis(long expirationTimeMs) {
        this.expirationTimeMs = expirationTimeMs;
    }

    public boolean isExpired() {
        if (this.expirationTimeMs < 0L) {
            return false;
        }
        long time = System.currentTimeMillis();
        return time > this.expirationTimeMs;
    }

    public MetricsCollector getMetricsCollector() {
        return this.metricsCollector;
    }

    public void resetMetricsCollector() {
        this.metricsCollector = new MetricsCollector();
    }

    public void setMaxSize(String maxSize) {
        this.maxSize = maxSize;
    }

    public String getMaxSize() {
        return this.maxSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AAXCreative {
        HTML(1007),
        MRAID1(1016),
        INTERSTITIAL(1008);

        private final int id;

        private AAXCreative(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        static AAXCreative getCreative(int id) {
            switch (id) {
                case 1007: {
                    return HTML;
                }
                case 1016: {
                    return MRAID1;
                }
                case 1008: {
                    return INTERSTITIAL;
                }
            }
            return null;
        }

        static AAXCreative getTopCreative(Set<AAXCreative> creatives) {
            AAXCreative creative = null;
            if (creatives.contains((Object)MRAID1)) {
                creative = MRAID1;
            } else if (creatives.contains((Object)HTML)) {
                creative = HTML;
            }
            return creative;
        }
    }
}

