/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.app.Activity;
import android.os.Bundle;
import com.amazon.device.ads.IAdActivityAdapter;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class AdActivity
extends Activity {
    protected static final String ADAPTER_KEY = "adapter";
    private static final String LOG_TAG = "AdAdapter";
    private IAdActivityAdapter adapter;

    public void onCreate(Bundle savedInstanceState) {
        InternalAdRegistration.getInstance().contextReceived(this.getApplicationContext());
        this.adapter = this.createAdapter();
        if (this.adapter == null) {
            this.finish();
            return;
        }
        this.adapter.setActivity(this);
        this.adapter.preOnCreate();
        super.onCreate(savedInstanceState);
        this.adapter.onCreate();
    }

    IAdActivityAdapter createAdapter() {
        String adapterClassName = this.getIntent().getStringExtra(ADAPTER_KEY);
        if (adapterClassName == null) {
            Log.e(LOG_TAG, "Unable to launch the AdActivity due to an internal error.");
            return null;
        }
        Class<?> adapterClass = null;
        try {
            adapterClass = Class.forName(adapterClassName);
        }
        catch (ClassNotFoundException e) {
            Log.e(LOG_TAG, "Unable to get the adapter class.");
            return null;
        }
        Constructor<?> adapterConstructor = null;
        try {
            adapterConstructor = adapterClass.getDeclaredConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            Log.e(LOG_TAG, "Security exception when trying to get the default constructor.");
            return null;
        }
        catch (NoSuchMethodException e) {
            Log.e(LOG_TAG, "No default constructor exists for the adapter.");
            return null;
        }
        IAdActivityAdapter adapter = null;
        try {
            adapter = (IAdActivityAdapter)adapterConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException e) {
            Log.e(LOG_TAG, "Illegal arguments given to the default constructor.");
            return null;
        }
        catch (InstantiationException e) {
            Log.e(LOG_TAG, "Instantiation exception when instantiating the adapter.");
            return null;
        }
        catch (IllegalAccessException e) {
            Log.e(LOG_TAG, "Illegal access exception when instantiating the adapter.");
            return null;
        }
        catch (InvocationTargetException e) {
            Log.e(LOG_TAG, "Invocation target exception when instantiating the adapter.");
            return null;
        }
        return adapter;
    }

    public void onPause() {
        super.onPause();
        this.adapter.onPause();
    }

    public void onResume() {
        super.onResume();
        this.adapter.onResume();
    }

    public void onStop() {
        this.adapter.onStop();
        super.onStop();
    }
}

