/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.location.Location;
import com.amazon.device.ads.AdLocation;
import com.amazon.device.ads.AdRequest;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.JSONUtils;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.Version;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AAXParameter<T> {
    private static final String LOG_TAG = AAXParameter.class.getSimpleName();
    private final String name;
    private final String debugName;
    static final AAXParameter<String> APP_KEY = new AppKeyParameter();
    static final AAXParameter<String> CHANNEL = new StringParameter("c", "debug.channel");
    static final AAXParameter<String> PUBLISHER_KEYWORDS = new StringParameter("pk", "debug.pk");
    static final AAXParameter<String> PUBLISHER_ASINS = new StringParameter("pa", "debug.pa");
    static final AAXParameter<String> USER_AGENT = new UserAgentParameter();
    static final AAXParameter<String> SDK_VERSION = new SDKVersionParameter();
    static final AAXParameter<String> GEOLOCATION = new GeoLocationParameter();
    static final AAXParameter<JSONObject> USER_INFO = new UserInfoParameter();
    static final AAXParameter<JSONObject> DEVICE_INFO = new DeviceInfoParameter();
    static final AAXParameter<JSONObject> PACKAGE_INFO = new PackageInfoParameter();
    static final AAXParameter<Boolean> TEST = new TestParameter();
    static final AAXParameter<String> SIS_DEVICE_IDENTIFIER = new SISDeviceIdentifierParameter();
    static final AAXParameter<String> SHA1_UDID = new SHA1UDIDParameter();
    static final AAXParameter<String> MD5_UDID = new MD5UDIDParameter();
    static final AAXParameter<JSONArray> SLOTS = new JSONArrayParameter("slots", "debug.slots");
    static final AAXParameter<String> ADVERTISING_IDENTIFIER = new AdvertisingIdentifierParameter();
    static final AAXParameter<Boolean> OPT_OUT = new OptOutParameter();
    static final AAXParameter<String> SIZE = new SizeParameter();
    static final AAXParameter<String> PAGE_TYPE = new StringParameter("pt", "debug.pt");
    static final AAXParameter<String> SLOT = new SlotParameter();
    static final AAXParameter<String> SLOT_POSITION = new StringParameter("sp", "debug.sp");
    static final AAXParameter<String> MAX_SIZE = new MaxSizeParameter();
    static final AAXParameter<Integer> SLOT_ID = new SlotIdParameter();
    static final AAXParameter<Long> FLOOR_PRICE = new FloorPriceParameter();

    AAXParameter(String name, String debugName) {
        this.name = name;
        this.debugName = debugName;
    }

    String getName() {
        return this.name;
    }

    protected String getDebugName() {
        return this.debugName;
    }

    protected boolean hasDebugPropertiesValue() {
        return DebugProperties.containsDebugProperty(this.debugName);
    }

    T getValue(ParameterData parameterData) {
        Object value = null;
        if (this.hasDebugPropertiesValue()) {
            value = this.getFromDebugProperties();
        } else if (parameterData.advancedOptions.containsKey(this.name)) {
            String advancedOption = (String)parameterData.advancedOptions.remove(this.name);
            value = this.parseFromString(advancedOption);
        } else {
            value = this.getDerivedValue(parameterData);
        }
        if (value instanceof String && Utils.isNullOrWhiteSpace(value)) {
            value = null;
        }
        return value;
    }

    protected T getDerivedValue(ParameterData parameterData) {
        return null;
    }

    protected abstract T parseFromString(String var1);

    protected abstract T getFromDebugProperties();

    static class FloorPriceParameter
    extends LongParameter {
        FloorPriceParameter() {
            super("ec", "debug.ec");
        }

        protected Long getDerivedValue(ParameterData parameterData) {
            if (parameterData.loiSlot.getAdTargetingOptions().hasFloorPrice()) {
                return parameterData.loiSlot.getAdTargetingOptions().getFloorPrice();
            }
            return null;
        }
    }

    static class SlotIdParameter
    extends IntegerParameter {
        SlotIdParameter() {
            super("slotId", "debug.slotId");
        }

        protected Integer getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdData().getSlotId();
        }
    }

    static class MaxSizeParameter
    extends StringParameter {
        MaxSizeParameter() {
            super("mxsz", "debug.mxsz");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdData().getMaxSize();
        }
    }

    static class SlotParameter
    extends StringParameter {
        SlotParameter() {
            super("slot", "debug.slot");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.adRequest.getOrientation();
        }
    }

    static class SizeParameter
    extends StringParameter {
        SizeParameter() {
            super("sz", "debug.size");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.loiSlot.getAdData().getRequestedAdSize().toString();
        }
    }

    static class OptOutParameter
    extends BooleanParameter {
        OptOutParameter() {
            super("oo", "debug.optOut");
        }

        protected Boolean getDerivedValue(ParameterData parameterData) {
            if (parameterData.adRequest.getAdvertisingIdentifierInfo().hasAdvertisingIdentifier()) {
                return parameterData.adRequest.getAdvertisingIdentifierInfo().isLimitAdTrackingEnabled();
            }
            return null;
        }
    }

    static class AdvertisingIdentifierParameter
    extends StringParameter {
        AdvertisingIdentifierParameter() {
            super("idfa", "debug.idfa");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            if (parameterData.adRequest.getAdvertisingIdentifierInfo().hasAdvertisingIdentifier()) {
                return parameterData.adRequest.getAdvertisingIdentifierInfo().getAdvertisingIdentifier();
            }
            return null;
        }
    }

    static class MD5UDIDParameter
    extends StringParameter {
        MD5UDIDParameter() {
            super("md5_udid", "debug.md5udid");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            if (!parameterData.adRequest.getAdvertisingIdentifierInfo().hasAdvertisingIdentifier()) {
                return InternalAdRegistration.getInstance().getDeviceInfo().getUdidMd5();
            }
            return null;
        }
    }

    static class SHA1UDIDParameter
    extends StringParameter {
        SHA1UDIDParameter() {
            super("sha1_udid", "debug.sha1udid");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            if (!parameterData.adRequest.getAdvertisingIdentifierInfo().hasAdvertisingIdentifier()) {
                return InternalAdRegistration.getInstance().getDeviceInfo().getUdidSha1();
            }
            return null;
        }
    }

    static class SISDeviceIdentifierParameter
    extends StringParameter {
        SISDeviceIdentifierParameter() {
            super("ad-id", "debug.adid");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return parameterData.adRequest.getAdvertisingIdentifierInfo().getSISDeviceIdentifier();
        }
    }

    static class TestParameter
    extends BooleanParameter {
        TestParameter() {
            super("isTest", "debug.test");
        }

        protected Boolean getDerivedValue(ParameterData parameterData) {
            return Settings.getInstance().getBoolean("testingEnabled", null);
        }
    }

    static class PackageInfoParameter
    extends JSONObjectParameter {
        PackageInfoParameter() {
            super("pkg", "debug.pkg");
        }

        protected JSONObject getDerivedValue(ParameterData parameterData) {
            return InternalAdRegistration.getInstance().getAppInfo().getPackageInfoJSON();
        }
    }

    static class DeviceInfoParameter
    extends JSONObjectParameter {
        DeviceInfoParameter() {
            super("dinfo", "debug.dinfo");
        }

        protected JSONObject getDerivedValue(ParameterData parameterData) {
            return InternalAdRegistration.getInstance().getDeviceInfo().toJsonObject(parameterData.adRequest.getOrientation());
        }
    }

    static class UserInfoParameter
    extends JSONObjectParameter {
        UserInfoParameter() {
            super("uinfo", "debug.ui");
        }

        protected JSONObject getDerivedValue(ParameterData parameterData) {
            if (parameterData.adRequest.getAdTargetingOptions().hasAge()) {
                int age = parameterData.adRequest.getAdTargetingOptions().getAge();
                JSONObject ui = new JSONObject();
                JSONUtils.put(ui, "age", String.valueOf(age));
                return ui;
            }
            return null;
        }
    }

    static class GeoLocationParameter
    extends StringParameter {
        GeoLocationParameter() {
            super("geoloc", "debug.geoloc");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            boolean configSendGeo = Configuration.getInstance().getBoolean(Configuration.ConfigOption.SEND_GEO);
            if (configSendGeo && parameterData.adRequest.getAdTargetingOptions().isGeoLocationEnabled()) {
                AdLocation adLocation = new AdLocation();
                Location location = adLocation.getLocation();
                return location == null ? null : location.getLatitude() + "," + location.getLongitude();
            }
            return null;
        }
    }

    static class SDKVersionParameter
    extends StringParameter {
        SDKVersionParameter() {
            super("adsdk", "debug.ver");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return Version.getSDKVersion();
        }
    }

    static class UserAgentParameter
    extends StringParameter {
        UserAgentParameter() {
            super("ua", "debug.ua");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return DeviceInfo.getUserAgentString();
        }
    }

    static class AppKeyParameter
    extends StringParameter {
        AppKeyParameter() {
            super("appId", "debug.appid");
        }

        protected String getDerivedValue(ParameterData parameterData) {
            return InternalAdRegistration.getInstance().getRegistrationInfo().getAppKey();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JSONObjectParameter
    extends AAXParameter<JSONObject> {
        JSONObjectParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected JSONObject parseFromString(String value) {
            try {
                return new JSONObject(value);
            }
            catch (JSONException e) {
                Log.e(LOG_TAG, "Unable to parse the following value into a JSONObject: %s", this.getName());
                return null;
            }
        }

        @Override
        protected JSONObject getFromDebugProperties() {
            String debugProperty = DebugProperties.getDebugPropertyAsString(this.getDebugName(), null);
            return this.parseFromString(debugProperty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JSONArrayParameter
    extends AAXParameter<JSONArray> {
        JSONArrayParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected JSONArray parseFromString(String value) {
            try {
                return new JSONArray(value);
            }
            catch (JSONException e) {
                Log.e(LOG_TAG, "Unable to parse the following value into a JSONArray: %s", this.getName());
                return null;
            }
        }

        @Override
        protected JSONArray getFromDebugProperties() {
            String debugProperty = DebugProperties.getDebugPropertyAsString(this.getDebugName(), null);
            return this.parseFromString(debugProperty);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LongParameter
    extends AAXParameter<Long> {
        LongParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Long parseFromString(String value) {
            return Long.parseLong(value);
        }

        @Override
        protected Long getFromDebugProperties() {
            return DebugProperties.getDebugPropertyAsLong(this.getDebugName(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IntegerParameter
    extends AAXParameter<Integer> {
        IntegerParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Integer parseFromString(String value) {
            return Integer.parseInt(value);
        }

        @Override
        protected Integer getFromDebugProperties() {
            return DebugProperties.getDebugPropertyAsInteger(this.getDebugName(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BooleanParameter
    extends AAXParameter<Boolean> {
        BooleanParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected Boolean parseFromString(String value) {
            return Boolean.parseBoolean(value);
        }

        @Override
        protected Boolean getFromDebugProperties() {
            return DebugProperties.getDebugPropertyAsBoolean(this.getDebugName(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StringParameter
    extends AAXParameter<String> {
        StringParameter(String name, String debugProperty) {
            super(name, debugProperty);
        }

        @Override
        protected String parseFromString(String value) {
            return value;
        }

        @Override
        protected String getFromDebugProperties() {
            return DebugProperties.getDebugPropertyAsString(this.getDebugName(), null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ParameterData {
        private AdRequest adRequest;
        private Map<String, String> advancedOptions;
        private AdRequest.LOISlot loiSlot;

        ParameterData() {
        }

        ParameterData setAdRequest(AdRequest adRequest) {
            this.adRequest = adRequest;
            return this;
        }

        ParameterData setAdvancedOptions(Map<String, String> advancedOptions) {
            this.advancedOptions = advancedOptions;
            return this;
        }

        ParameterData setLOISlot(AdRequest.LOISlot loiSlot) {
            this.loiSlot = loiSlot;
            return this;
        }
    }
}

