/*
 * Decompiled with CFR 0.152.
 */
package io.card.payment;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.hardware.Camera;
import android.util.Log;
import android.view.SurfaceHolder;
import io.card.payment.CardIOActivity;
import io.card.payment.DetectionInfo;
import io.card.payment.U;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CardScanner
implements Camera.AutoFocusCallback,
Camera.PreviewCallback,
SurfaceHolder.Callback {
    private Bitmap a;
    private static boolean b = false;
    private WeakReference c;
    private boolean d = false;
    private int e = 1;
    private boolean f = true;
    private long g = 0L;
    private long h = 0L;
    private Camera i = null;
    private byte[] j;
    private boolean k = true;
    private boolean l = false;
    private int m;
    private int n;
    private int o;
    private static boolean p;

    public static native boolean nUseNeon();

    public static native boolean nUseTegra();

    private native void nSetup(boolean var1, float var2);

    private native void nResetAnalytics();

    private native void nGetGuideFrame(int var1, int var2, int var3, Rect var4);

    private native void nScanFrame(byte[] var1, int var2, int var3, int var4, DetectionInfo var5, Bitmap var6);

    private native void nSkipFrame();

    private native void nGetFrameCounts(int[] var1);

    private native double nGetElapsedTime();

    private native long nGetElapsedClock();

    private native void nCleanup();

    static boolean a() {
        return !b && (CardScanner.nUseNeon() || CardScanner.nUseTegra());
    }

    CardScanner(CardIOActivity cardIOActivity, int n2) {
        Intent intent = cardIOActivity.getIntent();
        if (intent != null) {
            intent.getBooleanExtra("io.card.payment.suppressScan", false);
            this.d = false;
        }
        this.c = new WeakReference<CardIOActivity>(cardIOActivity);
        this.e = n2;
        this.nSetup(false, 6.0f);
    }

    private Camera b(int n2) {
        long l2 = System.currentTimeMillis();
        if (this.k) {
            do {
                try {
                    return Camera.open();
                }
                catch (RuntimeException runtimeException) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.e((String)"card.io", (String)"Interrupted while waiting for camera", (Throwable)interruptedException);
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"card.io", (String)"Unexpected exception. Please report it to support@card.io", (Throwable)exception);
                    n2 = 0;
                }
            } while (System.currentTimeMillis() - l2 < (long)n2);
        }
        return null;
    }

    final void b() {
        this.f = true;
        this.g = 0L;
        this.h = 0L;
        this.m = 0;
        this.n = 0;
        this.o = 0;
        if (this.k && this.i == null) {
            this.i = this.b(5000);
            if (this.i == null) {
                Log.e((String)"card.io", (String)"prepare scanner couldn't connect to camera!");
                return;
            }
            this.i.setDisplayOrientation(90);
            Camera.Parameters parameters = this.i.getParameters();
            List list = parameters.getSupportedPreviewSizes();
            if (list != null) {
                U.a(list);
                Camera.Size size = null;
                for (Camera.Size size2 : list) {
                    if (size2.width != 640 || size2.height != 480) continue;
                    size = size2;
                    break;
                }
                if (size == null) {
                    size = (Camera.Size)list.get(0);
                    ((Camera.Size)list.get(0)).width = 640;
                    size.height = 480;
                }
            }
            String cfr_ignored_0 = "- parameters: " + parameters;
            parameters.setPreviewSize(640, 480);
            this.i.setParameters(parameters);
        } else if (this.k && this.i != null) {
            String cfr_ignored_1 = "we already have a camera instance: " + this.i;
        }
        if (this.a == null) {
            this.a = Bitmap.createBitmap((int)428, (int)270, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    final boolean a(SurfaceHolder surfaceHolder) {
        String cfr_ignored_0 = "resumeScanning(" + surfaceHolder + ")";
        if (this.i == null) {
            this.b();
        }
        if (this.k && this.i == null) {
            return false;
        }
        assert (surfaceHolder != null);
        if (this.k && this.j == null) {
            String cfr_ignored_1 = "- mCamera:" + this.i;
            int n2 = this.i.getParameters().getPreviewFormat();
            String cfr_ignored_2 = "- preview format: " + n2;
            n2 = ImageFormat.getBitsPerPixel((int)n2) / 8;
            String cfr_ignored_3 = "- bytes per pixel: " + n2;
            n2 = n2 * 307200 * 3;
            String cfr_ignored_4 = "- buffer size: " + n2;
            this.j = new byte[n2];
            this.i.addCallbackBuffer(this.j);
        }
        surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder.setType(3);
        if (this.k) {
            this.i.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        if (this.l) {
            this.b(surfaceHolder);
        }
        this.b(false);
        System.currentTimeMillis();
        this.nResetAnalytics();
        return true;
    }

    public final void c() {
        this.b(false);
        if (this.i != null) {
            try {
                this.i.stopPreview();
                this.i.setPreviewDisplay(null);
            }
            catch (IOException iOException) {}
            this.i.setPreviewCallback(null);
            this.i.release();
            this.j = null;
            this.i = null;
        }
    }

    public final void d() {
        if (this.i != null) {
            this.c();
        }
        this.nCleanup();
        this.j = null;
    }

    private boolean b(SurfaceHolder surfaceHolder) {
        assert (surfaceHolder != null);
        assert (surfaceHolder.getSurface() != null);
        String cfr_ignored_0 = "surfaceFrame: " + String.valueOf(surfaceHolder.getSurfaceFrame());
        this.f = true;
        if (this.k) {
            try {
                this.i.setPreviewDisplay(surfaceHolder);
            }
            catch (IOException iOException) {
                Log.e((String)"card.io", (String)"can't set preview display", (Throwable)iOException);
                return false;
            }
            try {
                this.i.startPreview();
                this.i.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"card.io", (String)"startPreview failed on camera. Error: ", (Throwable)runtimeException);
                return false;
            }
        }
        return true;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.i != null || !this.k) {
            this.l = true;
            this.b(surfaceHolder);
            return;
        }
        Log.wtf((String)"card.io", (String)"CardScanner.surfaceCreated() - camera is null!");
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
        String.format("Preview.surfaceChanged(holder?:%b, f:%d, w:%d, h:%d )", surfaceHolder != null, n2, n3, n4);
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        if (this.i != null) {
            try {
                this.i.stopPreview();
            }
            catch (Exception exception) {
                Log.e((String)"card.io", (String)"error stopping camera", (Throwable)exception);
            }
        }
        this.l = false;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (byArray == null) {
            return;
        }
        if (p) {
            Log.e((String)"CardScanner", (String)"processing in progress.... dropping frame");
            this.nSkipFrame();
            if (camera != null) {
                camera.addCallbackBuffer(byArray);
            }
            return;
        }
        p = true;
        if (this.f) {
            this.f = false;
            this.e = 1;
            ((CardIOActivity)this.c.get()).a();
        }
        DetectionInfo detectionInfo = new DetectionInfo();
        this.nScanFrame(byArray, 640, 480, this.e, detectionInfo, this.a);
        if (!(detectionInfo.focusScore >= 6.0f)) {
            this.a(false);
        } else if (detectionInfo.a()) {
            String cfr_ignored_0 = "detected card: " + detectionInfo.b();
            ((CardIOActivity)this.c.get()).a(this.a, detectionInfo);
        }
        if (camera != null) {
            camera.addCallbackBuffer(byArray);
        }
        p = false;
    }

    void onEdgeUpdate(DetectionInfo detectionInfo) {
        ((CardIOActivity)this.c.get()).a(detectionInfo);
    }

    final Rect a(int n2, int n3) {
        int n4 = n3;
        int n5 = n2;
        n3 = this.e;
        CardScanner cardScanner = this;
        Rect rect = null;
        if (CardScanner.a()) {
            rect = new Rect();
            cardScanner.nGetGuideFrame(n3, n5, n4, rect);
        }
        return rect;
    }

    final void a(int n2) {
        this.e = n2;
    }

    final Map e() {
        HashMap<String, Number> hashMap = new HashMap<String, Number>(11);
        int[] nArray = new int[6];
        this.nGetFrameCounts(nArray);
        hashMap.put("num_frames_total", nArray[0]);
        hashMap.put("num_frames_captured", nArray[1]);
        hashMap.put("num_frames_processed", nArray[2]);
        hashMap.put("num_frames_in_focus", nArray[3]);
        hashMap.put("num_frames_scanned", nArray[4]);
        hashMap.put("num_frames_usable", nArray[5]);
        hashMap.put("elapsed_time", this.nGetElapsedTime());
        hashMap.put("elapsed_clock", this.nGetElapsedClock());
        hashMap.put("num_manual_refocusings", this.m);
        hashMap.put("num_auto_triggered_refocusings", this.n);
        hashMap.put("num_manual_torch_changes", this.o);
        return hashMap;
    }

    public void onAutoFocus(boolean bl2, Camera camera) {
        this.h = System.currentTimeMillis();
    }

    final void a(boolean bl2) {
        if (this.k) {
            CardScanner cardScanner = this;
            if (!(cardScanner.h < cardScanner.g)) {
                try {
                    this.g = System.currentTimeMillis();
                    this.i.autoFocus((Camera.AutoFocusCallback)this);
                    if (bl2) {
                        ++this.m;
                        return;
                    }
                    ++this.n;
                    return;
                }
                catch (RuntimeException runtimeException) {
                    String cfr_ignored_0 = "could not trigger auto focus: " + runtimeException;
                }
            }
        }
    }

    public final boolean f() {
        if (!this.k) {
            return false;
        }
        return this.i.getParameters().getFlashMode().equals("torch");
    }

    public final boolean b(boolean bl2) {
        if (this.i != null) {
            String cfr_ignored_0 = "setFlashOn: " + bl2;
            try {
                Camera.Parameters parameters = this.i.getParameters();
                parameters.setFlashMode(bl2 ? "torch" : "off");
                this.i.setParameters(parameters);
                ++this.o;
                return true;
            }
            catch (RuntimeException runtimeException) {
                String cfr_ignored_1 = "Could not set flash mode: " + runtimeException;
            }
        }
        return false;
    }

    static {
        try {
            System.loadLibrary("cardioDecider");
            String cfr_ignored_0 = "Loaded card.io decider library.  nUseNeon():" + CardScanner.nUseNeon() + ",nUseTegra():" + CardScanner.nUseTegra();
            if (CardScanner.nUseNeon() || CardScanner.nUseTegra()) {
                System.loadLibrary("opencv_core");
                System.loadLibrary("opencv_imgproc");
            }
            if (CardScanner.nUseNeon()) {
                System.loadLibrary("cardioRecognizer");
            } else if (CardScanner.nUseTegra()) {
                System.loadLibrary("cardioRecognizer_tegra2");
            } else {
                b = true;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string = "Failed to load native library: " + unsatisfiedLinkError.getMessage();
            Log.e((String)"card.io", (String)string);
            b = true;
        }
        p = false;
    }
}

