/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wallet;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.iu;
import com.google.android.gms.internal.jf;
import com.google.android.gms.internal.jg;
import com.google.android.gms.internal.ji;
import com.google.android.gms.internal.jj;
import com.google.android.gms.internal.ka;
import com.google.android.gms.wallet.FullWalletRequest;
import com.google.android.gms.wallet.MaskedWalletRequest;
import com.google.android.gms.wallet.NotifyTransactionStatusRequest;
import com.google.android.gms.wallet.Payments;
import java.util.Locale;

public final class Wallet {
    private static final Api.c<jg> wx = new Api.c();
    private static final Api.b<jg, WalletOptions> wy = new Api.b<jg, WalletOptions>(){

        @Override
        public jg a(Context context, Looper looper, fc fc2, WalletOptions walletOptions, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
            fq.b(context instanceof Activity, (Object)"An Activity must be used for Wallet APIs");
            Activity activity = (Activity)context;
            WalletOptions walletOptions2 = walletOptions != null ? walletOptions : new WalletOptions();
            return new jg(activity, looper, connectionCallbacks, onConnectionFailedListener, walletOptions2.environment, fc2.getAccountName(), walletOptions2.theme);
        }

        @Override
        public int getPriority() {
            return Integer.MAX_VALUE;
        }
    };
    public static final Api<WalletOptions> API = new Api<WalletOptions>(wy, wx, new Scope[0]);
    public static final Payments Payments = new jf();
    public static final ka aco = new jj();
    public static final iu acp = new ji();

    @Deprecated
    public static void checkForPreAuthorization(GoogleApiClient googleApiClient, int requestCode) {
        Payments.checkForPreAuthorization(googleApiClient, requestCode);
    }

    @Deprecated
    public static void loadMaskedWallet(GoogleApiClient googleApiClient, MaskedWalletRequest request, int requestCode) {
        Payments.loadMaskedWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void loadFullWallet(GoogleApiClient googleApiClient, FullWalletRequest request, int requestCode) {
        Payments.loadFullWallet(googleApiClient, request, requestCode);
    }

    @Deprecated
    public static void changeMaskedWallet(GoogleApiClient googleApiClient, String googleTransactionId, String merchantTransactionId, int requestCode) {
        Payments.changeMaskedWallet(googleApiClient, googleTransactionId, merchantTransactionId, requestCode);
    }

    @Deprecated
    public static void notifyTransactionStatus(GoogleApiClient googleApiClient, NotifyTransactionStatusRequest request) {
        Payments.notifyTransactionStatus(googleApiClient, request);
    }

    private Wallet() {
    }

    public static abstract class b
    extends a<Status> {
        protected Status f(Status status) {
            return status;
        }

        @Override
        protected /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    public static abstract class a<R extends Result>
    extends a.b<R, jg> {
        public a() {
            super(wx);
        }
    }

    public static final class WalletOptions
    implements Api.ApiOptions.HasOptions {
        public final int environment;
        public final int theme;

        private WalletOptions() {
            this(new Builder());
        }

        private WalletOptions(Builder builder) {
            this.environment = builder.acq;
            this.theme = builder.mTheme;
        }

        public static final class Builder {
            private int acq = 0;
            private int mTheme = 0;

            public Builder setEnvironment(int environment) {
                if (environment != 0 && environment != 2 && environment != 1) {
                    String string2 = String.format(Locale.US, "Invalid environment value %d", environment);
                    throw new IllegalArgumentException(string2);
                }
                this.acq = environment;
                return this;
            }

            public Builder setTheme(int theme) {
                if (theme != 0 && theme != 1) {
                    String string2 = String.format(Locale.US, "Invalid theme value %d", theme);
                    throw new IllegalArgumentException(string2);
                }
                this.mTheme = theme;
                return this;
            }

            public WalletOptions build() {
                return new WalletOptions(this);
            }
        }
    }
}

