/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import android.content.res.Resources;
import com.google.android.gms.internal.c;
import com.google.android.gms.internal.it;
import com.google.android.gms.internal.ks;
import com.google.android.gms.internal.kt;
import com.google.android.gms.tagmanager.ba;
import com.google.android.gms.tagmanager.bg;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.cd;
import com.google.android.gms.tagmanager.cq;
import com.google.android.gms.tagmanager.o;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;

class cp
implements o.f {
    private final Context mContext;
    private final String WJ;
    private final ExecutorService Zm;
    private bg<it.a> Zf;

    cp(Context context, String string2) {
        this.mContext = context;
        this.WJ = string2;
        this.Zm = Executors.newSingleThreadExecutor();
    }

    @Override
    public void a(bg<it.a> bg2) {
        this.Zf = bg2;
    }

    @Override
    public void km() {
        this.Zm.execute(new Runnable(){

            @Override
            public void run() {
                cp.this.lb();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lb() {
        if (this.Zf == null) {
            throw new IllegalStateException("callback must be set before execute");
        }
        this.Zf.kl();
        bh.y("Start loading resource from disk ...");
        if ((cd.kT().kU() == cd.a.YU || cd.kT().kU() == cd.a.YV) && this.WJ.equals(cd.kT().getContainerId())) {
            this.Zf.a(bg.a.Yy);
            return;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.lc());
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.v("resource not on disk");
            this.Zf.a(bg.a.Yy);
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cq.b(fileInputStream, byteArrayOutputStream);
            this.Zf.i(it.a.l(byteArrayOutputStream.toByteArray()));
        }
        catch (IOException iOException) {
            bh.z("error reading resource from disk");
            this.Zf.a(bg.a.Yz);
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bh.z("error closing stream for reading resource from disk");
            }
        }
        bh.y("Load resource from disk finished.");
    }

    @Override
    public void b(final it.a a2) {
        this.Zm.execute(new Runnable(){

            @Override
            public void run() {
                cp.this.c(a2);
            }
        });
    }

    @Override
    public cq.c ca(int n2) {
        bh.y("Atttempting to load container from resource ID " + n2);
        InputStream inputStream = null;
        try {
            inputStream = this.mContext.getResources().openRawResource(n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            cq.b(inputStream, byteArrayOutputStream);
            cq.c c2 = this.a(byteArrayOutputStream);
            if (c2 != null) {
                return c2;
            }
            return this.k(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            bh.z("Error reading default container resource with ID " + n2);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            bh.z("No default container resource found.");
            return null;
        }
    }

    private cq.c a(ByteArrayOutputStream byteArrayOutputStream) {
        try {
            String string2 = byteArrayOutputStream.toString("UTF-8");
            return ba.bG(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bh.v("Tried to convert binary resource to string for JSON parsing; not UTF-8 format");
            return null;
        }
        catch (JSONException jSONException) {
            bh.z("Resource is a UTF-8 encoded string but doesn't contain a JSON container");
            return null;
        }
    }

    private cq.c k(byte[] byArray) {
        try {
            return cq.b(c.f.a(byArray));
        }
        catch (ks ks2) {
            bh.z("Resource doesn't contain a binary container");
            return null;
        }
        catch (cq.g g2) {
            bh.z("Resource doesn't contain a binary container");
            return null;
        }
    }

    @Override
    public synchronized void release() {
        this.Zm.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean c(it.a a2) {
        FileOutputStream fileOutputStream = null;
        File file = this.lc();
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            bh.w("Error opening resource file for writing");
            return false;
        }
        try {
            fileOutputStream.write(kt.d(a2));
            boolean bl2 = true;
            return bl2;
        }
        catch (IOException iOException) {
            bh.z("Error writing resource to disk. Removing resource from disk.");
            file.delete();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                bh.z("error closing stream for writing resource to disk");
            }
        }
        return false;
    }

    File lc() {
        String string2 = "resource_" + this.WJ;
        File file = this.mContext.getDir("google_tagmanager", 0);
        return new File(file, string2);
    }
}

