/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tagmanager;

import android.content.Context;
import com.google.android.gms.internal.c;
import com.google.android.gms.tagmanager.DataLayer;
import com.google.android.gms.tagmanager.ag;
import com.google.android.gms.tagmanager.bh;
import com.google.android.gms.tagmanager.bq;
import com.google.android.gms.tagmanager.cd;
import com.google.android.gms.tagmanager.cq;
import com.google.android.gms.tagmanager.cs;
import com.google.android.gms.tagmanager.dh;
import com.google.android.gms.tagmanager.s;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Container {
    private final Context mContext;
    private final String WJ;
    private final DataLayer WK;
    private cs WL;
    private Map<String, FunctionCallMacroCallback> WM = new HashMap<String, FunctionCallMacroCallback>();
    private Map<String, FunctionCallTagCallback> WN = new HashMap<String, FunctionCallTagCallback>();
    private volatile long WO;
    private volatile String WP = "";

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, cq.c resource) {
        this.mContext = context;
        this.WK = dataLayer;
        this.WJ = containerId;
        this.WO = lastRefreshTime;
        this.a(resource);
    }

    Container(Context context, DataLayer dataLayer, String containerId, long lastRefreshTime, c.j resource) {
        this.mContext = context;
        this.WK = dataLayer;
        this.WJ = containerId;
        this.WO = lastRefreshTime;
        this.a(resource.fK);
        if (resource.fJ != null) {
            this.a(resource.fJ);
        }
    }

    public String getContainerId() {
        return this.WJ;
    }

    public boolean getBoolean(String key) {
        cs cs2 = this.kd();
        if (cs2 == null) {
            bh.w("getBoolean called for closed container.");
            return dh.lQ();
        }
        try {
            return dh.n(cs2.bR(key).getObject());
        }
        catch (Exception exception) {
            bh.w("Calling getBoolean() threw an exception: " + exception.getMessage() + " Returning default value.");
            return dh.lQ();
        }
    }

    public double getDouble(String key) {
        cs cs2 = this.kd();
        if (cs2 == null) {
            bh.w("getDouble called for closed container.");
            return dh.lP();
        }
        try {
            return dh.m(cs2.bR(key).getObject());
        }
        catch (Exception exception) {
            bh.w("Calling getDouble() threw an exception: " + exception.getMessage() + " Returning default value.");
            return dh.lP();
        }
    }

    public long getLong(String key) {
        cs cs2 = this.kd();
        if (cs2 == null) {
            bh.w("getLong called for closed container.");
            return dh.lO();
        }
        try {
            return dh.l(cs2.bR(key).getObject());
        }
        catch (Exception exception) {
            bh.w("Calling getLong() threw an exception: " + exception.getMessage() + " Returning default value.");
            return dh.lO();
        }
    }

    public String getString(String key) {
        cs cs2 = this.kd();
        if (cs2 == null) {
            bh.w("getString called for closed container.");
            return dh.lS();
        }
        try {
            return dh.j(cs2.bR(key).getObject());
        }
        catch (Exception exception) {
            bh.w("Calling getString() threw an exception: " + exception.getMessage() + " Returning default value.");
            return dh.lS();
        }
    }

    public long getLastRefreshTime() {
        return this.WO;
    }

    public boolean isDefault() {
        return this.getLastRefreshTime() == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallMacroCallback(String customMacroName, FunctionCallMacroCallback customMacroCallback) {
        if (customMacroCallback == null) {
            throw new NullPointerException("Macro handler must be non-null");
        }
        Map<String, FunctionCallMacroCallback> map = this.WM;
        synchronized (map) {
            this.WM.put(customMacroName, customMacroCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallMacroCallback(String customMacroName) {
        Map<String, FunctionCallMacroCallback> map = this.WM;
        synchronized (map) {
            this.WM.remove(customMacroName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallMacroCallback bn(String string2) {
        Map<String, FunctionCallMacroCallback> map = this.WM;
        synchronized (map) {
            return this.WM.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunctionCallTagCallback(String customTagName, FunctionCallTagCallback customTagCallback) {
        if (customTagCallback == null) {
            throw new NullPointerException("Tag callback must be non-null");
        }
        Map<String, FunctionCallTagCallback> map = this.WN;
        synchronized (map) {
            this.WN.put(customTagName, customTagCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterFunctionCallTagCallback(String customTagName) {
        Map<String, FunctionCallTagCallback> map = this.WN;
        synchronized (map) {
            this.WN.remove(customTagName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FunctionCallTagCallback bo(String string2) {
        Map<String, FunctionCallTagCallback> map = this.WN;
        synchronized (map) {
            return this.WN.get(string2);
        }
    }

    void bp(String string2) {
        this.kd().bp(string2);
    }

    String kc() {
        return this.WP;
    }

    private void a(c.f f2) {
        if (f2 == null) {
            throw new NullPointerException();
        }
        cq.c c2 = null;
        try {
            c2 = cq.b(f2);
        }
        catch (cq.g g2) {
            bh.w("Not loading resource: " + f2 + " because it is invalid: " + g2.toString());
            return;
        }
        this.a(c2);
    }

    private void a(c.i[] iArray) {
        ArrayList<c.i> arrayList = new ArrayList<c.i>();
        for (c.i i2 : iArray) {
            arrayList.add(i2);
        }
        this.kd().e(arrayList);
    }

    private void a(cq.c c2) {
        this.WP = c2.getVersion();
        ag ag2 = this.bq(this.WP);
        cs cs2 = new cs(this.mContext, c2, this.WK, new a(), new b(), ag2);
        this.a(cs2);
    }

    ag bq(String string2) {
        if (cd.kT().kU().equals((Object)cd.a.YV)) {
            // empty if block
        }
        return new bq();
    }

    private synchronized void a(cs cs2) {
        this.WL = cs2;
    }

    private synchronized cs kd() {
        return this.WL;
    }

    void release() {
        this.WL = null;
    }

    private class b
    implements s.a {
        private b() {
        }

        @Override
        public Object b(String string2, Map<String, Object> map) {
            FunctionCallTagCallback functionCallTagCallback = Container.this.bo(string2);
            if (functionCallTagCallback != null) {
                functionCallTagCallback.execute(string2, map);
            }
            return dh.lS();
        }
    }

    private class a
    implements s.a {
        private a() {
        }

        @Override
        public Object b(String string2, Map<String, Object> map) {
            FunctionCallMacroCallback functionCallMacroCallback = Container.this.bn(string2);
            return functionCallMacroCallback == null ? null : functionCallMacroCallback.getValue(string2, map);
        }
    }

    public static interface FunctionCallTagCallback {
        public void execute(String var1, Map<String, Object> var2);
    }

    public static interface FunctionCallMacroCallback {
        public Object getValue(String var1, Map<String, Object> var2);
    }
}

