/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.PolylineOptionsCreator;
import com.google.android.gms.maps.model.h;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class PolylineOptions
implements SafeParcelable {
    public static final PolylineOptionsCreator CREATOR = new PolylineOptionsCreator();
    private final int xH;
    private final List<LatLng> Tn;
    private float SS = 10.0f;
    private int Av = -16777216;
    private float SN = 0.0f;
    private boolean SO = true;
    private boolean Tp = false;

    public PolylineOptions() {
        this.xH = 1;
        this.Tn = new ArrayList<LatLng>();
    }

    PolylineOptions(int versionCode, List points, float width, int color2, float zIndex, boolean visible, boolean geodesic) {
        this.xH = versionCode;
        this.Tn = points;
        this.SS = width;
        this.Av = color2;
        this.SN = zIndex;
        this.SO = visible;
        this.Tp = geodesic;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.iB()) {
            h.a(this, out, flags);
        } else {
            PolylineOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    int getVersionCode() {
        return this.xH;
    }

    public PolylineOptions add(LatLng point) {
        this.Tn.add(point);
        return this;
    }

    public PolylineOptions add(LatLng ... points) {
        this.Tn.addAll(Arrays.asList(points));
        return this;
    }

    public PolylineOptions addAll(Iterable<LatLng> points) {
        for (LatLng latLng : points) {
            this.Tn.add(latLng);
        }
        return this;
    }

    public PolylineOptions width(float width) {
        this.SS = width;
        return this;
    }

    public PolylineOptions color(int color2) {
        this.Av = color2;
        return this;
    }

    public PolylineOptions zIndex(float zIndex) {
        this.SN = zIndex;
        return this;
    }

    public PolylineOptions visible(boolean visible) {
        this.SO = visible;
        return this;
    }

    public PolylineOptions geodesic(boolean geodesic) {
        this.Tp = geodesic;
        return this;
    }

    public List<LatLng> getPoints() {
        return this.Tn;
    }

    public float getWidth() {
        return this.SS;
    }

    public int getColor() {
        return this.Av;
    }

    public float getZIndex() {
        return this.SN;
    }

    public boolean isVisible() {
        return this.SO;
    }

    public boolean isGeodesic() {
        return this.Tp;
    }
}

