/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps.model;

import android.os.IBinder;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.dynamic.d;
import com.google.android.gms.internal.fq;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.BitmapDescriptor;
import com.google.android.gms.maps.model.GroundOverlayOptionsCreator;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.c;

public final class GroundOverlayOptions
implements SafeParcelable {
    public static final GroundOverlayOptionsCreator CREATOR = new GroundOverlayOptionsCreator();
    public static final float NO_DIMENSION = -1.0f;
    private final int xH;
    private BitmapDescriptor SQ;
    private LatLng SR;
    private float SS;
    private float ST;
    private LatLngBounds SU;
    private float SG;
    private float SN;
    private boolean SO = true;
    private float SV = 0.0f;
    private float SW = 0.5f;
    private float SX = 0.5f;

    GroundOverlayOptions(int versionCode, IBinder wrappedImage, LatLng location, float width, float height, LatLngBounds bounds, float bearing, float zIndex, boolean visible, float transparency, float anchorU, float anchorV) {
        this.xH = versionCode;
        this.SQ = new BitmapDescriptor(d.a.K(wrappedImage));
        this.SR = location;
        this.SS = width;
        this.ST = height;
        this.SU = bounds;
        this.SG = bearing;
        this.SN = zIndex;
        this.SO = visible;
        this.SV = transparency;
        this.SW = anchorU;
        this.SX = anchorV;
    }

    public GroundOverlayOptions() {
        this.xH = 1;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.iB()) {
            c.a(this, out, flags);
        } else {
            GroundOverlayOptionsCreator.a(this, out, flags);
        }
    }

    public int describeContents() {
        return 0;
    }

    IBinder iD() {
        return this.SQ.id().asBinder();
    }

    public GroundOverlayOptions image(BitmapDescriptor image) {
        this.SQ = image;
        return this;
    }

    public GroundOverlayOptions anchor(float u2, float v2) {
        this.SW = u2;
        this.SX = v2;
        return this;
    }

    public GroundOverlayOptions position(LatLng location, float width) {
        fq.a(this.SU == null, "Position has already been set using positionFromBounds");
        fq.b(location != null, (Object)"Location must be specified");
        fq.b(width >= 0.0f, (Object)"Width must be non-negative");
        return this.a(location, width, -1.0f);
    }

    public GroundOverlayOptions position(LatLng location, float width, float height) {
        fq.a(this.SU == null, "Position has already been set using positionFromBounds");
        fq.b(location != null, (Object)"Location must be specified");
        fq.b(width >= 0.0f, (Object)"Width must be non-negative");
        fq.b(height >= 0.0f, (Object)"Height must be non-negative");
        return this.a(location, width, height);
    }

    private GroundOverlayOptions a(LatLng latLng, float f2, float f3) {
        this.SR = latLng;
        this.SS = f2;
        this.ST = f3;
        return this;
    }

    public GroundOverlayOptions positionFromBounds(LatLngBounds bounds) {
        fq.a(this.SR == null, "Position has already been set using position: " + this.SR);
        this.SU = bounds;
        return this;
    }

    public GroundOverlayOptions bearing(float bearing) {
        this.SG = (bearing % 360.0f + 360.0f) % 360.0f;
        return this;
    }

    public GroundOverlayOptions zIndex(float zIndex) {
        this.SN = zIndex;
        return this;
    }

    public GroundOverlayOptions visible(boolean visible) {
        this.SO = visible;
        return this;
    }

    public GroundOverlayOptions transparency(float transparency) {
        fq.b(transparency >= 0.0f && transparency <= 1.0f, (Object)"Transparency must be in the range [0..1]");
        this.SV = transparency;
        return this;
    }

    int getVersionCode() {
        return this.xH;
    }

    public BitmapDescriptor getImage() {
        return this.SQ;
    }

    public LatLng getLocation() {
        return this.SR;
    }

    public float getWidth() {
        return this.SS;
    }

    public float getHeight() {
        return this.ST;
    }

    public LatLngBounds getBounds() {
        return this.SU;
    }

    public float getBearing() {
        return this.SG;
    }

    public float getZIndex() {
        return this.SN;
    }

    public float getTransparency() {
        return this.SV;
    }

    public float getAnchorU() {
        return this.SW;
    }

    public float getAnchorV() {
        return this.SX;
    }

    public boolean isVisible() {
        return this.SO;
    }
}

