/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.maps;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Parcel;
import android.util.AttributeSet;
import com.google.android.gms.R;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.maps.GoogleMapOptionsCreator;
import com.google.android.gms.maps.a;
import com.google.android.gms.maps.internal.v;
import com.google.android.gms.maps.model.CameraPosition;

public final class GoogleMapOptions
implements SafeParcelable {
    public static final GoogleMapOptionsCreator CREATOR = new GoogleMapOptionsCreator();
    private final int xH;
    private Boolean RI;
    private Boolean RJ;
    private int RK = -1;
    private CameraPosition RL;
    private Boolean RM;
    private Boolean RN;
    private Boolean RO;
    private Boolean RP;
    private Boolean RQ;
    private Boolean RR;

    GoogleMapOptions(int versionCode, byte zOrderOnTop, byte useViewLifecycleInFragment, int mapType, CameraPosition camera, byte zoomControlsEnabled, byte compassEnabled, byte scrollGesturesEnabled, byte zoomGesturesEnabled, byte tiltGesturesEnabled, byte rotateGesturesEnabled) {
        this.xH = versionCode;
        this.RI = com.google.android.gms.maps.internal.a.a(zOrderOnTop);
        this.RJ = com.google.android.gms.maps.internal.a.a(useViewLifecycleInFragment);
        this.RK = mapType;
        this.RL = camera;
        this.RM = com.google.android.gms.maps.internal.a.a(zoomControlsEnabled);
        this.RN = com.google.android.gms.maps.internal.a.a(compassEnabled);
        this.RO = com.google.android.gms.maps.internal.a.a(scrollGesturesEnabled);
        this.RP = com.google.android.gms.maps.internal.a.a(zoomGesturesEnabled);
        this.RQ = com.google.android.gms.maps.internal.a.a(tiltGesturesEnabled);
        this.RR = com.google.android.gms.maps.internal.a.a(rotateGesturesEnabled);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        if (v.iB()) {
            a.a(this, out, flags);
        } else {
            GoogleMapOptionsCreator.a(this, out, flags);
        }
    }

    int getVersionCode() {
        return this.xH;
    }

    byte ig() {
        return com.google.android.gms.maps.internal.a.c(this.RI);
    }

    byte ih() {
        return com.google.android.gms.maps.internal.a.c(this.RJ);
    }

    byte ii() {
        return com.google.android.gms.maps.internal.a.c(this.RM);
    }

    byte ij() {
        return com.google.android.gms.maps.internal.a.c(this.RN);
    }

    byte ik() {
        return com.google.android.gms.maps.internal.a.c(this.RO);
    }

    byte il() {
        return com.google.android.gms.maps.internal.a.c(this.RP);
    }

    byte im() {
        return com.google.android.gms.maps.internal.a.c(this.RQ);
    }

    byte in() {
        return com.google.android.gms.maps.internal.a.c(this.RR);
    }

    public GoogleMapOptions() {
        this.xH = 1;
    }

    public GoogleMapOptions zOrderOnTop(boolean zOrderOnTop) {
        this.RI = zOrderOnTop;
        return this;
    }

    public GoogleMapOptions useViewLifecycleInFragment(boolean useViewLifecycleInFragment) {
        this.RJ = useViewLifecycleInFragment;
        return this;
    }

    public GoogleMapOptions mapType(int mapType) {
        this.RK = mapType;
        return this;
    }

    public GoogleMapOptions camera(CameraPosition camera) {
        this.RL = camera;
        return this;
    }

    public GoogleMapOptions zoomControlsEnabled(boolean enabled) {
        this.RM = enabled;
        return this;
    }

    public GoogleMapOptions compassEnabled(boolean enabled) {
        this.RN = enabled;
        return this;
    }

    public GoogleMapOptions scrollGesturesEnabled(boolean enabled) {
        this.RO = enabled;
        return this;
    }

    public GoogleMapOptions zoomGesturesEnabled(boolean enabled) {
        this.RP = enabled;
        return this;
    }

    public GoogleMapOptions tiltGesturesEnabled(boolean enabled) {
        this.RQ = enabled;
        return this;
    }

    public GoogleMapOptions rotateGesturesEnabled(boolean enabled) {
        this.RR = enabled;
        return this;
    }

    public Boolean getZOrderOnTop() {
        return this.RI;
    }

    public Boolean getUseViewLifecycleInFragment() {
        return this.RJ;
    }

    public int getMapType() {
        return this.RK;
    }

    public CameraPosition getCamera() {
        return this.RL;
    }

    public Boolean getZoomControlsEnabled() {
        return this.RM;
    }

    public Boolean getCompassEnabled() {
        return this.RN;
    }

    public Boolean getScrollGesturesEnabled() {
        return this.RO;
    }

    public Boolean getZoomGesturesEnabled() {
        return this.RP;
    }

    public Boolean getTiltGesturesEnabled() {
        return this.RQ;
    }

    public Boolean getRotateGesturesEnabled() {
        return this.RR;
    }

    public static GoogleMapOptions createFromAttributes(Context context, AttributeSet attrs) {
        if (attrs == null) {
            return null;
        }
        TypedArray typedArray = context.getResources().obtainAttributes(attrs, R.styleable.MapAttrs);
        GoogleMapOptions googleMapOptions = new GoogleMapOptions();
        if (typedArray.hasValue(0)) {
            googleMapOptions.mapType(typedArray.getInt(0, -1));
        }
        if (typedArray.hasValue(13)) {
            googleMapOptions.zOrderOnTop(typedArray.getBoolean(13, false));
        }
        if (typedArray.hasValue(12)) {
            googleMapOptions.useViewLifecycleInFragment(typedArray.getBoolean(12, false));
        }
        if (typedArray.hasValue(6)) {
            googleMapOptions.compassEnabled(typedArray.getBoolean(6, true));
        }
        if (typedArray.hasValue(7)) {
            googleMapOptions.rotateGesturesEnabled(typedArray.getBoolean(7, true));
        }
        if (typedArray.hasValue(8)) {
            googleMapOptions.scrollGesturesEnabled(typedArray.getBoolean(8, true));
        }
        if (typedArray.hasValue(9)) {
            googleMapOptions.tiltGesturesEnabled(typedArray.getBoolean(9, true));
        }
        if (typedArray.hasValue(11)) {
            googleMapOptions.zoomGesturesEnabled(typedArray.getBoolean(11, true));
        }
        if (typedArray.hasValue(10)) {
            googleMapOptions.zoomControlsEnabled(typedArray.getBoolean(10, true));
        }
        CameraPosition cameraPosition = CameraPosition.createFromAttributes(context, attrs);
        googleMapOptions.camera(cameraPosition);
        typedArray.recycle();
        return googleMapOptions;
    }
}

