/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Looper;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.hc;
import com.google.android.gms.internal.hd;
import com.google.android.gms.location.Geofence;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import java.util.ArrayList;
import java.util.List;

public class LocationClient
implements GooglePlayServicesClient {
    public static final String KEY_LOCATION_CHANGED = "com.google.android.location.LOCATION";
    public static final String KEY_MOCK_LOCATION = "mockLocation";
    private final hc NO;

    public LocationClient(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener connectionFailedListener) {
        this.NO = new hc(context, connectionCallbacks, connectionFailedListener, "location");
    }

    public void addGeofences(List<Geofence> geofences, PendingIntent pendingIntent, OnAddGeofencesResultListener listener) {
        ArrayList<hd> arrayList = null;
        if (geofences != null) {
            arrayList = new ArrayList<hd>();
            for (Geofence geofence : geofences) {
                fq.b(geofence instanceof hd, (Object)"Geofence must be created using Geofence.Builder.");
                arrayList.add((hd)geofence);
            }
        }
        this.NO.addGeofences(arrayList, pendingIntent, listener);
    }

    public void removeGeofences(PendingIntent pendingIntent, OnRemoveGeofencesResultListener listener) {
        this.NO.removeGeofences(pendingIntent, listener);
    }

    public void removeGeofences(List<String> geofenceRequestIds, OnRemoveGeofencesResultListener listener) {
        this.NO.removeGeofences(geofenceRequestIds, listener);
    }

    public static boolean hasError(Intent intent) {
        return intent.hasExtra("gms_error_code");
    }

    public static int getErrorCode(Intent intent) {
        return intent.getIntExtra("gms_error_code", -1);
    }

    public static int getGeofenceTransition(Intent intent) {
        int n2 = intent.getIntExtra("com.google.android.location.intent.extra.transition", -1);
        if (n2 == -1) {
            return -1;
        }
        if (n2 == 1 || n2 == 2 || n2 == 4) {
            return n2;
        }
        return -1;
    }

    public static List<Geofence> getTriggeringGeofences(Intent intent) {
        ArrayList arrayList = (ArrayList)intent.getSerializableExtra("com.google.android.location.intent.extra.geofence_list");
        if (arrayList == null) {
            return null;
        }
        ArrayList<Geofence> arrayList2 = new ArrayList<Geofence>(arrayList.size());
        for (byte[] byArray : arrayList) {
            arrayList2.add(hd.h(byArray));
        }
        return arrayList2;
    }

    public Location getLastLocation() {
        return this.NO.getLastLocation();
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener) {
        this.NO.requestLocationUpdates(request, listener);
    }

    public void requestLocationUpdates(LocationRequest request, LocationListener listener, Looper looper) {
        this.NO.requestLocationUpdates(request, listener, looper);
    }

    public void requestLocationUpdates(LocationRequest request, PendingIntent callbackIntent) {
        this.NO.requestLocationUpdates(request, callbackIntent);
    }

    public void removeLocationUpdates(LocationListener listener) {
        this.NO.removeLocationUpdates(listener);
    }

    public void removeLocationUpdates(PendingIntent callbackIntent) {
        this.NO.removeLocationUpdates(callbackIntent);
    }

    public void setMockMode(boolean isMockMode) {
        this.NO.setMockMode(isMockMode);
    }

    public void setMockLocation(Location mockLocation) {
        this.NO.setMockLocation(mockLocation);
    }

    @Override
    public void connect() {
        this.NO.connect();
    }

    @Override
    public void disconnect() {
        this.NO.disconnect();
    }

    @Override
    public boolean isConnected() {
        return this.NO.isConnected();
    }

    @Override
    public boolean isConnecting() {
        return this.NO.isConnecting();
    }

    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.NO.registerConnectionCallbacks(listener);
    }

    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        return this.NO.isConnectionCallbacksRegistered(listener);
    }

    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        this.NO.unregisterConnectionCallbacks(listener);
    }

    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.NO.registerConnectionFailedListener(listener);
    }

    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        return this.NO.isConnectionFailedListenerRegistered(listener);
    }

    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        this.NO.unregisterConnectionFailedListener(listener);
    }

    public static interface OnRemoveGeofencesResultListener {
        public void onRemoveGeofencesByRequestIdsResult(int var1, String[] var2);

        public void onRemoveGeofencesByPendingIntentResult(int var1, PendingIntent var2);
    }

    public static interface OnAddGeofencesResultListener {
        public void onAddGeofencesResult(int var1, String[] var2);
    }
}

