/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.request;

import android.os.Bundle;
import android.os.Parcel;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.request.GameRequest;
import com.google.android.gms.games.request.GameRequestEntityCreator;
import com.google.android.gms.internal.fo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class GameRequestEntity
implements SafeParcelable,
GameRequest {
    public static final GameRequestEntityCreator CREATOR = new GameRequestEntityCreator();
    private final int xH;
    private final GameEntity Lt;
    private final PlayerEntity Nm;
    private final byte[] Nf;
    private final String Jo;
    private final ArrayList<PlayerEntity> Nn;
    private final int LF;
    private final long Mu;
    private final long No;
    private final Bundle Np;
    private final int MB;

    public GameRequestEntity(GameRequest request) {
        this.xH = 2;
        this.Lt = new GameEntity(request.getGame());
        this.Nm = new PlayerEntity(request.getSender());
        this.Jo = request.getRequestId();
        this.LF = request.getType();
        this.Mu = request.getCreationTimestamp();
        this.No = request.getExpirationTimestamp();
        this.MB = request.getStatus();
        byte[] byArray = request.getData();
        if (byArray == null) {
            this.Nf = null;
        } else {
            this.Nf = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.Nf, 0, byArray.length);
        }
        List<Player> list = request.getRecipients();
        int n2 = list.size();
        this.Nn = new ArrayList(n2);
        this.Np = new Bundle();
        for (int i2 = 0; i2 < n2; ++i2) {
            Player player = (Player)list.get(i2).freeze();
            String string2 = player.getPlayerId();
            this.Nn.add((PlayerEntity)player);
            this.Np.putInt(string2, request.getRecipientStatus(string2));
        }
    }

    GameRequestEntity(int versionCode, GameEntity game, PlayerEntity sender, byte[] data, String requestId, ArrayList<PlayerEntity> recipients, int type, long creationTimestamp, long expirationTimestamp, Bundle recipientStatuses, int status) {
        this.xH = versionCode;
        this.Lt = game;
        this.Nm = sender;
        this.Nf = data;
        this.Jo = requestId;
        this.Nn = recipients;
        this.LF = type;
        this.Mu = creationTimestamp;
        this.No = expirationTimestamp;
        this.Np = recipientStatuses;
        this.MB = status;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public String getRequestId() {
        return this.Jo;
    }

    @Override
    public Game getGame() {
        return this.Lt;
    }

    @Override
    public Player getSender() {
        return this.Nm;
    }

    @Override
    public List<Player> getRecipients() {
        return new ArrayList<Player>(this.Nn);
    }

    @Override
    public boolean isConsumed(String playerId) {
        return this.getRecipientStatus(playerId) == 1;
    }

    @Override
    public byte[] getData() {
        return this.Nf;
    }

    @Override
    public int getType() {
        return this.LF;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Mu;
    }

    @Override
    public long getExpirationTimestamp() {
        return this.No;
    }

    @Override
    public int getRecipientStatus(String playerId) {
        return this.Np.getInt(playerId, 0);
    }

    @Override
    public int getStatus() {
        return this.MB;
    }

    public Bundle hK() {
        return this.Np;
    }

    @Override
    public GameRequest freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return GameRequestEntity.a(this);
    }

    static int a(GameRequest gameRequest) {
        return fo.hashCode(gameRequest.getGame(), gameRequest.getRecipients(), gameRequest.getRequestId(), gameRequest.getSender(), GameRequestEntity.b(gameRequest), gameRequest.getType(), gameRequest.getCreationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    public boolean equals(Object obj) {
        return GameRequestEntity.a(this, obj);
    }

    static boolean a(GameRequest gameRequest, Object object) {
        if (!(object instanceof GameRequest)) {
            return false;
        }
        if (gameRequest == object) {
            return true;
        }
        GameRequest gameRequest2 = (GameRequest)object;
        return fo.equal(gameRequest2.getGame(), gameRequest.getGame()) && fo.equal(gameRequest2.getRecipients(), gameRequest.getRecipients()) && fo.equal(gameRequest2.getRequestId(), gameRequest.getRequestId()) && fo.equal(gameRequest2.getSender(), gameRequest.getSender()) && Arrays.equals(GameRequestEntity.b(gameRequest2), GameRequestEntity.b(gameRequest)) && fo.equal(gameRequest2.getType(), gameRequest.getType()) && fo.equal(gameRequest2.getCreationTimestamp(), gameRequest.getCreationTimestamp()) && fo.equal(gameRequest2.getExpirationTimestamp(), gameRequest.getExpirationTimestamp());
    }

    private static int[] b(GameRequest gameRequest) {
        List<Player> list = gameRequest.getRecipients();
        int n2 = list.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = gameRequest.getRecipientStatus(list.get(i2).getPlayerId());
        }
        return nArray;
    }

    public String toString() {
        return GameRequestEntity.c(this);
    }

    static String c(GameRequest gameRequest) {
        return fo.e(gameRequest).a("Game", gameRequest.getGame()).a("Sender", gameRequest.getSender()).a("Recipients", gameRequest.getRecipients()).a("Data", gameRequest.getData()).a("RequestId", gameRequest.getRequestId()).a("Type", gameRequest.getType()).a("CreationTimestamp", gameRequest.getCreationTimestamp()).a("ExpirationTimestamp", gameRequest.getExpirationTimestamp()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        GameRequestEntityCreator.a(this, dest, flags);
    }
}

