/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.database.CharArrayBuffer;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntityCreator;
import com.google.android.gms.games.multiplayer.ParticipantResult;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.gm;

public final class ParticipantEntity
extends GamesDowngradeableSafeParcel
implements Participant {
    public static final Parcelable.Creator<ParticipantEntity> CREATOR = new ParticipantEntityCreatorCompat();
    private final int xH;
    private final String Jg;
    private final String HA;
    private final Uri HF;
    private final Uri HG;
    private final int MB;
    private final String Is;
    private final boolean MC;
    private final PlayerEntity LH;
    private final int MD;
    private final ParticipantResult ME;
    private final String HQ;
    private final String HR;

    public ParticipantEntity(Participant participant) {
        this.xH = 3;
        this.Jg = participant.getParticipantId();
        this.HA = participant.getDisplayName();
        this.HF = participant.getIconImageUri();
        this.HG = participant.getHiResImageUri();
        this.MB = participant.getStatus();
        this.Is = participant.gi();
        this.MC = participant.isConnectedToRoom();
        Player player = participant.getPlayer();
        this.LH = player == null ? null : new PlayerEntity(player);
        this.MD = participant.getCapabilities();
        this.ME = participant.getResult();
        this.HQ = participant.getIconImageUrl();
        this.HR = participant.getHiResImageUrl();
    }

    ParticipantEntity(int versionCode, String participantId, String displayName, Uri iconImageUri, Uri hiResImageUri, int status, String clientAddress, boolean connectedToRoom, PlayerEntity player, int capabilities, ParticipantResult result, String iconImageUrl, String hiResImageUrl) {
        this.xH = versionCode;
        this.Jg = participantId;
        this.HA = displayName;
        this.HF = iconImageUri;
        this.HG = hiResImageUri;
        this.MB = status;
        this.Is = clientAddress;
        this.MC = connectedToRoom;
        this.LH = player;
        this.MD = capabilities;
        this.ME = result;
        this.HQ = iconImageUrl;
        this.HR = hiResImageUrl;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public int getStatus() {
        return this.MB;
    }

    @Override
    public String gi() {
        return this.Is;
    }

    @Override
    public boolean isConnectedToRoom() {
        return this.MC;
    }

    @Override
    public String getDisplayName() {
        if (this.LH == null) {
            return this.HA;
        }
        return this.LH.getDisplayName();
    }

    @Override
    public void getDisplayName(CharArrayBuffer dataOut) {
        if (this.LH == null) {
            gm.b(this.HA, dataOut);
            return;
        }
        this.LH.getDisplayName(dataOut);
    }

    @Override
    public Uri getIconImageUri() {
        if (this.LH == null) {
            return this.HF;
        }
        return this.LH.getIconImageUri();
    }

    @Override
    public String getIconImageUrl() {
        if (this.LH == null) {
            return this.HQ;
        }
        return this.LH.getIconImageUrl();
    }

    @Override
    public Uri getHiResImageUri() {
        if (this.LH == null) {
            return this.HG;
        }
        return this.LH.getHiResImageUri();
    }

    @Override
    public String getHiResImageUrl() {
        if (this.LH == null) {
            return this.HR;
        }
        return this.LH.getHiResImageUrl();
    }

    @Override
    public String getParticipantId() {
        return this.Jg;
    }

    @Override
    public Player getPlayer() {
        return this.LH;
    }

    @Override
    public ParticipantResult getResult() {
        return this.ME;
    }

    @Override
    public int getCapabilities() {
        return this.MD;
    }

    @Override
    public Participant freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ParticipantEntity.a(this);
    }

    static int a(Participant participant) {
        return fo.hashCode(participant.getPlayer(), participant.getStatus(), participant.gi(), participant.isConnectedToRoom(), participant.getDisplayName(), participant.getIconImageUri(), participant.getHiResImageUri(), participant.getCapabilities(), participant.getResult(), participant.getParticipantId());
    }

    public boolean equals(Object obj) {
        return ParticipantEntity.a(this, obj);
    }

    static boolean a(Participant participant, Object object) {
        if (!(object instanceof Participant)) {
            return false;
        }
        if (participant == object) {
            return true;
        }
        Participant participant2 = (Participant)object;
        return fo.equal(participant2.getPlayer(), participant.getPlayer()) && fo.equal(participant2.getStatus(), participant.getStatus()) && fo.equal(participant2.gi(), participant.gi()) && fo.equal(participant2.isConnectedToRoom(), participant.isConnectedToRoom()) && fo.equal(participant2.getDisplayName(), participant.getDisplayName()) && fo.equal(participant2.getIconImageUri(), participant.getIconImageUri()) && fo.equal(participant2.getHiResImageUri(), participant.getHiResImageUri()) && fo.equal(participant2.getCapabilities(), participant.getCapabilities()) && fo.equal(participant2.getResult(), participant.getResult()) && fo.equal(participant2.getParticipantId(), participant.getParticipantId());
    }

    public String toString() {
        return ParticipantEntity.b(this);
    }

    static String b(Participant participant) {
        return fo.e(participant).a("ParticipantId", participant.getParticipantId()).a("Player", participant.getPlayer()).a("Status", participant.getStatus()).a("ClientAddress", participant.gi()).a("ConnectedToRoom", participant.isConnectedToRoom()).a("DisplayName", participant.getDisplayName()).a("IconImage", participant.getIconImageUri()).a("IconImageUrl", participant.getIconImageUrl()).a("HiResImage", participant.getHiResImageUri()).a("HiResImageUrl", participant.getHiResImageUrl()).a("Capabilities", participant.getCapabilities()).a("Result", participant.getResult()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.eK()) {
            ParticipantEntityCreator.a(this, dest, flags);
        } else {
            dest.writeString(this.Jg);
            dest.writeString(this.HA);
            dest.writeString(this.HF == null ? null : this.HF.toString());
            dest.writeString(this.HG == null ? null : this.HG.toString());
            dest.writeInt(this.MB);
            dest.writeString(this.Is);
            dest.writeInt(this.MC ? 1 : 0);
            dest.writeInt(this.LH == null ? 0 : 1);
            if (this.LH != null) {
                this.LH.writeToParcel(dest, flags);
            }
        }
    }

    static final class ParticipantEntityCreatorCompat
    extends ParticipantEntityCreator {
        ParticipantEntityCreatorCompat() {
        }

        @Override
        public ParticipantEntity av(Parcel parcel) {
            boolean bl2 = ParticipantEntity.c(ParticipantEntity.eJ());
            if (bl2 || ParticipantEntity.al(ParticipantEntity.class.getCanonicalName())) {
                return super.av(parcel);
            }
            String string2 = parcel.readString();
            String string3 = parcel.readString();
            String string4 = parcel.readString();
            Uri uri = string4 == null ? null : Uri.parse((String)string4);
            String string5 = parcel.readString();
            Uri uri2 = string5 == null ? null : Uri.parse((String)string5);
            int n2 = parcel.readInt();
            String string6 = parcel.readString();
            boolean bl3 = parcel.readInt() > 0;
            boolean bl4 = parcel.readInt() > 0;
            int n3 = 7;
            ParticipantResult participantResult = null;
            String string7 = null;
            String string8 = null;
            PlayerEntity playerEntity = bl4 ? (PlayerEntity)PlayerEntity.CREATOR.createFromParcel(parcel) : null;
            return new ParticipantEntity(3, string2, string3, uri, uri2, n2, string6, bl3, playerEntity, n3, participantResult, string7, string8);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.av(x0);
        }
    }
}

