/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.multiplayer;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.multiplayer.Invitation;
import com.google.android.gms.games.multiplayer.InvitationEntityCreator;
import com.google.android.gms.games.multiplayer.Participant;
import com.google.android.gms.games.multiplayer.ParticipantEntity;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;

public final class InvitationEntity
extends GamesDowngradeableSafeParcel
implements Invitation {
    public static final Parcelable.Creator<InvitationEntity> CREATOR = new InvitationEntityCreatorCompat();
    private final int xH;
    private final GameEntity Lt;
    private final String IV;
    private final long Mu;
    private final int Mv;
    private final ParticipantEntity Mw;
    private final ArrayList<ParticipantEntity> Mx;
    private final int My;
    private final int Mz;

    InvitationEntity(Invitation invitation) {
        this.xH = 2;
        this.Lt = new GameEntity(invitation.getGame());
        this.IV = invitation.getInvitationId();
        this.Mu = invitation.getCreationTimestamp();
        this.Mv = invitation.getInvitationType();
        this.My = invitation.getVariant();
        this.Mz = invitation.getAvailableAutoMatchSlots();
        String string2 = invitation.getInviter().getParticipantId();
        Participant participant = null;
        ArrayList arrayList = invitation.getParticipants();
        int n2 = arrayList.size();
        this.Mx = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Participant participant2 = (Participant)arrayList.get(i2);
            if (participant2.getParticipantId().equals(string2)) {
                participant = participant2;
            }
            this.Mx.add((ParticipantEntity)participant2.freeze());
        }
        fq.b(participant, (Object)"Must have a valid inviter!");
        this.Mw = (ParticipantEntity)participant.freeze();
    }

    InvitationEntity(int versionCode, GameEntity game, String invitationId, long creationTimestamp, int invitationType, ParticipantEntity inviter, ArrayList<ParticipantEntity> participants, int variant, int availableAutoMatchSlots) {
        this.xH = versionCode;
        this.Lt = game;
        this.IV = invitationId;
        this.Mu = creationTimestamp;
        this.Mv = invitationType;
        this.Mw = inviter;
        this.Mx = participants;
        this.My = variant;
        this.Mz = availableAutoMatchSlots;
    }

    public int getVersionCode() {
        return this.xH;
    }

    @Override
    public Game getGame() {
        return this.Lt;
    }

    @Override
    public String getInvitationId() {
        return this.IV;
    }

    @Override
    public Participant getInviter() {
        return this.Mw;
    }

    @Override
    public long getCreationTimestamp() {
        return this.Mu;
    }

    @Override
    public ArrayList<Participant> getParticipants() {
        return new ArrayList<Participant>(this.Mx);
    }

    @Override
    public int getInvitationType() {
        return this.Mv;
    }

    @Override
    public int getVariant() {
        return this.My;
    }

    @Override
    public int getAvailableAutoMatchSlots() {
        return this.Mz;
    }

    @Override
    public Invitation freeze() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return InvitationEntity.a(this);
    }

    static int a(Invitation invitation) {
        return fo.hashCode(invitation.getGame(), invitation.getInvitationId(), invitation.getCreationTimestamp(), invitation.getInvitationType(), invitation.getInviter(), invitation.getParticipants(), invitation.getVariant(), invitation.getAvailableAutoMatchSlots());
    }

    public boolean equals(Object obj) {
        return InvitationEntity.a(this, obj);
    }

    static boolean a(Invitation invitation, Object object) {
        if (!(object instanceof Invitation)) {
            return false;
        }
        if (invitation == object) {
            return true;
        }
        Invitation invitation2 = (Invitation)object;
        return fo.equal(invitation2.getGame(), invitation.getGame()) && fo.equal(invitation2.getInvitationId(), invitation.getInvitationId()) && fo.equal(invitation2.getCreationTimestamp(), invitation.getCreationTimestamp()) && fo.equal(invitation2.getInvitationType(), invitation.getInvitationType()) && fo.equal(invitation2.getInviter(), invitation.getInviter()) && fo.equal(invitation2.getParticipants(), invitation.getParticipants()) && fo.equal(invitation2.getVariant(), invitation.getVariant()) && fo.equal(invitation2.getAvailableAutoMatchSlots(), invitation.getAvailableAutoMatchSlots());
    }

    public String toString() {
        return InvitationEntity.b(this);
    }

    static String b(Invitation invitation) {
        return fo.e(invitation).a("Game", invitation.getGame()).a("InvitationId", invitation.getInvitationId()).a("CreationTimestamp", invitation.getCreationTimestamp()).a("InvitationType", invitation.getInvitationType()).a("Inviter", invitation.getInviter()).a("Participants", invitation.getParticipants()).a("Variant", invitation.getVariant()).a("AvailableAutoMatchSlots", invitation.getAvailableAutoMatchSlots()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.eK()) {
            InvitationEntityCreator.a(this, dest, flags);
        } else {
            this.Lt.writeToParcel(dest, flags);
            dest.writeString(this.IV);
            dest.writeLong(this.Mu);
            dest.writeInt(this.Mv);
            this.Mw.writeToParcel(dest, flags);
            int n2 = this.Mx.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.Mx.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    static final class InvitationEntityCreatorCompat
    extends InvitationEntityCreator {
        InvitationEntityCreatorCompat() {
        }

        @Override
        public InvitationEntity au(Parcel parcel) {
            int n2;
            boolean bl2 = InvitationEntity.c(InvitationEntity.eJ());
            if (bl2 || InvitationEntity.al(InvitationEntity.class.getCanonicalName())) {
                return super.au(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            String string2 = parcel.readString();
            long l2 = parcel.readLong();
            int n3 = parcel.readInt();
            ParticipantEntity participantEntity = (ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel);
            int n4 = parcel.readInt();
            ArrayList<ParticipantEntity> arrayList = new ArrayList<ParticipantEntity>(n4);
            for (n2 = 0; n2 < n4; ++n2) {
                arrayList.add((ParticipantEntity)ParticipantEntity.CREATOR.createFromParcel(parcel));
            }
            n2 = -1;
            int n5 = 0;
            return new InvitationEntity(2, gameEntity, string2, l2, n3, participantEntity, arrayList, n2, n5);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.au(x0);
        }
    }
}

