/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.leaderboard;

import android.database.CharArrayBuffer;
import android.net.Uri;
import com.google.android.gms.games.Player;
import com.google.android.gms.games.PlayerEntity;
import com.google.android.gms.games.leaderboard.LeaderboardScore;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.gm;

public final class LeaderboardScoreEntity
implements LeaderboardScore {
    private final long LU;
    private final String LV;
    private final String LW;
    private final long LX;
    private final long LY;
    private final String LZ;
    private final Uri Ma;
    private final Uri Mb;
    private final PlayerEntity Mc;
    private final String Md;
    private final String Me;
    private final String Mf;

    public LeaderboardScoreEntity(LeaderboardScore score) {
        this.LU = score.getRank();
        this.LV = fq.f(score.getDisplayRank());
        this.LW = fq.f(score.getDisplayScore());
        this.LX = score.getRawScore();
        this.LY = score.getTimestampMillis();
        this.LZ = score.getScoreHolderDisplayName();
        this.Ma = score.getScoreHolderIconImageUri();
        this.Mb = score.getScoreHolderHiResImageUri();
        Player player = score.getScoreHolder();
        this.Mc = player == null ? null : (PlayerEntity)player.freeze();
        this.Md = score.getScoreTag();
        this.Me = score.getScoreHolderIconImageUrl();
        this.Mf = score.getScoreHolderHiResImageUrl();
    }

    @Override
    public long getRank() {
        return this.LU;
    }

    @Override
    public String getDisplayRank() {
        return this.LV;
    }

    @Override
    public void getDisplayRank(CharArrayBuffer dataOut) {
        gm.b(this.LV, dataOut);
    }

    @Override
    public String getDisplayScore() {
        return this.LW;
    }

    @Override
    public void getDisplayScore(CharArrayBuffer dataOut) {
        gm.b(this.LW, dataOut);
    }

    @Override
    public long getRawScore() {
        return this.LX;
    }

    @Override
    public long getTimestampMillis() {
        return this.LY;
    }

    @Override
    public String getScoreHolderDisplayName() {
        if (this.Mc == null) {
            return this.LZ;
        }
        return this.Mc.getDisplayName();
    }

    @Override
    public void getScoreHolderDisplayName(CharArrayBuffer dataOut) {
        if (this.Mc == null) {
            gm.b(this.LZ, dataOut);
            return;
        }
        this.Mc.getDisplayName(dataOut);
    }

    @Override
    public Uri getScoreHolderIconImageUri() {
        if (this.Mc == null) {
            return this.Ma;
        }
        return this.Mc.getIconImageUri();
    }

    @Override
    public String getScoreHolderIconImageUrl() {
        if (this.Mc == null) {
            return this.Me;
        }
        return this.Mc.getIconImageUrl();
    }

    @Override
    public Uri getScoreHolderHiResImageUri() {
        if (this.Mc == null) {
            return this.Mb;
        }
        return this.Mc.getHiResImageUri();
    }

    @Override
    public String getScoreHolderHiResImageUrl() {
        if (this.Mc == null) {
            return this.Mf;
        }
        return this.Mc.getHiResImageUrl();
    }

    @Override
    public Player getScoreHolder() {
        return this.Mc;
    }

    @Override
    public String getScoreTag() {
        return this.Md;
    }

    public LeaderboardScore hF() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return LeaderboardScoreEntity.a(this);
    }

    static int a(LeaderboardScore leaderboardScore) {
        return fo.hashCode(leaderboardScore.getRank(), leaderboardScore.getDisplayRank(), leaderboardScore.getRawScore(), leaderboardScore.getDisplayScore(), leaderboardScore.getTimestampMillis(), leaderboardScore.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolder());
    }

    public boolean equals(Object obj) {
        return LeaderboardScoreEntity.a(this, obj);
    }

    static boolean a(LeaderboardScore leaderboardScore, Object object) {
        if (!(object instanceof LeaderboardScore)) {
            return false;
        }
        if (leaderboardScore == object) {
            return true;
        }
        LeaderboardScore leaderboardScore2 = (LeaderboardScore)object;
        return fo.equal(leaderboardScore2.getRank(), leaderboardScore.getRank()) && fo.equal(leaderboardScore2.getDisplayRank(), leaderboardScore.getDisplayRank()) && fo.equal(leaderboardScore2.getRawScore(), leaderboardScore.getRawScore()) && fo.equal(leaderboardScore2.getDisplayScore(), leaderboardScore.getDisplayScore()) && fo.equal(leaderboardScore2.getTimestampMillis(), leaderboardScore.getTimestampMillis()) && fo.equal(leaderboardScore2.getScoreHolderDisplayName(), leaderboardScore.getScoreHolderDisplayName()) && fo.equal(leaderboardScore2.getScoreHolderIconImageUri(), leaderboardScore.getScoreHolderIconImageUri()) && fo.equal(leaderboardScore2.getScoreHolderHiResImageUri(), leaderboardScore.getScoreHolderHiResImageUri()) && fo.equal(leaderboardScore2.getScoreHolder(), leaderboardScore.getScoreHolder()) && fo.equal(leaderboardScore2.getScoreTag(), leaderboardScore.getScoreTag());
    }

    public String toString() {
        return LeaderboardScoreEntity.b(this);
    }

    static String b(LeaderboardScore leaderboardScore) {
        return fo.e(leaderboardScore).a("Rank", leaderboardScore.getRank()).a("DisplayRank", leaderboardScore.getDisplayRank()).a("Score", leaderboardScore.getRawScore()).a("DisplayScore", leaderboardScore.getDisplayScore()).a("Timestamp", leaderboardScore.getTimestampMillis()).a("DisplayName", leaderboardScore.getScoreHolderDisplayName()).a("IconImageUri", leaderboardScore.getScoreHolderIconImageUri()).a("IconImageUrl", leaderboardScore.getScoreHolderIconImageUrl()).a("HiResImageUri", leaderboardScore.getScoreHolderHiResImageUri()).a("HiResImageUrl", leaderboardScore.getScoreHolderHiResImageUrl()).a("Player", leaderboardScore.getScoreHolder() == null ? null : leaderboardScore.getScoreHolder()).a("ScoreTag", leaderboardScore.getScoreTag()).toString();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.hF();
    }
}

