/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.games.internal.game;

import android.os.Parcel;
import com.google.android.gms.games.Game;
import com.google.android.gms.games.GameEntity;
import com.google.android.gms.games.internal.GamesDowngradeableSafeParcel;
import com.google.android.gms.games.internal.game.ExtendedGame;
import com.google.android.gms.games.internal.game.ExtendedGameEntityCreator;
import com.google.android.gms.games.internal.game.GameBadge;
import com.google.android.gms.games.internal.game.GameBadgeEntity;
import com.google.android.gms.internal.fo;
import java.util.ArrayList;

public final class ExtendedGameEntity
extends GamesDowngradeableSafeParcel
implements ExtendedGame {
    public static final ExtendedGameEntityCreator CREATOR = new ExtendedGameEntityCreatorCompat();
    private final int xH;
    private final GameEntity Lt;
    private final int Lu;
    private final boolean Lv;
    private final int Lw;
    private final long Lx;
    private final long Ly;
    private final String Lz;
    private final long LA;
    private final String LB;
    private final ArrayList<GameBadgeEntity> LC;

    public ExtendedGameEntity(ExtendedGame extendedGame) {
        this.xH = 1;
        Game game = extendedGame.getGame();
        this.Lt = game == null ? null : new GameEntity(game);
        this.Lu = extendedGame.gX();
        this.Lv = extendedGame.gY();
        this.Lw = extendedGame.gZ();
        this.Lx = extendedGame.ha();
        this.Ly = extendedGame.hb();
        this.Lz = extendedGame.hc();
        this.LA = extendedGame.hd();
        this.LB = extendedGame.he();
        ArrayList<GameBadge> arrayList = extendedGame.gW();
        int n2 = arrayList.size();
        this.LC = new ArrayList(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.LC.add((GameBadgeEntity)arrayList.get(i2).freeze());
        }
    }

    ExtendedGameEntity(int versionCode, GameEntity game, int availability, boolean owned, int achievementUnlockedCount, long lastPlayedServerTimestamp, long priceMicros, String formattedPrice, long fullPriceMicros, String formattedFullPrice, ArrayList<GameBadgeEntity> badges) {
        this.xH = versionCode;
        this.Lt = game;
        this.Lu = availability;
        this.Lv = owned;
        this.Lw = achievementUnlockedCount;
        this.Lx = lastPlayedServerTimestamp;
        this.Ly = priceMicros;
        this.Lz = formattedPrice;
        this.LA = fullPriceMicros;
        this.LB = formattedFullPrice;
        this.LC = badges;
    }

    public int getVersionCode() {
        return this.xH;
    }

    public GameEntity hf() {
        return this.Lt;
    }

    @Override
    public ArrayList<GameBadge> gW() {
        return new ArrayList<GameBadge>(this.LC);
    }

    @Override
    public int gX() {
        return this.Lu;
    }

    @Override
    public boolean gY() {
        return this.Lv;
    }

    @Override
    public int gZ() {
        return this.Lw;
    }

    @Override
    public long ha() {
        return this.Lx;
    }

    @Override
    public long hb() {
        return this.Ly;
    }

    @Override
    public String hc() {
        return this.Lz;
    }

    @Override
    public long hd() {
        return this.LA;
    }

    @Override
    public String he() {
        return this.LB;
    }

    public ExtendedGame hg() {
        return this;
    }

    @Override
    public boolean isDataValid() {
        return true;
    }

    public int hashCode() {
        return ExtendedGameEntity.a(this);
    }

    static int a(ExtendedGame extendedGame) {
        return fo.hashCode(extendedGame.getGame(), extendedGame.gX(), extendedGame.gY(), extendedGame.gZ(), extendedGame.ha(), extendedGame.hb(), extendedGame.hc(), extendedGame.hd(), extendedGame.he());
    }

    public boolean equals(Object obj) {
        return ExtendedGameEntity.a(this, obj);
    }

    static boolean a(ExtendedGame extendedGame, Object object) {
        if (!(object instanceof ExtendedGame)) {
            return false;
        }
        if (extendedGame == object) {
            return true;
        }
        ExtendedGame extendedGame2 = (ExtendedGame)object;
        return fo.equal(extendedGame2.getGame(), extendedGame.getGame()) && fo.equal(extendedGame2.gX(), extendedGame.gX()) && fo.equal(extendedGame2.gY(), extendedGame.gY()) && fo.equal(extendedGame2.gZ(), extendedGame.gZ()) && fo.equal(extendedGame2.ha(), extendedGame.ha()) && fo.equal(extendedGame2.hb(), extendedGame.hb()) && fo.equal(extendedGame2.hc(), extendedGame.hc()) && fo.equal(extendedGame2.hd(), extendedGame.hd()) && fo.equal(extendedGame2.he(), extendedGame.he());
    }

    public String toString() {
        return ExtendedGameEntity.b(this);
    }

    static String b(ExtendedGame extendedGame) {
        return fo.e(extendedGame).a("Game", extendedGame.getGame()).a("Availability", extendedGame.gX()).a("Owned", extendedGame.gY()).a("AchievementUnlockedCount", extendedGame.gZ()).a("LastPlayedServerTimestamp", extendedGame.ha()).a("PriceMicros", extendedGame.hb()).a("FormattedPrice", extendedGame.hc()).a("FullPriceMicros", extendedGame.hd()).a("FormattedFullPrice", extendedGame.he()).toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (!this.eK()) {
            ExtendedGameEntityCreator.a(this, dest, flags);
        } else {
            this.Lt.writeToParcel(dest, flags);
            dest.writeInt(this.Lu);
            dest.writeInt(this.Lv ? 1 : 0);
            dest.writeInt(this.Lw);
            dest.writeLong(this.Lx);
            dest.writeLong(this.Ly);
            dest.writeString(this.Lz);
            dest.writeLong(this.LA);
            dest.writeString(this.LB);
            int n2 = this.LC.size();
            dest.writeInt(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.LC.get(i2).writeToParcel(dest, flags);
            }
        }
    }

    @Override
    public /* synthetic */ Game getGame() {
        return this.hf();
    }

    @Override
    public /* synthetic */ Object freeze() {
        return this.hg();
    }

    static final class ExtendedGameEntityCreatorCompat
    extends ExtendedGameEntityCreator {
        ExtendedGameEntityCreatorCompat() {
        }

        @Override
        public ExtendedGameEntity aq(Parcel parcel) {
            boolean bl2 = ExtendedGameEntity.c(ExtendedGameEntity.eJ());
            if (bl2 || ExtendedGameEntity.al(ExtendedGameEntity.class.getCanonicalName())) {
                return super.aq(parcel);
            }
            GameEntity gameEntity = (GameEntity)GameEntity.CREATOR.createFromParcel(parcel);
            int n2 = parcel.readInt();
            boolean bl3 = parcel.readInt() == 1;
            int n3 = parcel.readInt();
            long l2 = parcel.readLong();
            long l3 = parcel.readLong();
            String string2 = parcel.readString();
            long l4 = parcel.readLong();
            String string3 = parcel.readString();
            int n4 = parcel.readInt();
            ArrayList<GameBadgeEntity> arrayList = new ArrayList<GameBadgeEntity>(n4);
            for (int i2 = 0; i2 < n4; ++i2) {
                arrayList.add(GameBadgeEntity.CREATOR.ar(parcel));
            }
            return new ExtendedGameEntity(1, gameEntity, n2, bl3, n3, l2, l3, string2, l4, string3, arrayList);
        }

        @Override
        public /* synthetic */ Object createFromParcel(Parcel x0) {
            return this.aq(x0);
        }
    }
}

