/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.drive.internal;

import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.a;
import com.google.android.gms.drive.Contents;
import com.google.android.gms.drive.Drive;
import com.google.android.gms.drive.DriveApi;
import com.google.android.gms.drive.DriveFile;
import com.google.android.gms.drive.DriveId;
import com.google.android.gms.drive.MetadataChangeSet;
import com.google.android.gms.drive.internal.CloseContentsAndUpdateMetadataRequest;
import com.google.android.gms.drive.internal.CloseContentsRequest;
import com.google.android.gms.drive.internal.OnContentsResponse;
import com.google.android.gms.drive.internal.OnDownloadProgressResponse;
import com.google.android.gms.drive.internal.OpenContentsRequest;
import com.google.android.gms.drive.internal.al;
import com.google.android.gms.drive.internal.l;
import com.google.android.gms.drive.internal.m;
import com.google.android.gms.drive.internal.n;
import com.google.android.gms.drive.internal.r;
import com.google.android.gms.drive.internal.v;

public class o
extends r
implements DriveFile {
    public o(DriveId driveId) {
        super(driveId);
    }

    @Override
    public PendingResult<DriveApi.ContentsResult> openContents(GoogleApiClient apiClient, final int mode, final DriveFile.DownloadProgressListener listener) {
        if (mode != 0x10000000 && mode != 0x20000000 && mode != 0x30000000) {
            throw new IllegalArgumentException("Invalid mode provided.");
        }
        return apiClient.a(new d(){

            @Override
            protected void a(n n2) throws RemoteException {
                n2.fE().a(new OpenContentsRequest(o.this.getDriveId(), mode), (v)new c(this, listener));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new b(){

            @Override
            protected void a(n n2) throws RemoteException {
                contents.close();
                n2.fE().a(new CloseContentsRequest(contents, true), (v)new al(this));
            }
        });
    }

    @Override
    public PendingResult<Status> commitAndCloseContents(GoogleApiClient apiClient, final Contents contents, final MetadataChangeSet changeSet) {
        if (contents == null) {
            throw new IllegalArgumentException("Contents must be provided.");
        }
        return apiClient.b(new a(){

            @Override
            protected void a(n n2) throws RemoteException {
                contents.close();
                n2.fE().a(new CloseContentsAndUpdateMetadataRequest(o.this.Ew, changeSet.fD(), contents), (v)new al(this));
            }
        });
    }

    @Override
    public PendingResult<Status> discardContents(GoogleApiClient apiClient, Contents contents) {
        return Drive.DriveApi.discardContents(apiClient, contents);
    }

    private abstract class a
    extends m<Status> {
        private a() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    private abstract class b
    extends m<Status> {
        private b() {
        }

        public Status f(Status status) {
            return status;
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.f(status);
        }
    }

    private static class c
    extends com.google.android.gms.drive.internal.c {
        private final a.d<DriveApi.ContentsResult> wH;
        private final DriveFile.DownloadProgressListener Ft;

        public c(a.d<DriveApi.ContentsResult> d2, DriveFile.DownloadProgressListener downloadProgressListener) {
            this.wH = d2;
            this.Ft = downloadProgressListener;
        }

        @Override
        public void a(OnContentsResponse onContentsResponse) throws RemoteException {
            this.wH.b(new l.a(Status.Bv, onContentsResponse.fI()));
        }

        @Override
        public void a(OnDownloadProgressResponse onDownloadProgressResponse) throws RemoteException {
            if (this.Ft != null) {
                this.Ft.onProgress(onDownloadProgressResponse.fJ(), onDownloadProgressResponse.fK());
            }
        }

        @Override
        public void m(Status status) throws RemoteException {
            this.wH.b(new l.a(status, null));
        }
    }

    private abstract class d
    extends m<DriveApi.ContentsResult> {
        private d() {
        }

        public DriveApi.ContentsResult o(Status status) {
            return new l.a(status, null);
        }

        @Override
        public /* synthetic */ Result d(Status status) {
            return this.o(status);
        }
    }
}

