/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.images;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.images.b;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.fo;
import org.json.JSONException;
import org.json.JSONObject;

public final class WebImage
implements SafeParcelable {
    public static final Parcelable.Creator<WebImage> CREATOR = new b();
    private final int xH;
    private final Uri Cu;
    private final int kr;
    private final int ks;

    WebImage(int versionCode, Uri url, int width, int height) {
        this.xH = versionCode;
        this.Cu = url;
        this.kr = width;
        this.ks = height;
    }

    public WebImage(Uri url, int width, int height) throws IllegalArgumentException {
        this(1, url, width, height);
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("width and height must not be negative");
        }
    }

    public WebImage(Uri url) throws IllegalArgumentException {
        this(url, 0, 0);
    }

    public WebImage(JSONObject json) throws IllegalArgumentException {
        this(WebImage.d(json), json.optInt("width", 0), json.optInt("height", 0));
    }

    int getVersionCode() {
        return this.xH;
    }

    private static Uri d(JSONObject jSONObject) {
        Uri uri = null;
        if (jSONObject.has("url")) {
            try {
                uri = Uri.parse((String)jSONObject.getString("url"));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return uri;
    }

    public Uri getUrl() {
        return this.Cu;
    }

    public int getWidth() {
        return this.kr;
    }

    public int getHeight() {
        return this.ks;
    }

    public String toString() {
        return String.format("Image %dx%d %s", this.kr, this.ks, this.Cu.toString());
    }

    public JSONObject dB() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("url", (Object)this.Cu.toString());
            jSONObject.put("width", this.kr);
            jSONObject.put("height", this.ks);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof WebImage)) {
            return false;
        }
        WebImage webImage = (WebImage)other;
        return fo.equal(this.Cu, webImage.Cu) && this.kr == webImage.kr && this.ks == webImage.ks;
    }

    public int hashCode() {
        return fo.hashCode(this.Cu, this.kr, this.ks);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        b.a(this, out, flags);
    }
}

