/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.data;

import android.content.ContentValues;
import android.database.AbstractWindowedCursor;
import android.database.CharArrayBuffer;
import android.database.CursorIndexOutOfBoundsException;
import android.database.CursorWindow;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.util.Log;
import com.google.android.gms.common.data.DataHolderCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DataHolder
implements SafeParcelable {
    public static final DataHolderCreator CREATOR = new DataHolderCreator();
    private final int xH;
    private final String[] BH;
    Bundle BI;
    private final CursorWindow[] BJ;
    private final int Ah;
    private final Bundle BK;
    int[] BL;
    int BM;
    boolean mClosed = false;
    private Object BN;
    private boolean BO = true;
    private static final Builder BP = new Builder(new String[0], null){

        @Override
        public Builder withRow(HashMap<String, Object> row) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }

        @Override
        public Builder withRow(ContentValues values) {
            throw new UnsupportedOperationException("Cannot add data to empty builder");
        }
    };

    DataHolder(int versionCode, String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.xH = versionCode;
        this.BH = columns;
        this.BJ = windows;
        this.Ah = statusCode;
        this.BK = metadata;
    }

    public DataHolder(String[] columns, CursorWindow[] windows, int statusCode, Bundle metadata) {
        this.xH = 1;
        this.BH = fq.f(columns);
        this.BJ = fq.f(windows);
        this.Ah = statusCode;
        this.BK = metadata;
        this.validateContents();
    }

    public void c(Object object) {
        this.BN = object;
    }

    public DataHolder(AbstractWindowedCursor cursor, int statusCode, Bundle metadata) {
        this(cursor.getColumnNames(), DataHolder.a(cursor), statusCode, metadata);
    }

    private DataHolder(Builder builder, int statusCode, Bundle metadata) {
        this(builder.BH, DataHolder.a(builder, -1), statusCode, metadata);
    }

    private DataHolder(Builder builder, int statusCode, Bundle metadata, int maxResults) {
        this(builder.BH, DataHolder.a(builder, maxResults), statusCode, metadata);
    }

    public void validateContents() {
        int n2;
        this.BI = new Bundle();
        for (n2 = 0; n2 < this.BH.length; ++n2) {
            this.BI.putInt(this.BH[n2], n2);
        }
        this.BL = new int[this.BJ.length];
        n2 = 0;
        for (int i2 = 0; i2 < this.BJ.length; ++i2) {
            this.BL[i2] = n2;
            int n3 = this.BJ[i2].getStartPosition();
            int n4 = n2 - n3;
            n2 += this.BJ[i2].getNumRows() - n4;
        }
        this.BM = n2;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        DataHolderCreator.a(this, dest, flags);
    }

    int getVersionCode() {
        return this.xH;
    }

    String[] er() {
        return this.BH;
    }

    CursorWindow[] es() {
        return this.BJ;
    }

    public int getStatusCode() {
        return this.Ah;
    }

    public Bundle getMetadata() {
        return this.BK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CursorWindow[] a(AbstractWindowedCursor abstractWindowedCursor) {
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        try {
            int n2 = abstractWindowedCursor.getCount();
            CursorWindow cursorWindow = abstractWindowedCursor.getWindow();
            int n3 = 0;
            if (cursorWindow != null && cursorWindow.getStartPosition() == 0) {
                cursorWindow.acquireReference();
                abstractWindowedCursor.setWindow(null);
                arrayList.add(cursorWindow);
                n3 = cursorWindow.getNumRows();
            }
            while (n3 < n2 && abstractWindowedCursor.moveToPosition(n3)) {
                CursorWindow cursorWindow2 = abstractWindowedCursor.getWindow();
                if (cursorWindow2 != null) {
                    cursorWindow2.acquireReference();
                    abstractWindowedCursor.setWindow(null);
                } else {
                    cursorWindow2 = new CursorWindow(false);
                    cursorWindow2.setStartPosition(n3);
                    abstractWindowedCursor.fillWindow(n3, cursorWindow2);
                }
                if (cursorWindow2.getNumRows() == 0) {
                    break;
                }
                arrayList.add(cursorWindow2);
                n3 = cursorWindow2.getStartPosition() + cursorWindow2.getNumRows();
            }
        }
        finally {
            abstractWindowedCursor.close();
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private static CursorWindow[] a(Builder builder, int n2) {
        if (builder.BH.length == 0) {
            return new CursorWindow[0];
        }
        List list = n2 < 0 || n2 >= builder.BQ.size() ? builder.BQ : builder.BQ.subList(0, n2);
        int n3 = list.size();
        CursorWindow cursorWindow = new CursorWindow(false);
        ArrayList<CursorWindow> arrayList = new ArrayList<CursorWindow>();
        arrayList.add(cursorWindow);
        cursorWindow.setNumColumns(builder.BH.length);
        try {
            int n4 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (!cursorWindow.allocRow()) {
                    Log.d((String)"DataHolder", (String)("Allocating additional cursor window for large data set (row " + i2 + ")"));
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setStartPosition(i2);
                    cursorWindow.setNumColumns(builder.BH.length);
                    arrayList.add(cursorWindow);
                    if (!cursorWindow.allocRow()) {
                        Log.e((String)"DataHolder", (String)"Unable to allocate row to hold data.");
                        arrayList.remove(cursorWindow);
                        return arrayList.toArray(new CursorWindow[arrayList.size()]);
                    }
                    n4 = 0;
                }
                Map map = (Map)list.get(i2);
                boolean bl2 = true;
                for (int i3 = 0; i3 < builder.BH.length && bl2; ++i3) {
                    String string2 = builder.BH[i3];
                    Object v2 = map.get(string2);
                    if (v2 == null) {
                        bl2 = cursorWindow.putNull(n4, i3);
                        continue;
                    }
                    if (v2 instanceof String) {
                        bl2 = cursorWindow.putString((String)v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Long) {
                        bl2 = cursorWindow.putLong(((Long)v2).longValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Integer) {
                        bl2 = cursorWindow.putLong((long)((Integer)v2).intValue(), n4, i3);
                        continue;
                    }
                    if (v2 instanceof Boolean) {
                        boolean bl3 = (Boolean)v2;
                        bl2 = cursorWindow.putLong(bl3 ? 1L : 0L, n4, i3);
                        continue;
                    }
                    if (v2 instanceof byte[]) {
                        bl2 = cursorWindow.putBlob((byte[])v2, n4, i3);
                        continue;
                    }
                    if (v2 instanceof Double) {
                        bl2 = cursorWindow.putDouble(((Double)v2).doubleValue(), n4, i3);
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported object for column " + string2 + ": " + v2);
                }
                if (!bl2) {
                    Log.d((String)"DataHolder", (String)("Couldn't populate window data for row " + i2 + " - allocating new window."));
                    cursorWindow.freeLastRow();
                    cursorWindow = new CursorWindow(false);
                    cursorWindow.setNumColumns(builder.BH.length);
                    arrayList.add(cursorWindow);
                    n4 = 0;
                    --i2;
                    continue;
                }
                ++n4;
            }
        }
        catch (RuntimeException runtimeException) {
            int n5 = arrayList.size();
            for (int i4 = 0; i4 < n5; ++i4) {
                ((CursorWindow)arrayList.get(i4)).close();
            }
            throw runtimeException;
        }
        return arrayList.toArray(new CursorWindow[arrayList.size()]);
    }

    private void e(String string2, int n2) {
        if (this.BI == null || !this.BI.containsKey(string2)) {
            throw new IllegalArgumentException("No such column: " + string2);
        }
        if (this.isClosed()) {
            throw new IllegalArgumentException("Buffer is closed.");
        }
        if (n2 < 0 || n2 >= this.BM) {
            throw new CursorIndexOutOfBoundsException(n2, this.BM);
        }
    }

    public boolean hasColumn(String column) {
        return this.BI.containsKey(column);
    }

    public long getLong(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].getLong(row, this.BI.getInt(column));
    }

    public int getInteger(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].getInt(row, this.BI.getInt(column));
    }

    public String getString(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].getString(row, this.BI.getInt(column));
    }

    public boolean getBoolean(String column, int row, int windowIndex) {
        this.e(column, row);
        Long l2 = this.BJ[windowIndex].getLong(row, this.BI.getInt(column));
        return l2 == 1L;
    }

    public double getDouble(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].getDouble(row, this.BI.getInt(column));
    }

    public byte[] getByteArray(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].getBlob(row, this.BI.getInt(column));
    }

    public Uri parseUri(String column, int row, int windowIndex) {
        String string2 = this.getString(column, row, windowIndex);
        return string2 == null ? null : Uri.parse((String)string2);
    }

    public void copyToBuffer(String column, int row, int windowIndex, CharArrayBuffer dataOut) {
        this.e(column, row);
        this.BJ[windowIndex].copyStringToBuffer(row, this.BI.getInt(column), dataOut);
    }

    public boolean hasNull(String column, int row, int windowIndex) {
        this.e(column, row);
        return this.BJ[windowIndex].isNull(row, this.BI.getInt(column));
    }

    public int getCount() {
        return this.BM;
    }

    public int G(int n2) {
        int n3;
        fq.x(n2 >= 0 && n2 < this.BM);
        for (n3 = 0; n3 < this.BL.length; ++n3) {
            if (n2 >= this.BL[n3]) continue;
            --n3;
            break;
        }
        if (n3 == this.BL.length) {
            --n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            return this.mClosed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        DataHolder dataHolder = this;
        synchronized (dataHolder) {
            if (!this.mClosed) {
                this.mClosed = true;
                for (int i2 = 0; i2 < this.BJ.length; ++i2) {
                    this.BJ[i2].close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.BO && this.BJ.length > 0 && !this.isClosed()) {
                String string2 = this.BN == null ? "internal object: " + this.toString() : this.BN.toString();
                Log.e((String)"DataBuffer", (String)("Internal data leak within a DataBuffer object detected!  Be sure to explicitly call close() on all DataBuffer extending objects when you are done with them. (" + string2 + ")"));
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public static Builder builder(String[] columns) {
        return new Builder(columns, null);
    }

    public static Builder builder(String[] columns, String uniqueColumn) {
        fq.f(uniqueColumn);
        return new Builder(columns, uniqueColumn);
    }

    public static DataHolder empty(int statusCode) {
        return DataHolder.empty(statusCode, null);
    }

    public static DataHolder empty(int statusCode, Bundle metadata) {
        return new DataHolder(BP, statusCode, metadata);
    }

    private static final class a
    implements Comparator<HashMap<String, Object>> {
        private final String BV;

        a(String string2) {
            this.BV = fq.f(string2);
        }

        public int a(HashMap<String, Object> hashMap, HashMap<String, Object> hashMap2) {
            Object object;
            Object object2 = fq.f(hashMap.get(this.BV));
            if (object2.equals(object = fq.f(hashMap2.get(this.BV)))) {
                return 0;
            }
            if (object2 instanceof Boolean) {
                return ((Boolean)object2).compareTo((Boolean)object);
            }
            if (object2 instanceof Long) {
                return ((Long)object2).compareTo((Long)object);
            }
            if (object2 instanceof Integer) {
                return ((Integer)object2).compareTo((Integer)object);
            }
            if (object2 instanceof String) {
                return ((String)object2).compareTo((String)object);
            }
            throw new IllegalArgumentException("Unknown type for lValue " + object2);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.a((HashMap)x0, (HashMap)x1);
        }
    }

    public static class Builder {
        private final String[] BH;
        private final ArrayList<HashMap<String, Object>> BQ;
        private final String BR;
        private final HashMap<Object, Integer> BS;
        private boolean BT;
        private String BU;

        private Builder(String[] columns, String uniqueColumn) {
            this.BH = fq.f(columns);
            this.BQ = new ArrayList();
            this.BR = uniqueColumn;
            this.BS = new HashMap();
            this.BT = false;
            this.BU = null;
        }

        public Builder withRow(HashMap<String, Object> row) {
            fb.d(row);
            if (this.BR != null) {
                this.a(row);
            }
            this.BQ.add(row);
            this.BT = false;
            return this;
        }

        private void a(HashMap<String, Object> hashMap) {
            Object object = hashMap.get(this.BR);
            if (object == null) {
                return;
            }
            Integer n2 = this.BS.remove(object);
            if (n2 != null) {
                this.BQ.remove(n2);
            }
            this.BS.put(object, this.BQ.size());
        }

        public Builder withRow(ContentValues values) {
            fb.d(values);
            HashMap<String, Object> hashMap = new HashMap<String, Object>(values.size());
            Set set = values.valueSet();
            for (Map.Entry entry : set) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return this.withRow(hashMap);
        }

        public Builder removeRowsWithValue(String column, Object value) {
            for (int i2 = this.BQ.size() - 1; i2 >= 0; --i2) {
                if (!fo.equal(this.BQ.get(i2).get(column), value)) continue;
                this.BQ.remove(i2);
            }
            return this;
        }

        public Builder sort(String sortColumn) {
            fb.d(sortColumn);
            if (this.BT && sortColumn.equals(this.BU)) {
                return this;
            }
            Collections.sort(this.BQ, new a(sortColumn));
            this.et();
            this.BT = true;
            this.BU = sortColumn;
            return this;
        }

        private void et() {
            if (this.BR != null) {
                this.BS.clear();
                int n2 = this.BQ.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = this.BQ.get(i2).get(this.BR);
                    if (object == null) continue;
                    this.BS.put(object, i2);
                }
            }
        }

        public int getCount() {
            return this.BQ.size();
        }

        public DataHolder build(int statusCode) {
            return new DataHolder(this, statusCode, null);
        }

        public DataHolder build(int statusCode, Bundle metadata) {
            return new DataHolder(this, statusCode, metadata, -1);
        }

        public DataHolder build(int statusCode, Bundle metadata, int maxResults) {
            return new DataHolder(this, statusCode, metadata, maxResults);
        }
    }
}

