/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.os.DeadObjectException;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Releasable;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.ResultCallback;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.b;
import com.google.android.gms.internal.fk;
import com.google.android.gms.internal.fq;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class a {

    public static class c<R extends Result>
    extends Handler {
        public c() {
            this(Looper.getMainLooper());
        }

        public c(Looper looper) {
            super(looper);
        }

        public void a(ResultCallback<R> resultCallback, R r2) {
            this.sendMessage(this.obtainMessage(1, new Pair(resultCallback, r2)));
        }

        public void a(a<R> a2, long l2) {
            this.sendMessageDelayed(this.obtainMessage(2, a2), l2);
        }

        public void eg() {
            this.removeMessages(2);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Pair pair = (Pair)msg.obj;
                    this.b((ResultCallback)pair.first, (Result)pair.second);
                    return;
                }
                case 2: {
                    a a2 = (a)msg.obj;
                    a2.ee();
                    return;
                }
            }
            Log.wtf((String)"GoogleApi", (String)"Don't know how to handle this message.");
        }

        protected void b(ResultCallback<R> resultCallback, R r2) {
            resultCallback.onResult(r2);
        }
    }

    public static abstract class a<R extends Result>
    implements PendingResult<R>,
    d<R> {
        private final Object AB = new Object();
        private c<R> AC;
        private final CountDownLatch AD = new CountDownLatch(1);
        private final ArrayList<PendingResult.a> AE = new ArrayList();
        private ResultCallback<R> AF;
        private volatile R AG;
        private volatile boolean AH;
        private boolean AI;
        private boolean AJ;
        private fk AK;

        a() {
        }

        public a(Looper looper) {
            this.AC = new c(looper);
        }

        public a(c<R> c2) {
            this.AC = c2;
        }

        protected abstract R d(Status var1);

        public final boolean isReady() {
            return this.AD.getCount() == 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private R eb() {
            Object object = this.AB;
            synchronized (object) {
                fq.a(!this.AH, "Result has already been consumed.");
                fq.a(this.isReady(), "Result is not ready.");
                R r2 = this.AG;
                this.ec();
                return r2;
            }
        }

        @Override
        public final R await() {
            fq.a(!this.AH, "Result has already been consumed");
            fq.a(this.isReady() || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            try {
                this.AD.await();
            }
            catch (InterruptedException interruptedException) {
                this.ed();
            }
            fq.a(this.isReady(), "Result is not ready.");
            return this.eb();
        }

        @Override
        public final R await(long time, TimeUnit units) {
            fq.a(!this.AH, "Result has already been consumed.");
            fq.a(this.isReady() || Looper.myLooper() != Looper.getMainLooper(), "await must not be called on the UI thread");
            try {
                boolean bl2 = this.AD.await(time, units);
                if (!bl2) {
                    this.ee();
                }
            }
            catch (InterruptedException interruptedException) {
                this.ed();
            }
            fq.a(this.isReady(), "Result is not ready.");
            return this.eb();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback) {
            fq.a(!this.AH, "Result has already been consumed.");
            Object object = this.AB;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.AC.a(callback, this.eb());
                } else {
                    this.AF = callback;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void setResultCallback(ResultCallback<R> callback, long time, TimeUnit units) {
            fq.a(!this.AH, "Result has already been consumed.");
            Object object = this.AB;
            synchronized (object) {
                if (this.isCanceled()) {
                    return;
                }
                if (this.isReady()) {
                    this.AC.a(callback, this.eb());
                } else {
                    this.AF = callback;
                    this.AC.a(this, units.toMillis(time));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(PendingResult.a a2) {
            fq.a(!this.AH, "Result has already been consumed.");
            Object object = this.AB;
            synchronized (object) {
                if (this.isReady()) {
                    a2.l(this.AG.getStatus());
                } else {
                    this.AE.add(a2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected final void a(fk fk2) {
            Object object = this.AB;
            synchronized (object) {
                this.AK = fk2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            Object object = this.AB;
            synchronized (object) {
                if (this.AI) {
                    return;
                }
                if (this.AK != null) {
                    try {
                        this.AK.cancel();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                }
                this.c((Result)this.AG);
                this.AF = null;
                this.AI = true;
                this.b(this.d(Status.Bz));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCanceled() {
            Object object = this.AB;
            synchronized (object) {
                return this.AI;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void a(R r2) {
            Object object = this.AB;
            synchronized (object) {
                if (this.AJ || this.AI) {
                    this.c((Result)r2);
                    return;
                }
                fq.a(!this.isReady(), "Results have already been set");
                fq.a(!this.AH, "Result has already been consumed");
                this.b(r2);
            }
        }

        protected void ec() {
            this.AH = true;
            this.AG = null;
            this.AF = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ed() {
            Object object = this.AB;
            synchronized (object) {
                if (!this.isReady()) {
                    this.a(this.d(Status.Bw));
                    this.AJ = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void ee() {
            Object object = this.AB;
            synchronized (object) {
                if (!this.isReady()) {
                    this.a(this.d(Status.By));
                    this.AJ = true;
                }
            }
        }

        @Override
        private void b(R r2) {
            this.AG = r2;
            this.AK = null;
            this.AD.countDown();
            Status status = this.AG.getStatus();
            if (this.AF != null) {
                this.AC.eg();
                if (!this.AI) {
                    this.AC.a(this.AF, this.eb());
                }
            }
            for (PendingResult.a a2 : this.AE) {
                a2.l(status);
            }
            this.AE.clear();
        }

        private void c(Result result) {
            if (result instanceof Releasable) {
                try {
                    ((Releasable)((Object)result)).release();
                }
                catch (Exception exception) {
                    Log.w((String)"AbstractPendingResult", (String)("Unable to release " + this), (Throwable)exception);
                }
            }
        }

        protected void a(c<R> c2) {
            this.AC = c2;
        }

        @Override
        public /* synthetic */ void b(Object object) {
            this.a((Result)object);
        }
    }

    public static abstract class b<R extends Result, A extends Api.a>
    extends a<R>
    implements b.c<A> {
        private final Api.c<A> Az;
        private b.a AL;

        protected b(Api.c<A> c2) {
            this.Az = fq.f(c2);
        }

        @Override
        public final Api.c<A> ea() {
            return this.Az;
        }

        @Override
        public final void b(A a2) throws DeadObjectException {
            this.a((A)((Object)new c(a2.getLooper())));
            try {
                this.a(a2);
            }
            catch (DeadObjectException deadObjectException) {
                this.a((RemoteException)((Object)deadObjectException));
                throw deadObjectException;
            }
            catch (RemoteException remoteException) {
                this.a(remoteException);
            }
        }

        @Override
        public final void k(Status status) {
            fq.b(!status.isSuccess(), (Object)"Failed result must not be success");
            this.a((A)this.d(status));
        }

        @Override
        public void a(b.a a2) {
            this.AL = a2;
        }

        @Override
        public int ef() {
            return 0;
        }

        @Override
        protected abstract void a(A var1) throws RemoteException;

        @Override
        protected void ec() {
            super.ec();
            if (this.AL != null) {
                this.AL.b(this);
                this.AL = null;
            }
        }

        @Override
        private void a(RemoteException remoteException) {
            Status status = new Status(8, remoteException.getLocalizedMessage(), null);
            this.k(status);
        }
    }

    public static interface d<R> {
        public void b(R var1);
    }
}

