/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.IntentSender;
import android.os.Parcel;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.StatusCreator;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.internal.fo;

public final class Status
implements Result,
SafeParcelable {
    public static final Status Bv = new Status(0);
    public static final Status Bw = new Status(14);
    public static final Status Bx = new Status(8);
    public static final Status By = new Status(15);
    public static final Status Bz = new Status(16);
    public static final StatusCreator CREATOR = new StatusCreator();
    private final int xH;
    private final int Ah;
    private final String BA;
    private final PendingIntent mPendingIntent;

    Status(int versionCode, int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this.xH = versionCode;
        this.Ah = statusCode;
        this.BA = statusMessage;
        this.mPendingIntent = pendingIntent;
    }

    public Status(int statusCode) {
        this(1, statusCode, null, null);
    }

    public Status(int statusCode, String statusMessage, PendingIntent pendingIntent) {
        this(1, statusCode, statusMessage, pendingIntent);
    }

    public void startResolutionForResult(Activity activity, int requestCode) throws IntentSender.SendIntentException {
        if (!this.hasResolution()) {
            return;
        }
        activity.startIntentSenderForResult(this.mPendingIntent.getIntentSender(), requestCode, null, 0, 0, 0);
    }

    PendingIntent eo() {
        return this.mPendingIntent;
    }

    String ep() {
        return this.BA;
    }

    int getVersionCode() {
        return this.xH;
    }

    public boolean hasResolution() {
        return this.mPendingIntent != null;
    }

    public boolean isSuccess() {
        return this.Ah <= 0;
    }

    public boolean isCanceled() {
        return this.Ah == 16;
    }

    public boolean isInterrupted() {
        return this.Ah == 14;
    }

    public int getStatusCode() {
        return this.Ah;
    }

    public PendingIntent getResolution() {
        return this.mPendingIntent;
    }

    public int hashCode() {
        return fo.hashCode(this.xH, this.Ah, this.BA, this.mPendingIntent);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Status)) {
            return false;
        }
        Status status = (Status)obj;
        return this.xH == status.xH && this.Ah == status.Ah && fo.equal(this.BA, status.BA) && fo.equal(this.mPendingIntent, status.mPendingIntent);
    }

    private String dW() {
        if (this.BA != null) {
            return this.BA;
        }
        return CommonStatusCodes.getStatusCodeString(this.Ah);
    }

    public String toString() {
        return fo.e(this).a("statusCode", this.dW()).a("resolution", this.mPendingIntent).toString();
    }

    @Deprecated
    public ConnectionResult eq() {
        return new ConnectionResult(this.Ah, this.mPendingIntent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        StatusCreator.a(this, out, flags);
    }

    @Override
    public Status getStatus() {
        return this;
    }
}

