/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.a;
import com.google.android.gms.common.api.b;
import com.google.android.gms.internal.fc;
import com.google.android.gms.internal.fq;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public interface GoogleApiClient {
    public <A extends Api.a, T extends a.b<? extends Result, A>> T a(T var1);

    public <A extends Api.a, T extends a.b<? extends Result, A>> T b(T var1);

    public <C extends Api.a> C a(Api.c<C> var1);

    public Looper getLooper();

    public void connect();

    public ConnectionResult blockingConnect(long var1, TimeUnit var3);

    public void disconnect();

    public void reconnect();

    public boolean isConnected();

    public boolean isConnecting();

    public void registerConnectionCallbacks(ConnectionCallbacks var1);

    public boolean isConnectionCallbacksRegistered(ConnectionCallbacks var1);

    public void unregisterConnectionCallbacks(ConnectionCallbacks var1);

    public void registerConnectionFailedListener(OnConnectionFailedListener var1);

    public boolean isConnectionFailedListenerRegistered(OnConnectionFailedListener var1);

    public void unregisterConnectionFailedListener(OnConnectionFailedListener var1);

    public static final class Builder {
        private String wG;
        private final Set<String> AT = new HashSet<String>();
        private int AU;
        private View AV;
        private String AW;
        private final Context mContext;
        private final Map<Api<?>, Api.ApiOptions> AX = new HashMap();
        private Looper AS;
        private final Set<ConnectionCallbacks> AY = new HashSet<ConnectionCallbacks>();
        private final Set<OnConnectionFailedListener> AZ = new HashSet<OnConnectionFailedListener>();

        public Builder(Context context) {
            this.mContext = context;
            this.AS = context.getMainLooper();
            this.AW = context.getPackageName();
        }

        public Builder(Context context, ConnectionCallbacks connectedListener, OnConnectionFailedListener connectionFailedListener) {
            this(context);
            fq.b(connectedListener, (Object)"Must provide a connected listener");
            this.AY.add(connectedListener);
            fq.b(connectionFailedListener, (Object)"Must provide a connection failed listener");
            this.AZ.add(connectionFailedListener);
        }

        public Builder setHandler(Handler handler) {
            fq.b(handler, (Object)"Handler must not be null");
            this.AS = handler.getLooper();
            return this;
        }

        public Builder addConnectionCallbacks(ConnectionCallbacks listener) {
            this.AY.add(listener);
            return this;
        }

        public Builder addOnConnectionFailedListener(OnConnectionFailedListener listener) {
            this.AZ.add(listener);
            return this;
        }

        public Builder setViewForPopups(View viewForPopups) {
            this.AV = viewForPopups;
            return this;
        }

        public Builder addScope(Scope scope) {
            this.AT.add(scope.en());
            return this;
        }

        public Builder addApi(Api<? extends Api.ApiOptions.NotRequiredOptions> api) {
            this.AX.put(api, null);
            List<Scope> list = api.dZ();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.AT.add(list.get(i2).en());
            }
            return this;
        }

        public <O extends Api.ApiOptions.HasOptions> Builder addApi(Api<O> api, O options) {
            fq.b(options, (Object)"Null options are not permitted for this Api");
            this.AX.put(api, options);
            List<Scope> list = api.dZ();
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.AT.add(list.get(i2).en());
            }
            return this;
        }

        public Builder setAccountName(String accountName) {
            this.wG = accountName;
            return this;
        }

        public Builder useDefaultAccount() {
            return this.setAccountName("<<default account>>");
        }

        public Builder setGravityForPopups(int gravityForPopups) {
            this.AU = gravityForPopups;
            return this;
        }

        public fc eh() {
            return new fc(this.wG, this.AT, this.AU, this.AV, this.AW);
        }

        public GoogleApiClient build() {
            return new b(this.mContext, this.AS, this.eh(), this.AX, this.AY, this.AZ);
        }
    }

    public static interface OnConnectionFailedListener
    extends GooglePlayServicesClient.OnConnectionFailedListener {
        @Override
        public void onConnectionFailed(ConnectionResult var1);
    }

    public static interface ConnectionCallbacks {
        public static final int CAUSE_SERVICE_DISCONNECTED = 1;
        public static final int CAUSE_NETWORK_LOST = 2;

        public void onConnected(Bundle var1);

        public void onConnectionSuspended(int var1);
    }
}

