/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import com.google.android.gms.dynamic.g;
import com.google.android.gms.internal.fq;
import com.google.android.gms.internal.fr;
import com.google.android.gms.internal.fs;

public final class SignInButton
extends FrameLayout
implements View.OnClickListener {
    public static final int SIZE_STANDARD = 0;
    public static final int SIZE_WIDE = 1;
    public static final int SIZE_ICON_ONLY = 2;
    public static final int COLOR_DARK = 0;
    public static final int COLOR_LIGHT = 1;
    private int mSize;
    private int Av;
    private View Aw;
    private View.OnClickListener Ax = null;

    public SignInButton(Context context) {
        this(context, null);
    }

    public SignInButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SignInButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setStyle(0, 0);
    }

    public void setSize(int buttonSize) {
        this.setStyle(buttonSize, this.Av);
    }

    public void setColorScheme(int colorScheme) {
        this.setStyle(this.mSize, colorScheme);
    }

    public void setStyle(int buttonSize, int colorScheme) {
        fq.a(buttonSize >= 0 && buttonSize < 3, "Unknown button size " + buttonSize);
        fq.a(colorScheme >= 0 && colorScheme < 2, "Unknown color scheme " + colorScheme);
        this.mSize = buttonSize;
        this.Av = colorScheme;
        this.v(this.getContext());
    }

    private void v(Context context) {
        if (this.Aw != null) {
            this.removeView(this.Aw);
        }
        try {
            this.Aw = fr.b(context, this.mSize, this.Av);
        }
        catch (g.a a2) {
            Log.w((String)"SignInButton", (String)"Sign in button not found, using placeholder instead");
            this.Aw = SignInButton.a(context, this.mSize, this.Av);
        }
        this.addView(this.Aw);
        this.Aw.setEnabled(this.isEnabled());
        this.Aw.setOnClickListener((View.OnClickListener)this);
    }

    private static Button a(Context context, int n2, int n3) {
        fs fs2 = new fs(context);
        fs2.a(context.getResources(), n2, n3);
        return fs2;
    }

    public void setOnClickListener(View.OnClickListener listener) {
        this.Ax = listener;
        if (this.Aw != null) {
            this.Aw.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.Aw.setEnabled(enabled);
    }

    public void onClick(View view) {
        if (this.Ax != null && view == this.Aw) {
            this.Ax.onClick((View)this);
        }
    }
}

