/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.cast;

import android.text.TextUtils;
import com.google.android.gms.cast.MediaMetadata;
import com.google.android.gms.internal.eo;
import com.google.android.gms.internal.fo;
import com.google.android.gms.internal.gp;
import org.json.JSONException;
import org.json.JSONObject;

public final class MediaInfo {
    public static final int STREAM_TYPE_NONE = 0;
    public static final int STREAM_TYPE_BUFFERED = 1;
    public static final int STREAM_TYPE_LIVE = 2;
    public static final int STREAM_TYPE_INVALID = -1;
    private final String yi;
    private int yj;
    private String yk;
    private MediaMetadata yl;
    private long ym;
    private JSONObject yn;

    MediaInfo(String contentId) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentId)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        this.yi = contentId;
        this.yj = -1;
    }

    MediaInfo(JSONObject json) throws JSONException {
        this.yi = json.getString("contentId");
        String string2 = json.getString("streamType");
        this.yj = "NONE".equals(string2) ? 0 : ("BUFFERED".equals(string2) ? 1 : ("LIVE".equals(string2) ? 2 : -1));
        this.yk = json.getString("contentType");
        if (json.has("metadata")) {
            JSONObject jSONObject = json.getJSONObject("metadata");
            int n2 = jSONObject.getInt("metadataType");
            this.yl = new MediaMetadata(n2);
            this.yl.c(jSONObject);
        }
        this.ym = eo.b(json.optDouble("duration", 0.0));
        this.yn = json.optJSONObject("customData");
    }

    public String getContentId() {
        return this.yi;
    }

    void setStreamType(int streamType) throws IllegalArgumentException {
        if (streamType < -1 || streamType > 2) {
            throw new IllegalArgumentException("invalid stream type");
        }
        this.yj = streamType;
    }

    public int getStreamType() {
        return this.yj;
    }

    void setContentType(String contentType) throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)contentType)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        this.yk = contentType;
    }

    public String getContentType() {
        return this.yk;
    }

    void a(MediaMetadata mediaMetadata) {
        this.yl = mediaMetadata;
    }

    public MediaMetadata getMetadata() {
        return this.yl;
    }

    void k(long l2) throws IllegalArgumentException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Stream duration cannot be negative");
        }
        this.ym = l2;
    }

    public long getStreamDuration() {
        return this.ym;
    }

    void b(JSONObject jSONObject) {
        this.yn = jSONObject;
    }

    public JSONObject getCustomData() {
        return this.yn;
    }

    void dA() throws IllegalArgumentException {
        if (TextUtils.isEmpty((CharSequence)this.yi)) {
            throw new IllegalArgumentException("content ID cannot be null or empty");
        }
        if (TextUtils.isEmpty((CharSequence)this.yk)) {
            throw new IllegalArgumentException("content type cannot be null or empty");
        }
        if (this.yj == -1) {
            throw new IllegalArgumentException("a valid stream type must be specified");
        }
    }

    public JSONObject dB() {
        JSONObject jSONObject = new JSONObject();
        try {
            String string2;
            jSONObject.put("contentId", (Object)this.yi);
            switch (this.yj) {
                case 1: {
                    string2 = "BUFFERED";
                    break;
                }
                case 2: {
                    string2 = "LIVE";
                    break;
                }
                default: {
                    string2 = "NONE";
                }
            }
            jSONObject.put("streamType", (Object)string2);
            if (this.yk != null) {
                jSONObject.put("contentType", (Object)this.yk);
            }
            if (this.yl != null) {
                jSONObject.put("metadata", (Object)this.yl.dB());
            }
            jSONObject.put("duration", eo.m(this.ym));
            if (this.yn != null) {
                jSONObject.put("customData", (Object)this.yn);
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MediaInfo)) {
            return false;
        }
        MediaInfo mediaInfo = (MediaInfo)other;
        if (this.yn == null != (mediaInfo.yn == null)) {
            return false;
        }
        if (this.yn != null && mediaInfo.yn != null && !gp.d(this.yn, mediaInfo.yn)) {
            return false;
        }
        return eo.a(this.yi, mediaInfo.yi) && this.yj == mediaInfo.yj && eo.a(this.yk, mediaInfo.yk) && eo.a(this.yl, mediaInfo.yl) && this.ym == mediaInfo.ym;
    }

    public int hashCode() {
        return fo.hashCode(this.yi, this.yj, this.yk, this.yl, this.ym, String.valueOf(this.yn));
    }

    public static class Builder {
        private final MediaInfo yo;

        public Builder(String contentId) throws IllegalArgumentException {
            if (TextUtils.isEmpty((CharSequence)contentId)) {
                throw new IllegalArgumentException("Content ID cannot be empty");
            }
            this.yo = new MediaInfo(contentId);
        }

        public Builder setStreamType(int streamType) throws IllegalArgumentException {
            this.yo.setStreamType(streamType);
            return this;
        }

        public Builder setContentType(String contentType) throws IllegalArgumentException {
            this.yo.setContentType(contentType);
            return this;
        }

        public Builder setMetadata(MediaMetadata metadata) {
            this.yo.a(metadata);
            return this;
        }

        public Builder setStreamDuration(long duration) throws IllegalArgumentException {
            this.yo.k(duration);
            return this;
        }

        public Builder setCustomData(JSONObject customData) {
            this.yo.b(customData);
            return this;
        }

        public MediaInfo build() throws IllegalArgumentException {
            this.yo.dA();
            return this.yo;
        }
    }
}

