/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.CursorWindow;
import android.database.sqlite.SQLiteCursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.text.TextUtils;
import com.google.android.gms.analytics.GoogleAnalytics;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ab;
import com.google.android.gms.analytics.ah;
import com.google.android.gms.analytics.d;
import com.google.android.gms.analytics.e;
import com.google.android.gms.analytics.i;
import com.google.android.gms.analytics.n;
import com.google.android.gms.analytics.p;
import com.google.android.gms.analytics.x;
import com.google.android.gms.analytics.y;
import com.google.android.gms.internal.ef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;

class ac
implements d {
    private static final String vx = String.format("CREATE TABLE IF NOT EXISTS %s ( '%s' INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, '%s' INTEGER NOT NULL, '%s' TEXT NOT NULL, '%s' TEXT NOT NULL, '%s' INTEGER);", "hits2", "hit_id", "hit_time", "hit_url", "hit_string", "hit_app_id");
    private final a vy;
    private volatile n vz;
    private final e sO;
    private final Context mContext;
    private final String vA;
    private ab vB;
    private long vC;
    private final int vD;
    private i tg;

    ac(e e2, Context context) {
        this(e2, context, "google_analytics_v4.db", 2000);
    }

    ac(e e2, Context context, String string2, int n2) {
        this.mContext = context.getApplicationContext();
        this.vA = string2;
        this.sO = e2;
        this.tg = new i(){

            @Override
            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }
        };
        this.vy = new a(this.mContext, this.vA);
        this.vz = new ah((HttpClient)new DefaultHttpClient(), this.mContext);
        this.vC = 0L;
        this.vD = n2;
    }

    @Override
    public void j(long l2) {
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for clearHits");
        if (sQLiteDatabase != null) {
            if (l2 == 0L) {
                sQLiteDatabase.delete("hits2", null, null);
            } else {
                String[] stringArray = new String[]{Long.valueOf(l2).toString()};
                sQLiteDatabase.delete("hits2", "hit_app_id = ?", stringArray);
            }
            this.sO.r(this.cX() == 0);
        }
    }

    @Override
    public void a(Map<String, String> map, long l2, String string2, Collection<ef> collection) {
        this.cW();
        this.cV();
        this.a(map, collection);
        this.a(map, l2, string2);
    }

    private void a(Map<String, String> map, Collection<ef> collection) {
        String string2 = "&_v".substring(1);
        if (collection != null) {
            for (ef ef2 : collection) {
                if (!"appendVersion".equals(ef2.getId())) continue;
                map.put(string2, ef2.getValue());
                break;
            }
        }
    }

    private void cV() {
        int n2 = this.cX() - this.vD + 1;
        if (n2 > 0) {
            List<String> list = this.s(n2);
            aa.y("Store full, deleting " + list.size() + " hits to make room.");
            this.a(list.toArray(new String[0]));
        }
    }

    private void a(Map<String, String> map, long l2, String string2) {
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for putHit");
        if (sQLiteDatabase == null) {
            return;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("hit_string", ac.w(map));
        contentValues.put("hit_time", Long.valueOf(l2));
        long l3 = 0L;
        if (map.containsKey("AppUID")) {
            try {
                l3 = Long.parseLong(map.get("AppUID"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        contentValues.put("hit_app_id", Long.valueOf(l3));
        if (string2 == null) {
            string2 = "http://www.google-analytics.com/collect";
        }
        if (string2.length() == 0) {
            aa.z("Empty path: not sending hit");
            return;
        }
        contentValues.put("hit_url", string2);
        try {
            sQLiteDatabase.insert("hits2", null, contentValues);
            this.sO.r(false);
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error storing hit");
        }
    }

    static String w(Map<String, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            arrayList.add(y.encode(entry.getKey()) + "=" + y.encode(entry.getValue()));
        }
        return TextUtils.join((CharSequence)"&", arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> s(int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (n2 <= 0) {
            aa.z("Invalid maxHits specified. Skipping");
            return arrayList;
        }
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for peekHitIds.");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    arrayList.add(String.valueOf(cursor.getLong(0)));
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error in peekHits fetching hitIds: " + sQLiteException.getMessage());
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<x> t(int n2) {
        ArrayList<x> arrayList = new ArrayList<x>();
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for peekHits");
        if (sQLiteDatabase == null) {
            return arrayList;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_time"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            arrayList = new ArrayList();
            if (cursor.moveToFirst()) {
                do {
                    x x2 = new x(null, cursor.getLong(0), cursor.getLong(1));
                    arrayList.add(x2);
                } while (cursor.moveToNext());
            }
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error in peekHits fetching hitIds: " + sQLiteException.getMessage());
            ArrayList<x> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        int n3 = 0;
        try {
            CursorWindow cursorWindow;
            cursor = sQLiteDatabase.query("hits2", new String[]{"hit_id", "hit_string", "hit_url"}, null, null, null, null, String.format("%s ASC", "hit_id"), Integer.toString(n2));
            if (cursor.moveToFirst()) {
                do {
                    if ((cursorWindow = ((SQLiteCursor)cursor).getWindow()).getNumRows() > 0) {
                        ((x)arrayList.get(n3)).J(cursor.getString(1));
                        ((x)arrayList.get(n3)).K(cursor.getString(2));
                    } else {
                        aa.z(String.format("HitString for hitId %d too large.  Hit will be deleted.", ((x)arrayList.get(n3)).cP()));
                    }
                    ++n3;
                } while (cursor.moveToNext());
            }
            cursorWindow = arrayList;
            return cursorWindow;
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error in peekHits fetching hitString: " + sQLiteException.getMessage());
            ArrayList<x> arrayList3 = new ArrayList<x>();
            boolean bl2 = false;
            for (x x3 : arrayList) {
                if (TextUtils.isEmpty((CharSequence)x3.cO())) {
                    if (bl2) break;
                    bl2 = true;
                }
                arrayList3.add(x3);
            }
            ArrayList<x> arrayList4 = arrayList3;
            return arrayList4;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    int cW() {
        long l2 = this.tg.currentTimeMillis();
        if (l2 <= this.vC + 86400000L) {
            return 0;
        }
        this.vC = l2;
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for deleteStaleHits.");
        if (sQLiteDatabase == null) {
            return 0;
        }
        long l3 = this.tg.currentTimeMillis() - 2592000000L;
        int n2 = sQLiteDatabase.delete("hits2", "HIT_TIME < ?", new String[]{Long.toString(l3)});
        this.sO.r(this.cX() == 0);
        return n2;
    }

    @Deprecated
    void b(Collection<x> collection) {
        if (collection == null || collection.isEmpty()) {
            aa.z("Empty/Null collection passed to deleteHits.");
            return;
        }
        String[] stringArray = new String[collection.size()];
        int n2 = 0;
        for (x x2 : collection) {
            stringArray[n2++] = String.valueOf(x2.cP());
        }
        this.a(stringArray);
    }

    void a(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            aa.z("Empty hitIds passed to deleteHits.");
            return;
        }
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for deleteHits.");
        if (sQLiteDatabase == null) {
            return;
        }
        String string2 = String.format("HIT_ID in (%s)", TextUtils.join((CharSequence)",", Collections.nCopies(stringArray.length, "?")));
        try {
            sQLiteDatabase.delete("hits2", string2, stringArray);
            this.sO.r(this.cX() == 0);
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error deleting hits " + stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int cX() {
        int n2 = 0;
        SQLiteDatabase sQLiteDatabase = this.L("Error opening database for getNumStoredHits.");
        if (sQLiteDatabase == null) {
            return n2;
        }
        Cursor cursor = null;
        try {
            cursor = sQLiteDatabase.rawQuery("SELECT COUNT(*) from hits2", null);
            if (cursor.moveToFirst()) {
                n2 = (int)cursor.getLong(0);
            }
        }
        catch (SQLiteException sQLiteException) {
            aa.z("Error getting numStoredHits");
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return n2;
    }

    @Override
    public void bW() {
        int n2;
        aa.y("Dispatch running...");
        if (!this.vz.ch()) {
            return;
        }
        List<x> list = this.t(40);
        if (list.isEmpty()) {
            aa.y("...nothing to dispatch");
            this.sO.r(true);
            return;
        }
        if (this.vB == null) {
            this.vB = new ab("_t=dispatch&_v=ma4.0.1", true);
        }
        boolean bl2 = (n2 = this.cX()) <= list.size();
        int n3 = this.vz.a(list, this.vB, bl2);
        aa.y("sent " + n3 + " of " + list.size() + " hits");
        this.b(list.subList(0, Math.min(n3, list.size())));
        if (n3 == list.size() && this.cX() > 0) {
            GoogleAnalytics.getInstance(this.mContext).dispatchLocalHits();
        } else {
            this.vB = null;
        }
    }

    @Override
    public n bX() {
        return this.vz;
    }

    private SQLiteDatabase L(String string2) {
        SQLiteDatabase sQLiteDatabase = null;
        try {
            sQLiteDatabase = this.vy.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            aa.z(string2);
            return null;
        }
        return sQLiteDatabase;
    }

    class a
    extends SQLiteOpenHelper {
        private boolean vF;
        private long vG;

        a(Context context, String string2) {
            super(context, string2, null, 1);
            this.vG = 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean a(String string2, SQLiteDatabase sQLiteDatabase) {
            Cursor cursor = null;
            try {
                cursor = sQLiteDatabase.query("SQLITE_MASTER", new String[]{"name"}, "name=?", new String[]{string2}, null, null, null);
                boolean bl2 = cursor.moveToFirst();
                return bl2;
            }
            catch (SQLiteException sQLiteException) {
                aa.z("Error querying for table " + string2);
                boolean bl3 = false;
                return bl3;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }

        public SQLiteDatabase getWritableDatabase() {
            if (this.vF && this.vG + 3600000L > ac.this.tg.currentTimeMillis()) {
                throw new SQLiteException("Database creation failed");
            }
            SQLiteDatabase sQLiteDatabase = null;
            this.vF = true;
            this.vG = ac.this.tg.currentTimeMillis();
            try {
                sQLiteDatabase = super.getWritableDatabase();
            }
            catch (SQLiteException sQLiteException) {
                ac.this.mContext.getDatabasePath(ac.this.vA).delete();
            }
            if (sQLiteDatabase == null) {
                sQLiteDatabase = super.getWritableDatabase();
            }
            this.vF = false;
            return sQLiteDatabase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onOpen(SQLiteDatabase db2) {
            if (Build.VERSION.SDK_INT < 15) {
                Cursor cursor = db2.rawQuery("PRAGMA journal_mode=memory", null);
                try {
                    cursor.moveToFirst();
                }
                finally {
                    cursor.close();
                }
            }
            if (!this.a("hits2", db2)) {
                db2.execSQL(vx);
            } else {
                this.a(db2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void a(SQLiteDatabase sQLiteDatabase) {
            boolean bl2;
            Cursor cursor = sQLiteDatabase.rawQuery("SELECT * FROM hits2 WHERE 0", null);
            HashSet<String> hashSet = new HashSet<String>();
            try {
                String[] stringArray = cursor.getColumnNames();
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    hashSet.add(stringArray[i2]);
                }
            }
            finally {
                cursor.close();
            }
            if (!(hashSet.remove("hit_id") && hashSet.remove("hit_url") && hashSet.remove("hit_string") && hashSet.remove("hit_time"))) {
                throw new SQLiteException("Database column missing");
            }
            boolean bl3 = bl2 = !hashSet.remove("hit_app_id");
            if (!hashSet.isEmpty()) {
                throw new SQLiteException("Database has extra columns");
            }
            if (bl2) {
                sQLiteDatabase.execSQL("ALTER TABLE hits2 ADD COLUMN hit_app_id");
            }
        }

        public void onCreate(SQLiteDatabase db2) {
            p.G(db2.getPath());
        }

        public void onUpgrade(SQLiteDatabase db2, int oldVersion, int newVersion) {
        }
    }
}

