/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.analytics;

import android.text.TextUtils;
import com.google.android.gms.analytics.aa;
import com.google.android.gms.analytics.ak;
import com.google.android.gms.analytics.o;
import com.google.android.gms.analytics.u;
import java.util.HashMap;
import java.util.Map;

public class HitBuilders {

    public static class ScreenViewBuilder
    extends HitBuilder<ScreenViewBuilder> {
        public ScreenViewBuilder() {
            u.cy().a(u.a.uS);
            this.set("&t", "appview");
        }
    }

    @Deprecated
    public static class AppViewBuilder
    extends HitBuilder<AppViewBuilder> {
        public AppViewBuilder() {
            u.cy().a(u.a.uS);
            this.set("&t", "appview");
        }
    }

    public static class ItemBuilder
    extends HitBuilder<ItemBuilder> {
        public ItemBuilder() {
            u.cy().a(u.a.uH);
            this.set("&t", "item");
        }

        public ItemBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public ItemBuilder setName(String name) {
            this.set("&in", name);
            return this;
        }

        public ItemBuilder setSku(String sku) {
            this.set("&ic", sku);
            return this;
        }

        public ItemBuilder setCategory(String category) {
            this.set("&iv", category);
            return this;
        }

        public ItemBuilder setPrice(double price) {
            this.set("&ip", Double.toString(price));
            return this;
        }

        public ItemBuilder setQuantity(long quantity) {
            this.set("&iq", Long.toString(quantity));
            return this;
        }

        public ItemBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    public static class TransactionBuilder
    extends HitBuilder<TransactionBuilder> {
        public TransactionBuilder() {
            u.cy().a(u.a.uo);
            this.set("&t", "transaction");
        }

        public TransactionBuilder setTransactionId(String transactionid) {
            this.set("&ti", transactionid);
            return this;
        }

        public TransactionBuilder setAffiliation(String affiliation) {
            this.set("&ta", affiliation);
            return this;
        }

        public TransactionBuilder setRevenue(double revenue) {
            this.set("&tr", Double.toString(revenue));
            return this;
        }

        public TransactionBuilder setTax(double tax) {
            this.set("&tt", Double.toString(tax));
            return this;
        }

        public TransactionBuilder setShipping(double shipping) {
            this.set("&ts", Double.toString(shipping));
            return this;
        }

        public TransactionBuilder setCurrencyCode(String currencyCode) {
            this.set("&cu", currencyCode);
            return this;
        }
    }

    public static class ExceptionBuilder
    extends HitBuilder<ExceptionBuilder> {
        public ExceptionBuilder() {
            u.cy().a(u.a.up);
            this.set("&t", "exception");
        }

        public ExceptionBuilder setDescription(String description) {
            this.set("&exd", description);
            return this;
        }

        public ExceptionBuilder setFatal(boolean fatal) {
            this.set("&exf", ak.u(fatal));
            return this;
        }
    }

    public static class TimingBuilder
    extends HitBuilder<TimingBuilder> {
        public TimingBuilder() {
            u.cy().a(u.a.ur);
            this.set("&t", "timing");
        }

        public TimingBuilder(String category, String variable, long value) {
            this();
            this.setVariable(variable);
            this.setValue(value);
            this.setCategory(category);
        }

        public TimingBuilder setVariable(String variable) {
            this.set("&utv", variable);
            return this;
        }

        public TimingBuilder setValue(long value) {
            this.set("&utt", Long.toString(value));
            return this;
        }

        public TimingBuilder setCategory(String category) {
            this.set("&utc", category);
            return this;
        }

        public TimingBuilder setLabel(String label) {
            this.set("&utl", label);
            return this;
        }
    }

    public static class SocialBuilder
    extends HitBuilder<SocialBuilder> {
        public SocialBuilder() {
            u.cy().a(u.a.us);
            this.set("&t", "social");
        }

        public SocialBuilder setNetwork(String network) {
            this.set("&sn", network);
            return this;
        }

        public SocialBuilder setAction(String action) {
            this.set("&sa", action);
            return this;
        }

        public SocialBuilder setTarget(String target) {
            this.set("&st", target);
            return this;
        }
    }

    public static class EventBuilder
    extends HitBuilder<EventBuilder> {
        public EventBuilder() {
            u.cy().a(u.a.uG);
            this.set("&t", "event");
        }

        public EventBuilder(String category, String action) {
            this();
            this.setCategory(category);
            this.setAction(action);
        }

        public EventBuilder setCategory(String category) {
            this.set("&ec", category);
            return this;
        }

        public EventBuilder setAction(String action) {
            this.set("&ea", action);
            return this;
        }

        public EventBuilder setLabel(String label) {
            this.set("&el", label);
            return this;
        }

        public EventBuilder setValue(long value) {
            this.set("&ev", Long.toString(value));
            return this;
        }
    }

    protected static class HitBuilder<T extends HitBuilder> {
        private Map<String, String> vl = new HashMap<String, String>();

        protected HitBuilder() {
        }

        public T setNewSession() {
            this.set("&sc", "start");
            return (T)this;
        }

        public T setNonInteraction(boolean nonInteraction) {
            this.set("&ni", ak.u(nonInteraction));
            return (T)this;
        }

        public T setCampaignParamsFromUrl(String utmParams) {
            u.cy().a(u.a.tL);
            String string2 = ak.O(utmParams);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return (T)this;
            }
            Map<String, String> map = ak.N(string2);
            this.set("&cc", map.get("utm_content"));
            this.set("&cm", map.get("utm_medium"));
            this.set("&cn", map.get("utm_campaign"));
            this.set("&cs", map.get("utm_source"));
            this.set("&ck", map.get("utm_term"));
            this.set("&ci", map.get("utm_id"));
            this.set("&gclid", map.get("gclid"));
            this.set("&dclid", map.get("dclid"));
            this.set("&gmob_t", map.get("gmob_t"));
            return (T)this;
        }

        public T setCustomDimension(int index, String dimension) {
            this.set(o.q(index), dimension);
            return (T)this;
        }

        public T setCustomMetric(int index, float metric) {
            this.set(o.r(index), Float.toString(metric));
            return (T)this;
        }

        public final T set(String paramName, String paramValue) {
            u.cy().a(u.a.tI);
            if (paramName != null) {
                this.vl.put(paramName, paramValue);
            } else {
                aa.z(" HitBuilder.set() called with a null paramName.");
            }
            return (T)this;
        }

        public final T setAll(Map<String, String> params) {
            u.cy().a(u.a.tJ);
            if (params == null) {
                return (T)this;
            }
            this.vl.putAll(new HashMap<String, String>(params));
            return (T)this;
        }

        public Map<String, String> build() {
            return this.vl;
        }

        protected T setHitType(String hitType) {
            this.set("&t", hitType);
            return (T)this;
        }

        protected String get(String paramName) {
            return this.vl.get(paramName);
        }
    }
}

