/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.common.Key;
import com.google.analytics.containertag.proto.Serving;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.Log;
import com.google.tagmanager.Types;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ResourceUtil {
    private ResourceUtil() {
    }

    public static ExpandedResource getExpandedResource(Serving.Resource resource) throws InvalidResourceException {
        TypeSystem.Value[] expandedValues = new TypeSystem.Value[resource.getValueCount()];
        for (int i = 0; i < resource.getValueCount(); ++i) {
            ResourceUtil.expandValue(i, resource, expandedValues, new HashSet<Integer>(0));
        }
        ExpandedResourceBuilder builder = ExpandedResource.newBuilder();
        ArrayList<ExpandedFunctionCall> tags = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.getTagCount(); ++i) {
            tags.add(ResourceUtil.expandFunctionCall(resource.getTag(i), resource, expandedValues, i));
        }
        ArrayList<ExpandedFunctionCall> predicates = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.getPredicateCount(); ++i) {
            predicates.add(ResourceUtil.expandFunctionCall(resource.getPredicate(i), resource, expandedValues, i));
        }
        ArrayList<ExpandedFunctionCall> macros = new ArrayList<ExpandedFunctionCall>();
        for (int i = 0; i < resource.getMacroCount(); ++i) {
            ExpandedFunctionCall thisMacro = ResourceUtil.expandFunctionCall(resource.getMacro(i), resource, expandedValues, i);
            builder.addMacro(thisMacro);
            macros.add(thisMacro);
        }
        for (Serving.Rule r : resource.getRuleList()) {
            builder.addRule(ResourceUtil.expandRule(r, tags, macros, predicates, resource));
        }
        builder.setVersion(resource.getVersion());
        builder.setResourceFormatVersion(resource.getResourceFormatVersion());
        return builder.build();
    }

    public static TypeSystem.Value.Builder newValueBuilderBasedOnValue(TypeSystem.Value v) {
        TypeSystem.Value.Builder result = TypeSystem.Value.newBuilder().setType(v.getType()).addAllEscaping(v.getEscapingList());
        if (v.getContainsReferences()) {
            result.setContainsReferences(true);
        }
        return result;
    }

    private static TypeSystem.Value expandValue(int i, Serving.Resource resource, TypeSystem.Value[] expandedValues, Set<Integer> pendingExpansions) throws InvalidResourceException {
        if (pendingExpansions.contains(i)) {
            ResourceUtil.logAndThrow("Value cycle detected.  Current value reference: " + i + "." + "  Previous value references: " + pendingExpansions + ".");
        }
        TypeSystem.Value value = ResourceUtil.getWithBoundsCheck(resource.getValueList(), i, "values");
        if (expandedValues[i] != null) {
            return expandedValues[i];
        }
        TypeSystem.Value toAdd = null;
        pendingExpansions.add(i);
        switch (value.getType()) {
            case LIST: {
                TypeSystem.Value.Builder builder = ResourceUtil.newValueBuilderBasedOnValue(value);
                for (Integer listIndex : ResourceUtil.getServingValue(value).getListItemList()) {
                    builder.addListItem(ResourceUtil.expandValue(listIndex, resource, expandedValues, pendingExpansions));
                }
                toAdd = builder.build();
                break;
            }
            case MAP: {
                TypeSystem.Value.Builder builder = ResourceUtil.newValueBuilderBasedOnValue(value);
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                if (servingValue.getMapKeyCount() != servingValue.getMapValueCount()) {
                    ResourceUtil.logAndThrow("Uneven map keys (" + servingValue.getMapKeyCount() + ") and map values (" + servingValue.getMapValueCount() + ")");
                }
                for (Integer keyIndex : servingValue.getMapKeyList()) {
                    builder.addMapKey(ResourceUtil.expandValue(keyIndex, resource, expandedValues, pendingExpansions));
                }
                for (Integer valueIndex : servingValue.getMapValueList()) {
                    builder.addMapValue(ResourceUtil.expandValue(valueIndex, resource, expandedValues, pendingExpansions));
                }
                toAdd = builder.build();
                break;
            }
            case MACRO_REFERENCE: {
                String macroName;
                TypeSystem.Value.Builder builder = ResourceUtil.newValueBuilderBasedOnValue(value);
                Serving.ServingValue servingValue = ResourceUtil.getServingValue(value);
                if (!servingValue.hasMacroNameReference()) {
                    ResourceUtil.logAndThrow("Missing macro name reference");
                    macroName = "";
                } else {
                    TypeSystem.Value macroNameValue = ResourceUtil.expandValue(servingValue.getMacroNameReference(), resource, expandedValues, pendingExpansions);
                    macroName = Types.valueToString(macroNameValue);
                }
                builder.setMacroReference(macroName);
                toAdd = builder.build();
                break;
            }
            case TEMPLATE: {
                TypeSystem.Value.Builder builder = ResourceUtil.newValueBuilderBasedOnValue(value);
                for (Integer templateIndex : ResourceUtil.getServingValue(value).getTemplateTokenList()) {
                    builder.addTemplateToken(ResourceUtil.expandValue(templateIndex, resource, expandedValues, pendingExpansions));
                }
                toAdd = builder.build();
                break;
            }
            case STRING: 
            case FUNCTION_ID: 
            case INTEGER: 
            case BOOLEAN: {
                toAdd = value;
            }
        }
        if (toAdd == null) {
            ResourceUtil.logAndThrow("Invalid value: " + value);
        }
        expandedValues[i] = toAdd;
        pendingExpansions.remove(i);
        return toAdd;
    }

    private static Serving.ServingValue getServingValue(TypeSystem.Value value) throws InvalidResourceException {
        if (!value.hasExtension(Serving.ServingValue.ext)) {
            ResourceUtil.logAndThrow("Expected a ServingValue and didn't get one. Value is: " + value);
        }
        return value.getExtension(Serving.ServingValue.ext);
    }

    private static void logAndThrow(String error) throws InvalidResourceException {
        Log.e(error);
        throw new InvalidResourceException(error);
    }

    private static <T> T getWithBoundsCheck(T[] array, int idx, String listName) throws InvalidResourceException {
        if (idx < 0 || idx >= array.length) {
            ResourceUtil.logAndThrow("Index out of bounds detected: " + idx + " in " + listName);
        }
        return array[idx];
    }

    private static <T> T getWithBoundsCheck(List<T> list, int idx, String listName) throws InvalidResourceException {
        if (idx < 0 || idx >= list.size()) {
            ResourceUtil.logAndThrow("Index out of bounds detected: " + idx + " in " + listName);
        }
        return list.get(idx);
    }

    private static ExpandedFunctionCall expandFunctionCall(Serving.FunctionCall functionCall, Serving.Resource resource, TypeSystem.Value[] expandedValues, int idx) throws InvalidResourceException {
        ExpandedFunctionCallBuilder builder = ExpandedFunctionCall.newBuilder();
        for (Integer i : functionCall.getPropertyList()) {
            Serving.Property p = ResourceUtil.getWithBoundsCheck(resource.getPropertyList(), (int)i, "properties");
            String key = ResourceUtil.getWithBoundsCheck(resource.getKeyList(), p.getKey(), "keys");
            TypeSystem.Value value = ResourceUtil.getWithBoundsCheck(expandedValues, p.getValue(), "values");
            builder.addProperty(key, value);
        }
        return builder.build();
    }

    private static ExpandedRule expandRule(Serving.Rule rule, List<ExpandedFunctionCall> tags, List<ExpandedFunctionCall> macros, List<ExpandedFunctionCall> predicates, Serving.Resource resource) {
        ExpandedRuleBuilder ruleBuilder = ExpandedRule.newBuilder();
        for (Integer i : rule.getPositivePredicateList()) {
            ruleBuilder.addPositivePredicate(predicates.get(i));
        }
        for (Integer i : rule.getNegativePredicateList()) {
            ruleBuilder.addNegativePredicate(predicates.get(i));
        }
        for (Integer tagIndex : rule.getAddTagList()) {
            ruleBuilder.addAddTag(tags.get(tagIndex));
        }
        for (Integer ruleNameIndex : rule.getAddTagRuleNameList()) {
            ruleBuilder.addAddTagRuleName(resource.getValue(ruleNameIndex).getString());
        }
        for (Integer tagIndex : rule.getRemoveTagList()) {
            ruleBuilder.addRemoveTag(tags.get(tagIndex));
        }
        for (Integer ruleNameIndex : rule.getRemoveTagRuleNameList()) {
            ruleBuilder.addRemoveTagRuleName(resource.getValue(ruleNameIndex).getString());
        }
        for (Integer macroIndex : rule.getAddMacroList()) {
            ruleBuilder.addAddMacro(macros.get(macroIndex));
        }
        for (Integer ruleNameIndex : rule.getAddMacroRuleNameList()) {
            ruleBuilder.addAddMacroRuleName(resource.getValue(ruleNameIndex).getString());
        }
        for (Integer macroIndex : rule.getRemoveMacroList()) {
            ruleBuilder.addRemoveMacro(macros.get(macroIndex));
        }
        for (Integer ruleNameIndex : rule.getRemoveMacroRuleNameList()) {
            ruleBuilder.addRemoveMacroRuleName(resource.getValue(ruleNameIndex).getString());
        }
        return ruleBuilder.build();
    }

    public static class ExpandedResource {
        private final List<ExpandedRule> mRules;
        private final Map<String, List<ExpandedFunctionCall>> mMacros;
        private final String mVersion;
        private final int mResourceFormatVersion;

        private ExpandedResource(List<ExpandedRule> rules, Map<String, List<ExpandedFunctionCall>> macros, String version, int resourceFormatVersion) {
            this.mRules = Collections.unmodifiableList(rules);
            this.mMacros = Collections.unmodifiableMap(macros);
            this.mVersion = version;
            this.mResourceFormatVersion = resourceFormatVersion;
        }

        public static ExpandedResourceBuilder newBuilder() {
            return new ExpandedResourceBuilder();
        }

        public List<ExpandedRule> getRules() {
            return this.mRules;
        }

        public String getVersion() {
            return this.mVersion;
        }

        public int getResourceFormatVersion() {
            return this.mResourceFormatVersion;
        }

        public List<ExpandedFunctionCall> getMacros(String name) {
            return this.mMacros.get(name);
        }

        public Map<String, List<ExpandedFunctionCall>> getAllMacros() {
            return this.mMacros;
        }

        public String toString() {
            return "Rules: " + this.getRules() + "  Macros: " + this.mMacros;
        }
    }

    public static class ExpandedResourceBuilder {
        private final List<ExpandedRule> mRules = new ArrayList<ExpandedRule>();
        private final List<ExpandedFunctionCall> mTags = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mPredicates = new ArrayList<ExpandedFunctionCall>();
        private final Map<String, List<ExpandedFunctionCall>> mMacros = new HashMap<String, List<ExpandedFunctionCall>>();
        private String mVersion = "";
        private int mResourceFormatVersion = 0;

        private ExpandedResourceBuilder() {
        }

        public ExpandedResourceBuilder addRule(ExpandedRule r) {
            this.mRules.add(r);
            return this;
        }

        public ExpandedResourceBuilder addMacro(ExpandedFunctionCall f) {
            String macroName = Types.valueToString(f.getProperties().get(Key.INSTANCE_NAME.toString()));
            List<ExpandedFunctionCall> macroList = this.mMacros.get(macroName);
            if (macroList == null) {
                macroList = new ArrayList<ExpandedFunctionCall>();
                this.mMacros.put(macroName, macroList);
            }
            macroList.add(f);
            return this;
        }

        public ExpandedResourceBuilder setVersion(String version) {
            this.mVersion = version;
            return this;
        }

        public ExpandedResourceBuilder setResourceFormatVersion(int resourceFormatVersion) {
            this.mResourceFormatVersion = resourceFormatVersion;
            return this;
        }

        public ExpandedResource build() {
            return new ExpandedResource(this.mRules, this.mMacros, this.mVersion, this.mResourceFormatVersion);
        }
    }

    public static class ExpandedRule {
        private final List<ExpandedFunctionCall> mPositivePredicates;
        private final List<ExpandedFunctionCall> mNegativePredicates;
        private final List<ExpandedFunctionCall> mAddTags;
        private final List<ExpandedFunctionCall> mRemoveTags;
        private final List<ExpandedFunctionCall> mAddMacros;
        private final List<ExpandedFunctionCall> mRemoveMacros;
        private final List<String> mAddMacroRuleNames;
        private final List<String> mRemoveMacroRuleNames;
        private final List<String> mAddTagRuleNames;
        private final List<String> mRemoveTagRuleNames;

        private ExpandedRule(List<ExpandedFunctionCall> postivePredicates, List<ExpandedFunctionCall> negativePredicates, List<ExpandedFunctionCall> addTags, List<ExpandedFunctionCall> removeTags, List<ExpandedFunctionCall> addMacros, List<ExpandedFunctionCall> removeMacros, List<String> addMacroRuleNames, List<String> removeMacroRuleNames, List<String> addTagRuleNames, List<String> removeTagRuleNames) {
            this.mPositivePredicates = Collections.unmodifiableList(postivePredicates);
            this.mNegativePredicates = Collections.unmodifiableList(negativePredicates);
            this.mAddTags = Collections.unmodifiableList(addTags);
            this.mRemoveTags = Collections.unmodifiableList(removeTags);
            this.mAddMacros = Collections.unmodifiableList(addMacros);
            this.mRemoveMacros = Collections.unmodifiableList(removeMacros);
            this.mAddMacroRuleNames = Collections.unmodifiableList(addMacroRuleNames);
            this.mRemoveMacroRuleNames = Collections.unmodifiableList(removeMacroRuleNames);
            this.mAddTagRuleNames = Collections.unmodifiableList(addTagRuleNames);
            this.mRemoveTagRuleNames = Collections.unmodifiableList(removeTagRuleNames);
        }

        public static ExpandedRuleBuilder newBuilder() {
            return new ExpandedRuleBuilder();
        }

        public List<ExpandedFunctionCall> getPositivePredicates() {
            return this.mPositivePredicates;
        }

        public List<ExpandedFunctionCall> getNegativePredicates() {
            return this.mNegativePredicates;
        }

        public List<ExpandedFunctionCall> getAddTags() {
            return this.mAddTags;
        }

        public List<ExpandedFunctionCall> getRemoveTags() {
            return this.mRemoveTags;
        }

        public List<ExpandedFunctionCall> getAddMacros() {
            return this.mAddMacros;
        }

        public List<String> getAddMacroRuleNames() {
            return this.mAddMacroRuleNames;
        }

        public List<String> getRemoveMacroRuleNames() {
            return this.mRemoveMacroRuleNames;
        }

        public List<String> getAddTagRuleNames() {
            return this.mAddTagRuleNames;
        }

        public List<String> getRemoveTagRuleNames() {
            return this.mRemoveTagRuleNames;
        }

        public List<ExpandedFunctionCall> getRemoveMacros() {
            return this.mRemoveMacros;
        }

        public String toString() {
            return "Positive predicates: " + this.getPositivePredicates() + "  Negative predicates: " + this.getNegativePredicates() + "  Add tags: " + this.getAddTags() + "  Remove tags: " + this.getRemoveTags() + "  Add macros: " + this.getAddMacros() + "  Remove macros: " + this.getRemoveMacros();
        }
    }

    public static class ExpandedRuleBuilder {
        private final List<ExpandedFunctionCall> mPositivePredicates = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mNegativePredicates = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mAddTags = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mRemoveTags = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mAddMacros = new ArrayList<ExpandedFunctionCall>();
        private final List<ExpandedFunctionCall> mRemoveMacros = new ArrayList<ExpandedFunctionCall>();
        private final List<String> mAddMacroRuleNames = new ArrayList<String>();
        private final List<String> mRemoveMacroRuleNames = new ArrayList<String>();
        private final List<String> mAddTagRuleNames = new ArrayList<String>();
        private final List<String> mRemoveTagRuleNames = new ArrayList<String>();

        private ExpandedRuleBuilder() {
        }

        public ExpandedRuleBuilder addPositivePredicate(ExpandedFunctionCall f) {
            this.mPositivePredicates.add(f);
            return this;
        }

        public ExpandedRuleBuilder addNegativePredicate(ExpandedFunctionCall f) {
            this.mNegativePredicates.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddTag(ExpandedFunctionCall f) {
            this.mAddTags.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddTagRuleName(String ruleName) {
            this.mAddTagRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addRemoveTag(ExpandedFunctionCall f) {
            this.mRemoveTags.add(f);
            return this;
        }

        public ExpandedRuleBuilder addRemoveTagRuleName(String ruleName) {
            this.mRemoveTagRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addAddMacro(ExpandedFunctionCall f) {
            this.mAddMacros.add(f);
            return this;
        }

        public ExpandedRuleBuilder addAddMacroRuleName(String ruleName) {
            this.mAddMacroRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRuleBuilder addRemoveMacro(ExpandedFunctionCall f) {
            this.mRemoveMacros.add(f);
            return this;
        }

        public ExpandedRuleBuilder addRemoveMacroRuleName(String ruleName) {
            this.mRemoveMacroRuleNames.add(ruleName);
            return this;
        }

        public ExpandedRule build() {
            return new ExpandedRule(this.mPositivePredicates, this.mNegativePredicates, this.mAddTags, this.mRemoveTags, this.mAddMacros, this.mRemoveMacros, this.mAddMacroRuleNames, this.mRemoveMacroRuleNames, this.mAddTagRuleNames, this.mRemoveTagRuleNames);
        }
    }

    public static class ExpandedFunctionCall {
        private final Map<String, TypeSystem.Value> mPropertiesMap;

        private ExpandedFunctionCall(Map<String, TypeSystem.Value> propertiesMap) {
            this.mPropertiesMap = propertiesMap;
        }

        public static ExpandedFunctionCallBuilder newBuilder() {
            return new ExpandedFunctionCallBuilder();
        }

        public void updateCacheableProperty(String key, TypeSystem.Value v) {
            this.mPropertiesMap.put(key, v);
        }

        public Map<String, TypeSystem.Value> getProperties() {
            return Collections.unmodifiableMap(this.mPropertiesMap);
        }

        public String toString() {
            return "Properties: " + this.getProperties();
        }
    }

    public static class ExpandedFunctionCallBuilder {
        private final Map<String, TypeSystem.Value> mPropertiesMap = new HashMap<String, TypeSystem.Value>();

        private ExpandedFunctionCallBuilder() {
        }

        public ExpandedFunctionCallBuilder addProperty(String key, TypeSystem.Value value) {
            this.mPropertiesMap.put(key, value);
            return this;
        }

        public ExpandedFunctionCall build() {
            return new ExpandedFunctionCall(this.mPropertiesMap);
        }
    }

    public static class InvalidResourceException
    extends Exception {
        public InvalidResourceException(String s) {
            super(s);
        }
    }
}

