/*
 * Decompiled with CFR 0.152.
 */
package com.google.analytics.tracking.android;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.RemoteException;
import com.google.analytics.tracking.android.AnalyticsClient;
import com.google.analytics.tracking.android.Log;
import com.google.android.gms.analytics.internal.Command;
import com.google.android.gms.analytics.internal.IAnalyticsService;
import java.util.List;
import java.util.Map;

class AnalyticsGmsCoreClient
implements AnalyticsClient {
    public static final int BIND_FAILED = 1;
    public static final int REMOTE_EXECUTION_FAILED = 2;
    private static final String SERVICE_DESCRIPTOR = "com.google.android.gms.analytics.internal.IAnalyticsService";
    static final String SERVICE_ACTION = "com.google.android.gms.analytics.service.START";
    private static final int BIND_ADJUST_WITH_ACTIVITY = 128;
    public static final String KEY_APP_PACKAGE_NAME = "app_package_name";
    private ServiceConnection mConnection;
    private OnConnectedListener mOnConnectedListener;
    private OnConnectionFailedListener mOnConnectionFailedListener;
    private Context mContext;
    private IAnalyticsService mService;

    public AnalyticsGmsCoreClient(Context context, OnConnectedListener onConnectedListener, OnConnectionFailedListener onConnectionFailedListener) {
        this.mContext = context;
        if (onConnectedListener == null) {
            throw new IllegalArgumentException("onConnectedListener cannot be null");
        }
        this.mOnConnectedListener = onConnectedListener;
        if (onConnectionFailedListener == null) {
            throw new IllegalArgumentException("onConnectionFailedListener cannot be null");
        }
        this.mOnConnectionFailedListener = onConnectionFailedListener;
    }

    @Override
    public void connect() {
        Intent intent = new Intent(SERVICE_ACTION);
        intent.putExtra(KEY_APP_PACKAGE_NAME, this.mContext.getPackageName());
        if (this.mConnection != null) {
            Log.e("Calling connect() while still connected, missing disconnect().");
            return;
        }
        this.mConnection = new AnalyticsServiceConnection();
        boolean result = this.mContext.bindService(intent, this.mConnection, 129);
        Log.v("connect: bindService returned " + result + " for " + intent);
        if (!result) {
            this.mConnection = null;
            this.mOnConnectionFailedListener.onConnectionFailed(1, null);
        }
    }

    @Override
    public void disconnect() {
        this.mService = null;
        if (this.mConnection != null) {
            try {
                this.mContext.unbindService(this.mConnection);
            }
            catch (IllegalStateException e) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.mConnection = null;
            this.mOnConnectedListener.onDisconnected();
        }
    }

    @Override
    public void sendHit(Map<String, String> wireParams, long hitTimeInMilliseconds, String path, List<Command> commands) {
        try {
            this.getService().sendHit(wireParams, hitTimeInMilliseconds, path, commands);
        }
        catch (RemoteException e) {
            Log.e("sendHit failed: " + (Object)((Object)e));
        }
    }

    @Override
    public void clearHits() {
        try {
            this.getService().clearHits();
        }
        catch (RemoteException e) {
            Log.e("clear hits failed: " + (Object)((Object)e));
        }
    }

    private IAnalyticsService getService() {
        this.checkConnected();
        return this.mService;
    }

    protected void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    public boolean isConnected() {
        return this.mService != null;
    }

    private void onServiceBound() {
        this.onConnectionSuccess();
    }

    private void onConnectionSuccess() {
        this.mOnConnectedListener.onConnected();
    }

    public static interface OnConnectionFailedListener {
        public void onConnectionFailed(int var1, Intent var2);
    }

    public static interface OnConnectedListener {
        public void onConnected();

        public void onDisconnected();
    }

    final class AnalyticsServiceConnection
    implements ServiceConnection {
        AnalyticsServiceConnection() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            Log.v("service connected, binder: " + binder);
            String descriptor = null;
            try {
                descriptor = binder.getInterfaceDescriptor();
                if (AnalyticsGmsCoreClient.SERVICE_DESCRIPTOR.equals(descriptor)) {
                    Log.v("bound to service");
                    AnalyticsGmsCoreClient.this.mService = IAnalyticsService.Stub.asInterface(binder);
                    AnalyticsGmsCoreClient.this.onServiceBound();
                    return;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            AnalyticsGmsCoreClient.this.mContext.unbindService((ServiceConnection)this);
            AnalyticsGmsCoreClient.this.mConnection = null;
            AnalyticsGmsCoreClient.this.mOnConnectionFailedListener.onConnectionFailed(2, null);
        }

        public void onServiceDisconnected(ComponentName component) {
            Log.v("service disconnected: " + component);
            AnalyticsGmsCoreClient.this.mConnection = null;
            AnalyticsGmsCoreClient.this.mOnConnectedListener.onDisconnected();
        }
    }
}

