package interactivepalmistry.findyourfate.com;
import java.io.File;


import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List; 
import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper; 
import android.util.Log;
public class DatabaseHandler  extends SQLiteOpenHelper {
    private static String TAG = "DataBaseHelper";
    private static SQLiteDatabase mDataBase;  
    private static final String DATABASE_NAME = "palmdb"; 
    private static final String TABLE_CONTACTS = "palmistry"; 
    private static final String main = "main_title";
    private static final String  sub = "sub_title";
    private static final String  tablec= "table_content";
  
    private Context mContext; 
    private static final String CREATE_CONTACTS_TABLE = "CREATE TABLE " + TABLE_CONTACTS + "("
    		+ main + " TEXT,"+ sub + " TEXT,"+ tablec + " TEXT"+ ")";
    
    public DatabaseHandler(Context context) throws IOException {
        super(context,DATABASE_NAME,null,1);
        this.mContext=context;
        boolean dbexist = checkDataBase();
        if (dbexist) {
           System.out.println("Database exists");
            openDataBase(); 
        } else {
            System.out.println("Database doesn't exist");
            createDataBase();
        }
    }
  
    public void createDataBase() throws IOException
    {
        //If database not exists copy it from the assets
    	
        boolean mDataBaseExist = checkDataBase();
        if(!mDataBaseExist)
        {
            this.getReadableDatabase();
            this.close();
            try 
            {
                //Copy the database from assests
                copyDataBase();
                Log.e(TAG, "createDatabase database created");
            } 
            catch (IOException mIOException) 
            {
                throw new Error("ErrorCopyingDataBase");
            }
        }
    }
    private boolean checkDataBase()
    {
       	File dbFile = mContext.getDatabasePath(DATABASE_NAME);
        SQLiteDatabase checkDB = null;
        
    	try{
    		checkDB = SQLiteDatabase.openDatabase(dbFile.getPath(), null, SQLiteDatabase.OPEN_READWRITE);
 
    	}catch(SQLiteException e){
 
    		//database does't exist yet.
 
    	}
     	if(checkDB != null){
    		checkDB.close();
    	}
    	return checkDB != null ? true : false;        
    }

    //Copy the database from assets
    private void copyDataBase() throws IOException
    {
    	File dbFile = mContext.getDatabasePath(DATABASE_NAME);
        InputStream mInput = mContext.getAssets().open(DATABASE_NAME);
        OutputStream mOutput = new FileOutputStream(dbFile);
        byte[] mBuffer = new byte[1024];
        int mLength;
        while ((mLength = mInput.read(mBuffer))>0)
        {
            mOutput.write(mBuffer, 0, mLength);
        }
        mOutput.flush();
        mOutput.close();
        mInput.close();
    }

    //Open the database, so we can query it
    public void openDataBase() throws SQLException
    {
      File dbFile = mContext.getDatabasePath(DATABASE_NAME);
      mDataBase = SQLiteDatabase.openDatabase(dbFile.getPath(), null, SQLiteDatabase.OPEN_READONLY);
    }

    @Override
    public synchronized void close() 
    {
        if(mDataBase != null)
            mDataBase.close();
        super.close();
    }
   @Override
   public void onCreate(SQLiteDatabase db) {
                 db.execSQL(CREATE_CONTACTS_TABLE);
    }
   
    @Override
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_CONTACTS); 
        onCreate(db);
    	}      
    
	public List<Content> getAllContacts() {
		List<Content> contactList = new ArrayList<Content>();
			   File dbFile = mContext.getDatabasePath(DATABASE_NAME);			  
			   mDataBase = SQLiteDatabase.openDatabase(dbFile.getPath(), null,SQLiteDatabase.OPEN_READWRITE);
		/*	   Calendar c = Calendar.getInstance();
			   int tday  =c.get(Calendar.DAY_OF_MONTH);
			   int tmonth=c.get(Calendar.MONTH)+1;
			   int tyear =c.get(Calendar.YEAR);
				 
				  Cursor cursor = mDataBase.rawQuery("SELECT * FROM ephemeris WHERE day='"+tday+"' AND month='"+tmonth+"' AND year='"+tyear+"' ", null);   
		 	 	  if (cursor.moveToFirst())
		        {
		      do {
		    	  Content contact = new Content();	    	    
		    	   	contact.setSign(cursor.getString(3));
				    contactList.add(contact);
		      }	while (cursor.moveToNext());
		      cursor.close();
		      } 
		 */
		// return contact list
		return contactList;
	}

}
