/*
 * Decompiled with CFR 0.152.
 */
package interactivepalmistry.findyourfate.com;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import interactivepalmistry.findyourfate.com.Content;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class DatabaseHandler
extends SQLiteOpenHelper {
    private static String TAG = "DataBaseHelper";
    private static SQLiteDatabase mDataBase;
    private static final String DATABASE_NAME = "palmdb";
    private static final String TABLE_CONTACTS = "palmistry";
    private static final String main = "main_title";
    private static final String sub = "sub_title";
    private static final String tablec = "table_content";
    private Context mContext;
    private static final String CREATE_CONTACTS_TABLE = "CREATE TABLE palmistry(main_title TEXT,sub_title TEXT,table_content TEXT)";

    public DatabaseHandler(Context context) throws IOException {
        super(context, DATABASE_NAME, null, 1);
        this.mContext = context;
        boolean dbexist = this.checkDataBase();
        if (dbexist) {
            System.out.println("Database exists");
            this.openDataBase();
        } else {
            System.out.println("Database doesn't exist");
            this.createDataBase();
        }
    }

    public void createDataBase() throws IOException {
        boolean mDataBaseExist = this.checkDataBase();
        if (!mDataBaseExist) {
            this.getReadableDatabase();
            this.close();
            try {
                this.copyDataBase();
                Log.e((String)TAG, (String)"createDatabase database created");
            }
            catch (IOException mIOException) {
                throw new Error("ErrorCopyingDataBase");
            }
        }
    }

    private boolean checkDataBase() {
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        SQLiteDatabase checkDB = null;
        try {
            checkDB = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0);
        }
        catch (SQLiteException sQLiteException) {
            // empty catch block
        }
        if (checkDB != null) {
            checkDB.close();
        }
        return checkDB != null;
    }

    private void copyDataBase() throws IOException {
        int mLength;
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        InputStream mInput = this.mContext.getAssets().open(DATABASE_NAME);
        FileOutputStream mOutput = new FileOutputStream(dbFile);
        byte[] mBuffer = new byte[1024];
        while ((mLength = mInput.read(mBuffer)) > 0) {
            ((OutputStream)mOutput).write(mBuffer, 0, mLength);
        }
        mOutput.flush();
        ((OutputStream)mOutput).close();
        mInput.close();
    }

    public void openDataBase() throws SQLException {
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        mDataBase = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)1);
    }

    public synchronized void close() {
        if (mDataBase != null) {
            mDataBase.close();
        }
        super.close();
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_CONTACTS_TABLE);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS palmistry");
        this.onCreate(db);
    }

    public List<Content> getAllContacts() {
        ArrayList<Content> contactList = new ArrayList<Content>();
        File dbFile = this.mContext.getDatabasePath(DATABASE_NAME);
        mDataBase = SQLiteDatabase.openDatabase((String)dbFile.getPath(), null, (int)0);
        return contactList;
    }
}

