package compatibility.findyourfate.com;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

public class home extends Activity {
	@SuppressLint("NewApi")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.home);
		TextView textview=(TextView) findViewById(R.id.textv);
		textview.setPaintFlags(textview.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
		textview.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View view)
			{
				Uri adress= Uri.parse("http://www.findyourfate.com");
				Intent browser= new Intent(Intent.ACTION_VIEW, adress);
				startActivity(browser);
			}
		});

		Runnable swapImage = new Runnable() {
			@Override
			public void run() {
				Intent intent = new Intent(home.this,MainActivity.class);
				startActivity(intent);
			}
		};
		ImageView  img = (ImageView) findViewById(R.id.imageView1);
		img.postDelayed(swapImage, 2000);

		img.setOnTouchListener(new View.OnTouchListener() {

			@Override
			public boolean onTouch(View arg0, MotionEvent arg1) {
				// TODO Auto-generated method stub
				Intent intent = new Intent(home.this,MainActivity.class);
				startActivity(intent);
				return true;
			}
		});
	}
	@Override
	public void onBackPressed() {
		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage("Are you sure want to exit from Horoscope Compatibility apps?")
				.setCancelable(false)
				.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						Intent intent = new Intent(Intent.ACTION_MAIN);
						intent.addCategory(Intent.CATEGORY_HOME);
						intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
						startActivity(intent);
					}
				})
				.setNegativeButton("No", new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog, int id) {
						dialog.cancel();
					}
				});
		AlertDialog alert = builder.create();
		alert.show();

	}


	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.mainhome, menu);
		return super.onCreateOptionsMenu(menu);
	}

	@SuppressLint("NewApi")
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {

		if (item.getItemId() ==R.id.start) {
			Intent inte = new Intent(this, MainActivity.class);
			inte.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(inte);
		}
		else
		{
		}
		return true;

	}
}
