package compatibility.findyourfate.com;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

public class compat2017 extends Fragment {
	private View rootView;
	private String sign = null;

	public compat2017() {
		// Required empty constructor
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
		rootView = inflater.inflate(R.layout.compat2017, container, false);

		// Retrieve zodiac sign if available
		if (getArguments() != null) {
			sign = getArguments().getString("signs", null);
		}

		// Initialize ImageViews
		initializeViews();

		return rootView;
	}
	private void initializeViews() {
		int[] imageViewIds = {
				R.id.aries, R.id.taurus, R.id.gemini, R.id.cancer,
				R.id.leo, R.id.virgo, R.id.libra, R.id.scorp,
				R.id.sagg, R.id.capri, R.id.aquar, R.id.pisces
		};

		String[] zodiacNames = {
				"Aries", "Taurus", "Gemini", "Cancer",
				"Leo", "Virgo", "Libra", "Scorpio",
				"Sagittarius", "Capricorn", "Aquarius", "Pisces"
		};

		for (int i = 0; i < imageViewIds.length; i++) {
			ImageView imageView = rootView.findViewById(imageViewIds[i]);
			final String selectedSign = zodiacNames[i];

			imageView.setOnClickListener(v -> openCompatibilityFragment(selectedSign));
		}
	}

	private void openCompatibilityFragment(String selectedSign) {
		Fragment newFragment = new compat2017();  // A new fragment for result
		Bundle args = new Bundle();
		args.putString("signs", selectedSign);
		newFragment.setArguments(args);

		FragmentTransaction transaction = requireActivity()
				.getSupportFragmentManager()
				.beginTransaction();
		transaction.setCustomAnimations(R.anim.bottom_in, R.anim.top_out);
		transaction.replace(R.id.layoutcompat, newFragment);
		transaction.commitAllowingStateLoss();
	}
}


