package compatibility.findyourfate.com;

import java.util.ArrayList;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.app.FragmentManager;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import androidx.drawerlayout.widget.DrawerLayout;
import androidx.appcompat.app.ActionBarDrawerToggle;
import android.util.Log;
import android.view.Gravity;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import compatibility.findyourfate.com.R;
import compatibility.findyourfate.com.model.NavDrawerListAdapter;
import compatibility.findyourfate.com.adapt.NavDrawerItem;

@TargetApi(Build.VERSION_CODES.ICE_CREAM_SANDWICH)

public class MainActivity extends Activity {

	DrawerLayout mDrawerLayout;
	ListView mDrawerList;
	protected ActionBarDrawerToggle mDrawerToggle;

	protected CharSequence mDrawerTitle;
	protected CharSequence mTitle;
	protected String[] navMenuTitles;
	protected TypedArray navMenuIcons;
	protected ArrayList<NavDrawerItem> navDrawerItems;
	protected NavDrawerListAdapter adapter;

	ArrayList<String> items=new ArrayList<String>();

	static final Uri APP_URI = Uri.parse("android-app://compatibility.findyourfate.com/http/findyourfate.com/compatibility/compatibility-home.asp");
	static final Uri WEB_URL = Uri.parse("http://www.findyourfate.com/compatibility/compat.html");
	static final Uri EMPTY_WEB_URL = Uri.parse("http://www.findyourfate.com/compatibility/compatibility-home.asp");
	//private GoogleApiClient mClient;

	Fragment fragment = null;
	@SuppressLint("ResourceType")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);

		// mClient = new GoogleApiClient.Builder(this).addApi(AppIndex.APP_INDEX_API).build();
		mTitle = mDrawerTitle = getTitle();
		navMenuTitles = getResources().getStringArray(R.array.drawer_items);
		navMenuIcons = getResources().obtainTypedArray(R.array.drawer_icons);
		mDrawerLayout = (DrawerLayout) findViewById(R.id.drawer_layout);
		mDrawerList = (ListView) findViewById(R.id.list_slidermenu);
		navDrawerItems = new ArrayList<NavDrawerItem>();
		navDrawerItems.add(new NavDrawerItem(navMenuTitles[0], navMenuIcons.getResourceId(0, -1),true,">"));
		navDrawerItems.add(new NavDrawerItem(navMenuTitles[1], navMenuIcons.getResourceId(1, -1),true,">"));
		navDrawerItems.add(new NavDrawerItem(navMenuTitles[2], navMenuIcons.getResourceId(2, -1),true,">"));
		navDrawerItems.add(new NavDrawerItem(navMenuTitles[3], navMenuIcons.getResourceId(3, -1),true,">"));
		navDrawerItems.add(new NavDrawerItem(navMenuTitles[4], navMenuIcons.getResourceId(4, -1)));


		navMenuIcons.recycle();


		mDrawerList.setOnItemClickListener(new SlideMenuClickListener());

		// setting the nav drawer list adapter
		adapter = new NavDrawerListAdapter(getApplicationContext(),
				navDrawerItems);
		mDrawerList.setAdapter(adapter);

		// enabling action bar app icon and behaving it as toggle button
		//getActionBar().setDisplayHomeAsUpEnabled(true);
		//getActionBar().setHomeButtonEnabled(true);

		mDrawerToggle = new MyActionBarDrawerToggle();
		mDrawerLayout.setDrawerListener(mDrawerToggle);
		if (savedInstanceState == null) {
			//displayView(0);
		}
		mDrawerLayout.openDrawer(mDrawerList);

	}
	/**
	 * Slide menu item click listener
	 * */
	protected class SlideMenuClickListener implements
			ListView.OnItemClickListener {
		@Override
		public void onItemClick(AdapterView<?> parent, View view, int position,
								long id) {
			// display view for selected nav drawer item
			displayView(position);
		}
	}
	@Override
	public void onStart() {
		super.onStart();


		//mClient.connect();
		final String title = "Horoscope Compatibility";

		// AppIndex.AppIndexApi.view(mClient, this, APP_URI, title, WEB_URL, null);
	}
	@Override
	public void onStop() {
		super.onStop();

		// AppIndex.AppIndexApi.viewEnd(mClient, this, APP_URI);
		//mClient.disconnect();
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		MenuInflater inflater = getMenuInflater();
		//MenuInflater inflater = getMenuInflater();
		inflater.inflate(R.menu.main, menu);
		return true;
	}
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		// toggle nav drawer on selecting action bar app icon/title
		if (mDrawerToggle.onOptionsItemSelected(item)) {
			return true;
		}
		if (item.getItemId() == android.R.id.home)
		{
			Intent in=new Intent(MainActivity.this,home.class);
			in.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(in);
		}
		else if (item.getItemId() == R.id.share)
		{
			Intent emailIntent = new Intent(android.content.Intent.ACTION_SEND);
			emailIntent.setType("text/plain");
			emailIntent.putExtra(android.content.Intent.EXTRA_SUBJECT, "Horoscope Compatibility - findyourfate.com");
			emailIntent.putExtra(android.content.Intent.EXTRA_TEXT, "Hi, I would like to suggest, this Horoscope Compatibility App to you. Click this Link to Download \"http://goo.gl/kuNUze\" \n\n Regards");
			startActivity(emailIntent);
		}
		else if (item.getItemId() == R.id.exit)
		{
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("Are you sure  want to exit?")
					.setCancelable(false)
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							Intent intent = new Intent(Intent.ACTION_MAIN);
							intent.addCategory(Intent.CATEGORY_HOME);
							intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
							startActivity(intent);
						}
					})
					.setNegativeButton("No", new DialogInterface.OnClickListener() {
						public void onClick(DialogInterface dialog, int id) {
							dialog.cancel();
						}
					});
			AlertDialog alert = builder.create();
			alert.show();
		}
		else
		{
		}
		return true;
	}
	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		// if nav drawer is opened, hide the action items
		boolean drawerOpen = mDrawerLayout.isDrawerOpen(mDrawerList);
		//	menu.findItem(R.id.action_settings).setVisible(!drawerOpen);
		return super.onPrepareOptionsMenu(menu);
	}
	protected void displayView(int position) {
		// update the main content by replacing fragments

		switch (position) {
			case 0:
				//	displayInterstitial();
				fragment = new compat();
				break;
			case 1:

				fragment = new compatreading();
				break;

			case 2:
				fragment=new lovetest();
				break;

			case 3:
				//fragment=new compat2017();
				break;

			case 4:
				AlertDialog.Builder alertDialogBuilder = new AlertDialog.Builder(MainActivity.this);
				alertDialogBuilder.setTitle("Horoscopes");
				alertDialogBuilder.setMessage("Get your daily, weekly, monthly and yearly horoscopes by www.findyourfate.com for free.");
				alertDialogBuilder.setPositiveButton("Open",new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog,int id) {
						final String appPackageName = "horoscope.findyourfate.com"; // getPackageName() from Context or Activity object
						try {
							startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("market://details?id=" + appPackageName)));
						} catch (android.content.ActivityNotFoundException anfe) {
							startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse("http://play.google.com/store/apps/details?id=" + appPackageName)));
						}
					}
				});
				alertDialogBuilder.setNeutralButton("Already/Never",new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog,int id) {
						//  MainActivity.this.finish();
						dialog.cancel();
					}
				});
				// set negative button: No message
				alertDialogBuilder.setNegativeButton("Later",new DialogInterface.OnClickListener() {
					public void onClick(DialogInterface dialog,int id) {
						// cancel the alert box and put a Toast to the user
						dialog.cancel();
					}
				});
				AlertDialog alertDialog = alertDialogBuilder.create();
				// show alert
				alertDialog.show();
				break;
			default:
				break;
		}
		if (fragment != null) {
			FragmentManager fragmentManager = getFragmentManager();
			fragmentManager.beginTransaction().replace(R.id.frame_container, fragment).commit();
			// update selected item and title, then close the drawer
			mDrawerList.setItemChecked(position, true);
			mDrawerList.setSelection(position);
			setTitle(navMenuTitles[position]);
			mDrawerLayout.closeDrawer(mDrawerList);
		} else {
			// error in creating fragment
			Log.e("MainActivity", "Error in creating fragment");
		}
	}
	@Override
	public void setTitle(CharSequence title) {
		mTitle = title;
		getActionBar().setTitle("Compatibility Signs");
	}
	@Override
	protected void onPostCreate(Bundle savedInstanceState) {
		super.onPostCreate(savedInstanceState);
		// Sync the toggle state after onRestoreInstanceState has occurred.
		mDrawerToggle.syncState();
	}
	@Override
	public void onConfigurationChanged(Configuration newConfig) {
		super.onConfigurationChanged(newConfig);
		// Pass any configuration change to the drawer toggls
		mDrawerToggle.onConfigurationChanged(newConfig);
	}



	@Override
	public void onBackPressed() {


		if(mDrawerLayout.isDrawerOpen(Gravity.LEFT)){
			// mDrawerLayout.closeDrawer(Gravity.LEFT);

			new AlertDialog.Builder(this)
					.setTitle("Close App?")
					.setMessage("Do you really want to close this  app?")
					.setPositiveButton("YES",
							new DialogInterface.OnClickListener() {

								@Override
								public void onClick(DialogInterface dialog,
													int which) {
									MainActivity.this.finish();
									Intent intent = new Intent(Intent.ACTION_MAIN);
									intent.addCategory(Intent.CATEGORY_HOME);
									intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
									startActivity(intent);
								}
							})
					.setNegativeButton("NO",
							new DialogInterface.OnClickListener() {

								@Override
								public void onClick(DialogInterface dialog,
													int which) {
								}
							}).show();
			// load your first Fragment here
		}

		else
		{
			mDrawerLayout.openDrawer(mDrawerList);
		}
	}

	private class MyActionBarDrawerToggle extends ActionBarDrawerToggle {
		@SuppressLint("ResourceType")
		public MyActionBarDrawerToggle() {
			super(MainActivity.this, MainActivity.this.mDrawerLayout, R.drawable.draw, R.string.app_name);
		}

		public void onDrawerClosed(View view) {
			getActionBar().setTitle(mTitle);
			// calling onPrepareOptionsMenu() to show action bar icons
			invalidateOptionsMenu();
		}

		public void onDrawerOpened(View drawerView) {

			getActionBar().setTitle(mDrawerTitle);
			invalidateOptionsMenu();
		}
	}
}


