/*
 * Decompiled with CFR 0.152.
 */
package compatibility.findyourfate.com;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import compatibility.findyourfate.com.R;

public class compat2017
extends Fragment {
    private View rootView;
    private String sign = null;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.rootView = inflater.inflate(R.layout.compat2017, container, false);
        if (this.getArguments() != null) {
            this.sign = this.getArguments().getString("signs", null);
        }
        this.initializeViews();
        return this.rootView;
    }

    private void initializeViews() {
        int[] imageViewIds = new int[]{R.id.aries, R.id.taurus, R.id.gemini, R.id.cancer, R.id.leo, R.id.virgo, R.id.libra, R.id.scorp, R.id.sagg, R.id.capri, R.id.aquar, R.id.pisces};
        String[] zodiacNames = new String[]{"Aries", "Taurus", "Gemini", "Cancer", "Leo", "Virgo", "Libra", "Scorpio", "Sagittarius", "Capricorn", "Aquarius", "Pisces"};
        for (int i = 0; i < imageViewIds.length; ++i) {
            ImageView imageView = (ImageView)this.rootView.findViewById(imageViewIds[i]);
            String selectedSign = zodiacNames[i];
            imageView.setOnClickListener(v -> this.openCompatibilityFragment(selectedSign));
        }
    }

    private void openCompatibilityFragment(String selectedSign) {
        compat2017 newFragment = new compat2017();
        Bundle args = new Bundle();
        args.putString("signs", selectedSign);
        newFragment.setArguments(args);
        FragmentTransaction transaction = this.requireActivity().getSupportFragmentManager().beginTransaction();
        transaction.setCustomAnimations(R.anim.bottom_in, R.anim.top_out);
        transaction.replace(R.id.layoutcompat, (Fragment)newFragment);
        transaction.commitAllowingStateLoss();
    }
}

