/*
 * Decompiled with CFR 0.152.
 */
package capricorn.findyourfate.com;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;

public class WheelMenu
extends AppCompatImageView {
    private Bitmap imageOriginal;
    private Bitmap imageScaled;
    private Matrix matrix;
    private int wheelHeight;
    private int wheelWidth;
    private int top;
    private double totalRotation;
    private int divCount;
    private int divAngle;
    private int selectedPosition;
    private boolean snapToCenterFlag = true;
    private Context context;
    private WheelChangeListener wheelChangeListener;

    public WheelMenu(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    private void init(Context context) {
        this.context = context;
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.selectedPosition = 0;
        if (this.matrix == null) {
            this.matrix = new Matrix();
        } else {
            this.matrix.reset();
        }
        this.setOnTouchListener(new WheelTouchListener());
    }

    public void setWheelChangeListener(WheelChangeListener wheelChangeListener) {
        this.wheelChangeListener = wheelChangeListener;
    }

    public int getSelectedPosition() {
        return this.selectedPosition;
    }

    public void setDivCount(int divCount) {
        this.divCount = divCount;
        this.divAngle = 360 / divCount;
        this.totalRotation = -1 * (this.divAngle / 2);
    }

    public void setSnapToCenterFlag(boolean snapToCenterFlag) {
        this.snapToCenterFlag = snapToCenterFlag;
    }

    public void setAlternateTopDiv(int newTopDiv) {
        if (newTopDiv < 0 || newTopDiv >= this.divCount) {
            return;
        }
        this.selectedPosition = this.top = newTopDiv;
    }

    public void setWheelImage(int drawableId) {
        this.imageOriginal = BitmapFactory.decodeResource((Resources)this.context.getResources(), (int)drawableId);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.wheelHeight == 0 || this.wheelWidth == 0) {
            this.wheelHeight = h;
            this.wheelWidth = w;
            Matrix resize = new Matrix();
            resize.postScale((float)Math.min(this.wheelWidth, this.wheelHeight) / (float)this.imageOriginal.getWidth(), (float)Math.min(this.wheelWidth, this.wheelHeight) / (float)this.imageOriginal.getHeight());
            this.imageScaled = Bitmap.createBitmap((Bitmap)this.imageOriginal, (int)0, (int)0, (int)this.imageOriginal.getWidth(), (int)this.imageOriginal.getHeight(), (Matrix)resize, (boolean)false);
            float translateX = this.wheelWidth / 2 - this.imageScaled.getWidth() / 2;
            float translateY = this.wheelHeight / 2 - this.imageScaled.getHeight() / 2;
            this.matrix.postTranslate(translateX, translateY);
            this.setImageBitmap(this.imageScaled);
            this.setImageMatrix(this.matrix);
        }
    }

    private double getAngle(double x, double y) {
        y = (double)this.wheelHeight - y - (double)this.wheelHeight / 2.0;
        switch (WheelMenu.getQuadrant(x -= (double)this.wheelWidth / 2.0, y)) {
            case 1: {
                return Math.asin(y / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 2: {
                return 180.0 - Math.asin(y / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 3: {
                return 180.0 + -1.0 * Math.asin(y / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
            case 4: {
                return 360.0 + Math.asin(y / Math.hypot(x, y)) * 180.0 / Math.PI;
            }
        }
        return 0.0;
    }

    private static int getQuadrant(double x, double y) {
        if (x >= 0.0) {
            return y >= 0.0 ? 1 : 4;
        }
        return y >= 0.0 ? 2 : 3;
    }

    private void rotateWheel(float degrees) {
        this.matrix.postRotate(degrees, (float)(this.wheelWidth / 2), (float)(this.wheelHeight / 2));
        this.setImageMatrix(this.matrix);
        this.totalRotation += (double)degrees;
    }

    public static interface WheelChangeListener {
        public void onSelectionChange(int var1);
    }

    private class WheelTouchListener
    implements View.OnTouchListener {
        private double startAngle;

        private WheelTouchListener() {
        }

        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case 0: {
                    this.startAngle = WheelMenu.this.getAngle(event.getX(), event.getY());
                    break;
                }
                case 2: {
                    double currentAngle = WheelMenu.this.getAngle(event.getX(), event.getY());
                    WheelMenu.this.rotateWheel((float)(this.startAngle - currentAngle));
                    this.startAngle = currentAngle;
                    break;
                }
                case 1: {
                    WheelMenu.this.totalRotation = WheelMenu.this.totalRotation % 360.0;
                    if (WheelMenu.this.totalRotation < 0.0) {
                        WheelMenu.this.totalRotation = 360.0 + WheelMenu.this.totalRotation;
                    }
                    int no_of_divs_crossed = (int)(WheelMenu.this.totalRotation / (double)WheelMenu.this.divAngle);
                    WheelMenu.this.top = (WheelMenu.this.divCount + WheelMenu.this.top - no_of_divs_crossed) % WheelMenu.this.divCount;
                    WheelMenu.this.totalRotation = WheelMenu.this.totalRotation % (double)WheelMenu.this.divAngle;
                    if (WheelMenu.this.snapToCenterFlag) {
                        double leftover = (double)(WheelMenu.this.divAngle / 2) - WheelMenu.this.totalRotation;
                        WheelMenu.this.rotateWheel((float)leftover);
                        WheelMenu.this.totalRotation = WheelMenu.this.divAngle / 2;
                    }
                    if (WheelMenu.this.top == 0) {
                        WheelMenu.this.selectedPosition = WheelMenu.this.divCount - 1;
                    } else {
                        WheelMenu.this.selectedPosition = WheelMenu.this.top - 1;
                    }
                    if (WheelMenu.this.wheelChangeListener == null) break;
                    WheelMenu.this.wheelChangeListener.onSelectionChange(WheelMenu.this.selectedPosition);
                }
            }
            return true;
        }
    }
}

