/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.tagmanager.Log;
import com.google.tagmanager.TypedNumber;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Types {
    private static final Object DEFAULT_OBJECT = null;
    private static Long DEFAULT_INT64 = new Long(0L);
    private static Double DEFAULT_DOUBLE = new Double(0.0);
    private static TypedNumber DEFAULT_NUMBER = TypedNumber.numberWithInt64(0L);
    private static String DEFAULT_STRING = new String("");
    private static Boolean DEFAULT_BOOLEAN = new Boolean(false);
    private static List<Object> DEFAULT_LIST = new ArrayList<Object>(0);
    private static Map<Object, Object> DEFAULT_MAP = new HashMap<Object, Object>();
    private static TypeSystem.Value DEFAULT_VALUE = Types.objectToValue(DEFAULT_STRING);

    private Types() {
    }

    public static Object getDefaultObject() {
        return DEFAULT_OBJECT;
    }

    public static Long getDefaultInt64() {
        return DEFAULT_INT64;
    }

    public static Double getDefaultDouble() {
        return DEFAULT_DOUBLE;
    }

    public static Boolean getDefaultBoolean() {
        return DEFAULT_BOOLEAN;
    }

    public static TypedNumber getDefaultNumber() {
        return DEFAULT_NUMBER;
    }

    public static String getDefaultString() {
        return DEFAULT_STRING;
    }

    public static List<Object> getDefaultList() {
        return DEFAULT_LIST;
    }

    public static Map<Object, Object> getDefaultMap() {
        return DEFAULT_MAP;
    }

    public static TypeSystem.Value getDefaultValue() {
        return DEFAULT_VALUE;
    }

    public static String objectToString(Object o) {
        return o == null ? DEFAULT_STRING : o.toString();
    }

    public static TypedNumber objectToNumber(Object o) {
        if (o instanceof TypedNumber) {
            return (TypedNumber)o;
        }
        if (Types.isInt64ableNumber(o)) {
            return TypedNumber.numberWithInt64(Types.getInt64(o));
        }
        if (Types.isDoubleableNumber(o)) {
            return TypedNumber.numberWithDouble(Types.getDouble(o));
        }
        return Types.parseNumber(Types.objectToString(o));
    }

    public static Long objectToInt64(Object o) {
        return Types.isInt64ableNumber(o) ? Long.valueOf(Types.getInt64(o)) : Types.parseInt64(Types.objectToString(o));
    }

    public static Double objectToDouble(Object o) {
        return Types.isDoubleableNumber(o) ? Double.valueOf(Types.getDouble(o)) : Types.parseDouble(Types.objectToString(o));
    }

    public static Boolean objectToBoolean(Object o) {
        return o instanceof Boolean ? (Boolean)o : Types.parseBoolean(Types.objectToString(o));
    }

    public static String valueToString(TypeSystem.Value v) {
        return Types.objectToString(Types.valueToObject(v));
    }

    public static TypedNumber valueToNumber(TypeSystem.Value v) {
        return Types.objectToNumber(Types.valueToObject(v));
    }

    public static Long valueToInt64(TypeSystem.Value v) {
        return Types.objectToInt64(Types.valueToObject(v));
    }

    public static Double valueToDouble(TypeSystem.Value v) {
        return Types.objectToDouble(Types.valueToObject(v));
    }

    public static Boolean valueToBoolean(TypeSystem.Value v) {
        return Types.objectToBoolean(Types.valueToObject(v));
    }

    public static TypeSystem.Value objectToValue(Object o) {
        TypeSystem.Value.Builder builder = TypeSystem.Value.newBuilder();
        boolean containsRef = false;
        if (o instanceof TypeSystem.Value) {
            return (TypeSystem.Value)o;
        }
        if (o instanceof String) {
            builder.setType(TypeSystem.Value.Type.STRING).setString((String)o);
        } else if (o instanceof List) {
            builder.setType(TypeSystem.Value.Type.LIST);
            for (Object listObject : (List)o) {
                TypeSystem.Value listValue = Types.objectToValue(listObject);
                if (listValue == DEFAULT_VALUE) {
                    return DEFAULT_VALUE;
                }
                containsRef = containsRef || listValue.getContainsReferences();
                builder.addListItem(listValue);
            }
        } else if (o instanceof Map) {
            builder.setType(TypeSystem.Value.Type.MAP);
            Set entries = ((Map)o).entrySet();
            for (Map.Entry entry : entries) {
                TypeSystem.Value key = Types.objectToValue(entry.getKey());
                TypeSystem.Value value = Types.objectToValue(entry.getValue());
                if (key == DEFAULT_VALUE || value == DEFAULT_VALUE) {
                    return DEFAULT_VALUE;
                }
                containsRef = containsRef || key.getContainsReferences() || value.getContainsReferences();
                builder.addMapKey(key);
                builder.addMapValue(value);
            }
        } else if (Types.isDoubleableNumber(o)) {
            builder.setType(TypeSystem.Value.Type.STRING).setString(o.toString());
        } else if (Types.isInt64ableNumber(o)) {
            builder.setType(TypeSystem.Value.Type.INTEGER).setInteger(Types.getInt64(o));
        } else if (o instanceof Boolean) {
            builder.setType(TypeSystem.Value.Type.BOOLEAN).setBoolean((Boolean)o);
        } else {
            Log.e("Converting to Value from unknown object type: " + (o == null ? "null" : o.getClass().toString()));
            return DEFAULT_VALUE;
        }
        if (containsRef) {
            builder.setContainsReferences(true);
        }
        return builder.build();
    }

    public static TypeSystem.Value functionIdToValue(String id) {
        return TypeSystem.Value.newBuilder().setType(TypeSystem.Value.Type.FUNCTION_ID).setFunctionId(id).build();
    }

    public static TypeSystem.Value macroReferenceToValue(String macroName, TypeSystem.Value.Escaping ... escapings) {
        TypeSystem.Value.Builder builder = TypeSystem.Value.newBuilder().setType(TypeSystem.Value.Type.MACRO_REFERENCE).setMacroReference(macroName).setContainsReferences(true);
        for (TypeSystem.Value.Escaping escaping : escapings) {
            builder.addEscaping(escaping);
        }
        return builder.build();
    }

    public static TypeSystem.Value templateToValue(TypeSystem.Value ... tokens) {
        TypeSystem.Value.Builder builder = TypeSystem.Value.newBuilder().setType(TypeSystem.Value.Type.TEMPLATE);
        boolean containsRef = false;
        for (TypeSystem.Value token : tokens) {
            builder.addTemplateToken(token);
            containsRef = containsRef || token.getContainsReferences();
        }
        if (containsRef) {
            builder.setContainsReferences(true);
        }
        return builder.build();
    }

    private static boolean isDoubleableNumber(Object o) {
        return o instanceof Double || o instanceof Float || o instanceof TypedNumber && ((TypedNumber)o).isDouble();
    }

    private static double getDouble(Object o) {
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        Log.e("getDouble received non-Number");
        return 0.0;
    }

    private static boolean isInt64ableNumber(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof TypedNumber && ((TypedNumber)o).isInt64();
    }

    private static long getInt64(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        Log.e("getInt64 received non-Number");
        return 0L;
    }

    private static TypedNumber parseNumber(String s) {
        try {
            return TypedNumber.numberWithString(s);
        }
        catch (NumberFormatException longError) {
            Log.e("Failed to convert '" + s + "' to a number.");
            return DEFAULT_NUMBER;
        }
    }

    private static Long parseInt64(String s) {
        TypedNumber result = Types.parseNumber(s);
        return result == DEFAULT_NUMBER ? DEFAULT_INT64 : Long.valueOf(result.longValue());
    }

    private static Double parseDouble(String s) {
        TypedNumber result = Types.parseNumber(s);
        return result == DEFAULT_NUMBER ? DEFAULT_DOUBLE : Double.valueOf(result.doubleValue());
    }

    private static Boolean parseBoolean(String s) {
        if ("true".equalsIgnoreCase(s)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(s)) {
            return Boolean.FALSE;
        }
        return DEFAULT_BOOLEAN;
    }

    public static Object valueToObject(TypeSystem.Value v) {
        if (v == null) {
            return DEFAULT_OBJECT;
        }
        switch (v.getType()) {
            case STRING: {
                return v.getString();
            }
            case LIST: {
                ArrayList<Object> result = new ArrayList<Object>(v.getListItemCount());
                for (TypeSystem.Value val : v.getListItemList()) {
                    Object o = Types.valueToObject(val);
                    if (o == DEFAULT_OBJECT) {
                        return DEFAULT_OBJECT;
                    }
                    result.add(o);
                }
                return result;
            }
            case MAP: {
                if (v.getMapKeyCount() != v.getMapValueCount()) {
                    Log.e("Converting an invalid value to object: " + v.toString());
                    return DEFAULT_OBJECT;
                }
                HashMap<Object, Object> result = new HashMap<Object, Object>(v.getMapValueCount());
                for (int i = 0; i < v.getMapKeyCount(); ++i) {
                    Object key = Types.valueToObject(v.getMapKey(i));
                    Object value = Types.valueToObject(v.getMapValue(i));
                    if (key == DEFAULT_OBJECT || value == DEFAULT_OBJECT) {
                        return DEFAULT_OBJECT;
                    }
                    result.put(key, value);
                }
                return result;
            }
            case MACRO_REFERENCE: {
                Log.e("Trying to convert a macro reference to object");
                return DEFAULT_OBJECT;
            }
            case FUNCTION_ID: {
                Log.e("Trying to convert a function id to object");
                return DEFAULT_OBJECT;
            }
            case INTEGER: {
                return v.getInteger();
            }
            case TEMPLATE: {
                StringBuffer result = new StringBuffer();
                for (TypeSystem.Value val : v.getTemplateTokenList()) {
                    String s = Types.valueToString(val);
                    if (s == DEFAULT_STRING) {
                        return DEFAULT_OBJECT;
                    }
                    result.append(s);
                }
                return result.toString();
            }
            case BOOLEAN: {
                return v.getBoolean();
            }
        }
        Log.e("Failed to convert a value of type: " + v.getType());
        return DEFAULT_OBJECT;
    }
}

