/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import android.content.Context;
import com.google.analytics.containertag.proto.Serving;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.Container;
import com.google.tagmanager.CtfeHost;
import com.google.tagmanager.LoadCallback;
import com.google.tagmanager.Log;
import com.google.tagmanager.ResourceLoader;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class ResourceLoaderSchedulerImpl
implements Container.ResourceLoaderScheduler {
    private static final boolean MAY_INTERRUPT_IF_RUNNING = true;
    private final String mContainerId;
    private final Context mContext;
    private final ScheduledExecutorService mExecutor;
    private final ResourceLoaderFactory mResourceLoaderFactory;
    private ScheduledFuture<?> mFuture;
    private boolean mClosed;
    private CtfeHost mCtfeHost;
    private String mCtfeUrlPathAndQuery;
    private LoadCallback<Serving.Resource> mCallback;

    public ResourceLoaderSchedulerImpl(Context context, String containerId, CtfeHost ctfeHost) {
        this(context, containerId, ctfeHost, null, null);
    }

    @VisibleForTesting
    ResourceLoaderSchedulerImpl(Context context, String containerId, CtfeHost ctfeHost, ScheduledExecutorServiceFactory executorServiceFactory, ResourceLoaderFactory resourceLoaderFactory) {
        this.mCtfeHost = ctfeHost;
        this.mContext = context;
        this.mContainerId = containerId;
        if (executorServiceFactory == null) {
            executorServiceFactory = new ScheduledExecutorServiceFactory(){

                @Override
                public ScheduledExecutorService createExecutorService() {
                    return Executors.newSingleThreadScheduledExecutor();
                }
            };
        }
        this.mExecutor = executorServiceFactory.createExecutorService();
        this.mResourceLoaderFactory = resourceLoaderFactory == null ? new ResourceLoaderFactory(){

            @Override
            public ResourceLoader createResourceLoader(CtfeHost ctfeHost) {
                return new ResourceLoader(ResourceLoaderSchedulerImpl.this.mContext, ResourceLoaderSchedulerImpl.this.mContainerId, ctfeHost);
            }
        } : resourceLoaderFactory;
    }

    @Override
    public synchronized void close() {
        this.ensureNotClosed();
        if (this.mFuture != null) {
            this.mFuture.cancel(false);
        }
        this.mExecutor.shutdown();
        this.mClosed = true;
    }

    @Override
    public synchronized void setLoadCallback(LoadCallback<Serving.Resource> callback) {
        this.ensureNotClosed();
        this.mCallback = callback;
    }

    @Override
    public synchronized void loadAfterDelay(long delayInMillis, String previousVersion) {
        Log.v("loadAfterDelay: containerId=" + this.mContainerId + " delay=" + delayInMillis);
        this.ensureNotClosed();
        if (this.mCallback == null) {
            throw new IllegalStateException("callback must be set before loadAfterDelay() is called.");
        }
        if (this.mFuture != null) {
            this.mFuture.cancel(true);
        }
        this.mFuture = this.mExecutor.schedule(this.createResourceLoader(previousVersion), delayInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void setCtfeURLPathAndQuery(String urlPathAndQuery) {
        this.ensureNotClosed();
        this.mCtfeUrlPathAndQuery = urlPathAndQuery;
    }

    private synchronized void ensureNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("called method after closed");
        }
    }

    private ResourceLoader createResourceLoader(String previousVersion) {
        ResourceLoader resourceLoader = this.mResourceLoaderFactory.createResourceLoader(this.mCtfeHost);
        resourceLoader.setLoadCallback(this.mCallback);
        resourceLoader.setCtfeURLPathAndQuery(this.mCtfeUrlPathAndQuery);
        resourceLoader.setPreviousVersion(previousVersion);
        return resourceLoader;
    }

    static interface ResourceLoaderFactory {
        public ResourceLoader createResourceLoader(CtfeHost var1);
    }

    static interface ScheduledExecutorServiceFactory {
        public ScheduledExecutorService createExecutorService();
    }
}

