/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.common.Key;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.ConstantMacro;
import com.google.tagmanager.ResourceUtil;
import com.google.tagmanager.Types;
import java.util.HashMap;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JsonUtils {
    private JsonUtils() {
    }

    public static ResourceUtil.ExpandedResource expandedResourceFromJsonString(String jsonString) throws JSONException {
        TypeSystem.Value value = JsonUtils.jsonObjectToValue(new JSONObject(jsonString));
        ResourceUtil.ExpandedResourceBuilder builder = ResourceUtil.ExpandedResource.newBuilder();
        for (int i = 0; i < value.getMapKeyCount(); ++i) {
            builder.addMacro(ResourceUtil.ExpandedFunctionCall.newBuilder().addProperty(Key.INSTANCE_NAME.toString(), value.getMapKey(i)).addProperty(Key.FUNCTION.toString(), Types.functionIdToValue(ConstantMacro.getFunctionId())).addProperty(ConstantMacro.getValueKey(), value.getMapValue(i)).build());
        }
        return builder.build();
    }

    private static TypeSystem.Value jsonObjectToValue(Object o) throws JSONException {
        return Types.objectToValue(JsonUtils.jsonObjectToObject(o));
    }

    @VisibleForTesting
    static Object jsonObjectToObject(Object o) throws JSONException {
        if (o instanceof JSONArray) {
            throw new RuntimeException("JSONArrays are not supported");
        }
        if (JSONObject.NULL.equals(o)) {
            throw new RuntimeException("JSON nulls are not supported");
        }
        if (o instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)o;
            HashMap<String, Object> map = new HashMap<String, Object>();
            Iterator keys = jsonObject.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                map.put(key, JsonUtils.jsonObjectToObject(jsonObject.get(key)));
            }
            return map;
        }
        return o;
    }
}

