/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.analytics.containertag.proto.MutableDebug;
import com.google.analytics.midtier.proto.containertag.TypeSystem;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.tagmanager.DebugResolvedFunctionCallBuilder;
import com.google.tagmanager.DebugValueBuilder;
import com.google.tagmanager.ResolvedFunctionCallBuilder;
import com.google.tagmanager.ResolvedFunctionCallTranslatorList;
import com.google.tagmanager.ResolvedRuleBuilder;
import com.google.tagmanager.ResourceUtil;
import java.util.List;
import java.util.Map;

class DebugResolvedRuleBuilder
implements ResolvedRuleBuilder {
    MutableDebug.ResolvedRule resolvedRule;
    ResolvedFunctionCallTranslatorList addMacrosHolder;
    ResolvedFunctionCallTranslatorList removeMacrosHolder;
    ResolvedFunctionCallTranslatorList addTagsHolder;
    ResolvedFunctionCallTranslatorList removeTagsHolder;

    public DebugResolvedRuleBuilder(MutableDebug.ResolvedRule rule) {
        this.resolvedRule = rule;
        this.addMacrosHolder = new DebugResolvedFunctionCallListTranslator(this.resolvedRule.getMutableAddMacrosList());
        this.removeMacrosHolder = new DebugResolvedFunctionCallListTranslator(this.resolvedRule.getMutableRemoveMacrosList());
        this.addTagsHolder = new DebugResolvedFunctionCallListTranslator(this.resolvedRule.getMutableAddTagsList());
        this.removeTagsHolder = new DebugResolvedFunctionCallListTranslator(this.resolvedRule.getMutableRemoveTagsList());
    }

    @Override
    public ResolvedFunctionCallBuilder createNegativePredicate() {
        return new DebugResolvedFunctionCallBuilder(this.resolvedRule.addNegativePredicates());
    }

    @Override
    public ResolvedFunctionCallBuilder createPositivePredicate() {
        return new DebugResolvedFunctionCallBuilder(this.resolvedRule.addPositivePredicates());
    }

    @Override
    public ResolvedFunctionCallTranslatorList getAddedMacroFunctions() {
        return this.addMacrosHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getRemovedMacroFunctions() {
        return this.removeMacrosHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getAddedTagFunctions() {
        return this.addTagsHolder;
    }

    @Override
    public ResolvedFunctionCallTranslatorList getRemovedTagFunctions() {
        return this.removeTagsHolder;
    }

    @Override
    public void setValue(TypeSystem.Value result) {
        this.resolvedRule.setResult(DebugValueBuilder.copyImmutableValue(result));
    }

    public static MutableDebug.ResolvedFunctionCall translateExpandedFunctionCall(ResourceUtil.ExpandedFunctionCall f) {
        MutableDebug.ResolvedFunctionCall result = MutableDebug.ResolvedFunctionCall.newMessage();
        for (Map.Entry<String, TypeSystem.Value> originalParam : f.getProperties().entrySet()) {
            MutableDebug.ResolvedProperty prop = MutableDebug.ResolvedProperty.newMessage();
            prop.setKey(originalParam.getKey());
            prop.setValue(DebugValueBuilder.copyImmutableValue(originalParam.getValue()));
            result.addProperties(prop);
        }
        return result;
    }

    class DebugResolvedFunctionCallListTranslator
    implements ResolvedFunctionCallTranslatorList {
        @VisibleForTesting
        List<MutableDebug.ResolvedFunctionCall> toBuild;

        DebugResolvedFunctionCallListTranslator(List<MutableDebug.ResolvedFunctionCall> result) {
            this.toBuild = result;
        }

        @Override
        public void translateAndAddAll(List<ResourceUtil.ExpandedFunctionCall> functions, List<String> ruleNames) {
            for (int i = 0; i < functions.size(); ++i) {
                this.toBuild.add(DebugResolvedRuleBuilder.translateExpandedFunctionCall(functions.get(i)));
                if (i < ruleNames.size()) {
                    this.toBuild.get(i).setAssociatedRuleName(ruleNames.get(i));
                    continue;
                }
                this.toBuild.get(i).setAssociatedRuleName("Unknown");
            }
        }
    }
}

