/*
 * Decompiled with CFR 0.152.
 */
package com.google.tagmanager;

import com.google.android.gms.common.util.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class DataLayer {
    public static final Object OBJECT_NOT_PRESENT = new Object();
    static final int MAX_QUEUE_DEPTH = 500;
    private final ConcurrentHashMap<Listener, Integer> mListeners = new ConcurrentHashMap();
    private final Map<Object, Object> mModel = new HashMap<Object, Object>();
    private final ReentrantLock mPushLock = new ReentrantLock();
    private final LinkedList<Map<Object, Object>> mUpdateQueue = new LinkedList();

    DataLayer() {
    }

    public void push(Object key, Object value) {
        Map<Object, Object> expanded = this.expandKeyValue(key, value);
        this.push(expanded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(Map<Object, Object> update) {
        this.mPushLock.lock();
        try {
            this.mUpdateQueue.offer(update);
            if (this.mPushLock.getHoldCount() == 1) {
                this.processQueuedUpdates();
            }
        }
        finally {
            this.mPushLock.unlock();
        }
    }

    private void processQueuedUpdates() {
        Map<Object, Object> update;
        int numUpdatesProcessed = 0;
        while ((update = this.mUpdateQueue.poll()) != null) {
            this.processUpdate(update);
            if (++numUpdatesProcessed <= 500) continue;
            this.mUpdateQueue.clear();
            throw new RuntimeException("Seems like an infinite loop of pushing to the data layer");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUpdate(Map<Object, Object> update) {
        Map<Object, Object> map = this.mModel;
        synchronized (map) {
            for (Object key : update.keySet()) {
                this.mergeMap(this.expandKeyValue(key, update.get(key)), this.mModel);
            }
        }
        this.notifyListeners(update);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Map<Object, Object> map = this.mModel;
        synchronized (map) {
            String[] split;
            Object target = this.mModel;
            for (String s : split = key.split("\\.")) {
                if (!(target instanceof Map)) {
                    return null;
                }
                Object map2 = target;
                Object value = map2.get(s);
                if (value == null) {
                    return null;
                }
                target = value;
            }
            return target;
        }
    }

    public static Map<Object, Object> mapOf(Object ... objects) {
        if (objects.length % 2 != 0) {
            throw new IllegalArgumentException("expected even number of key-value pairs");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static List<Object> listOf(Object ... objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            list.add(objects[i]);
        }
        return list;
    }

    void registerListener(Listener listener) {
        this.mListeners.put(listener, 0);
    }

    void unregisterListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    private void notifyListeners(Map<Object, Object> update) {
        for (Listener listener : this.mListeners.keySet()) {
            listener.changed(update);
        }
    }

    @VisibleForTesting
    Map<Object, Object> expandKeyValue(Object key, Object value) {
        HashMap<Object, Object> result;
        HashMap<Object, Object> target = result = new HashMap<Object, Object>();
        String[] split = key.toString().split("\\.");
        for (int i = 0; i < split.length - 1; ++i) {
            HashMap map = new HashMap();
            target.put(split[i], map);
            target = map;
        }
        target.put(split[split.length - 1], value);
        return result;
    }

    @VisibleForTesting
    void mergeMap(Map<Object, Object> from, Map<Object, Object> to) {
        for (Object key : from.keySet()) {
            Object mergeTo;
            Object mergeFrom;
            Object fromValue = from.get(key);
            if (fromValue instanceof List) {
                if (!(to.get(key) instanceof List)) {
                    to.put(key, new ArrayList());
                }
                mergeFrom = (List)fromValue;
                mergeTo = (List)to.get(key);
                this.mergeList((List<Object>)mergeFrom, (List<Object>)mergeTo);
                continue;
            }
            if (fromValue instanceof Map) {
                if (!(to.get(key) instanceof Map)) {
                    to.put(key, new HashMap());
                }
                mergeFrom = (Map)fromValue;
                mergeTo = (Map)to.get(key);
                this.mergeMap((Map<Object, Object>)mergeFrom, (Map<Object, Object>)mergeTo);
                continue;
            }
            to.put(key, fromValue);
        }
    }

    @VisibleForTesting
    void mergeList(List<Object> from, List<Object> to) {
        while (to.size() < from.size()) {
            to.add(null);
        }
        for (int index = 0; index < from.size(); ++index) {
            Object mergeTo;
            Object mergeFrom;
            Object fromValue = from.get(index);
            if (fromValue instanceof List) {
                if (!(to.get(index) instanceof List)) {
                    to.set(index, new ArrayList());
                }
                mergeFrom = (List)fromValue;
                mergeTo = (List)to.get(index);
                this.mergeList((List<Object>)mergeFrom, (List<Object>)mergeTo);
                continue;
            }
            if (fromValue instanceof Map) {
                if (!(to.get(index) instanceof Map)) {
                    to.set(index, new HashMap());
                }
                mergeFrom = (Map)fromValue;
                mergeTo = (Map)to.get(index);
                this.mergeMap((Map<Object, Object>)mergeFrom, (Map<Object, Object>)mergeTo);
                continue;
            }
            if (fromValue == OBJECT_NOT_PRESENT) continue;
            to.set(index, fromValue);
        }
    }

    static interface Listener {
        public void changed(Map<Object, Object> var1);
    }
}

