/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebView;
import android.webkit.WebViewDatabase;
import com.amazon.device.ads.AndroidTargetUtils;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;

class WebViewFactory {
    private static WebViewFactory instance = new WebViewFactory();
    private static boolean isWebViewCheckedAndOk = false;
    private boolean cookieSyncManagerCreated = false;

    protected WebViewFactory() {
    }

    public static final WebViewFactory getInstance() {
        return instance;
    }

    protected static void setInstance(WebViewFactory newInstance) {
        instance = newInstance;
    }

    public synchronized WebView createWebView(Context context) {
        WebView webView = new WebView(context);
        if (!this.cookieSyncManagerCreated) {
            CookieSyncManager.createInstance((Context)context);
            this.cookieSyncManagerCreated = true;
        }
        this.updateAdIdCookie();
        return webView;
    }

    private void updateAdIdCookie() {
        if (this.cookieSyncManagerCreated) {
            String adId = InternalAdRegistration.getInstance().getRegistrationInfo().getAdId();
            if (adId == null) {
                adId = "";
            }
            this.setCookie("http://amazon-adsystem.com", "ad-id=" + adId + "; Domain=.amazon-adsystem.com");
        }
    }

    protected void setCookie(String url, String cookie) {
        CookieManager.getInstance().setCookie(url, cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWebViewOk(Context c) {
        if (Build.VERSION.SDK_INT <= 8 && !isWebViewCheckedAndOk) {
            WebViewDatabase wvDb = WebViewDatabase.getInstance((Context)c);
            if (wvDb == null) {
                return false;
            }
            SQLiteDatabase cdb = null;
            try {
                cdb = c.openOrCreateDatabase("webviewCache.db", 0, null);
            }
            catch (SQLiteException e) {
                boolean bl = WebViewFactory.isDatabaseLocked(e);
                return bl;
            }
            finally {
                if (cdb != null) {
                    cdb.close();
                }
            }
            isWebViewCheckedAndOk = true;
        }
        return true;
    }

    protected static boolean isDatabaseLocked(SQLiteException e) {
        if (Build.VERSION.SDK_INT >= 11) {
            return AndroidTargetUtils.isInstanceOfSQLiteDatabaseLockedException(e);
        }
        return WebViewFactory.doesExceptionContainLockedDatabaseMessage((Exception)((Object)e));
    }

    protected static boolean doesExceptionContainLockedDatabaseMessage(Exception e) {
        String lockedDatabaseMessage = "database is locked";
        return e == null || e.getMessage() == null ? false : e.getMessage().contains("database is locked");
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static final boolean setJavaScriptEnabledForWebView(boolean enable, WebView webView, String logtag) {
        try {
            webView.getSettings().setJavaScriptEnabled(enable);
        }
        catch (NullPointerException e) {
            Log.w(logtag, "Could not set JavaScriptEnabled because a NullPointerException was encountered.");
            return false;
        }
        return true;
    }
}

