/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.AppEventRegistrationHandler;
import com.amazon.device.ads.DebugProperties;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.RegistrationInfo;
import com.amazon.device.ads.SISDeviceRequest;
import com.amazon.device.ads.SISGenerateDIDRequest;
import com.amazon.device.ads.SISRegisterEventRequest;
import com.amazon.device.ads.SISRequestor;
import com.amazon.device.ads.SISRequestorCallback;
import com.amazon.device.ads.SISUpdateDeviceInfoRequest;
import com.amazon.device.ads.Settings;
import com.amazon.device.ads.StartUpWaiter;
import com.amazon.device.ads.ThreadUtils;
import org.json.JSONArray;

class SISRegistration
extends StartUpWaiter {
    private static final String LOG_TAG = SISRegistration.class.getSimpleName();
    private static final String SIS_LAST_CHECKIN_PREF_NAME = "amzn-ad-sis-last-checkin";
    protected static final long SIS_CHECKIN_INTERVAL = 86400000L;
    private AdvertisingIdentifier.Info advertisingIdentifierInfo;

    SISRegistration() {
    }

    protected synchronized void startUpReady() {
        long currentTime = System.currentTimeMillis();
        this.advertisingIdentifierInfo = this.createAdvertisingIdentifierInfo();
        if (this.advertisingIdentifierInfo.canDo() && this.canRegister(currentTime)) {
            this.putLastSISCheckin(currentTime);
            if (this.shouldUpdateDeviceInfo()) {
                this.updateDeviceInfo();
            } else {
                this.register();
            }
        }
    }

    protected AdvertisingIdentifier.Info createAdvertisingIdentifierInfo() {
        AdvertisingIdentifier advertisingIdentifier = new AdvertisingIdentifier();
        return advertisingIdentifier.getAdvertisingIdentifierInfo();
    }

    protected boolean canRegister(long currentTime) {
        RegistrationInfo registrationInfo = InternalAdRegistration.getInstance().getRegistrationInfo();
        return this.exceededCheckinInterval(currentTime) || registrationInfo.shouldGetNewSISDeviceIdentifer() || registrationInfo.shouldGetNewSISRegistration() || DebugProperties.getDebugPropertyAsBoolean("debug.shouldRegisterSIS", false);
    }

    protected boolean shouldUpdateDeviceInfo() {
        return InternalAdRegistration.getInstance().getRegistrationInfo().isRegisteredWithSIS();
    }

    protected void startUpFailed() {
    }

    public void registerApp() {
        this.start();
    }

    protected boolean exceededCheckinInterval(long now) {
        return now - this.getLastSISCheckin() > 86400000L;
    }

    protected void register() {
        SISDeviceRequest generateDIDRequest = new SISGenerateDIDRequest().setAdvertisingIdentifierInfo(this.advertisingIdentifierInfo);
        RegisterEventsSISRequestorCallback sisRequestorCallback = new RegisterEventsSISRequestorCallback(this);
        SISRequestor sisRequestor = new SISRequestor(sisRequestorCallback, generateDIDRequest);
        sisRequestor.startCallSIS();
    }

    protected void updateDeviceInfo() {
        SISDeviceRequest updateDeviceInfoRequest = new SISUpdateDeviceInfoRequest().setAdvertisingIdentifierInfo(this.advertisingIdentifierInfo);
        RegisterEventsSISRequestorCallback sisRequestorCallback = new RegisterEventsSISRequestorCallback(this);
        SISRequestor sisRequestor = new SISRequestor(sisRequestorCallback, updateDeviceInfoRequest);
        sisRequestor.startCallSIS();
    }

    protected long getLastSISCheckin() {
        return Settings.getInstance().getLong(SIS_LAST_CHECKIN_PREF_NAME, 0L);
    }

    private void putLastSISCheckin(long currentTime) {
        Settings.getInstance().putLong(SIS_LAST_CHECKIN_PREF_NAME, currentTime);
    }

    protected void registerEvents() {
        JSONArray appEvents;
        if (ThreadUtils.isOnMainThread()) {
            Log.e(LOG_TAG, "Registering events must be done on a background thread.");
            return;
        }
        AdvertisingIdentifier advertisingIdentifier = new AdvertisingIdentifier();
        AdvertisingIdentifier.Info advertisingIdentifierInfo = advertisingIdentifier.getAdvertisingIdentifierInfo();
        if (advertisingIdentifierInfo.hasSISDeviceIdentifier() && (appEvents = AppEventRegistrationHandler.getInstance().getAppEventsJSONArray()) != null) {
            SISRegisterEventRequest registerEventRequest = new SISRegisterEventRequest(advertisingIdentifierInfo, appEvents);
            SISRequestor sisRequestor = new SISRequestor(registerEventRequest);
            sisRequestor.startCallSIS();
        }
    }

    protected static class RegisterEventsSISRequestorCallback
    implements SISRequestorCallback {
        private final SISRegistration sisRegistration;

        public RegisterEventsSISRequestorCallback(SISRegistration sisRegistration) {
            this.sisRegistration = sisRegistration;
        }

        public void onSISCallComplete() {
            this.sisRegistration.registerEvents();
        }
    }
}

