/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.AdvertisingIdentifier;
import com.amazon.device.ads.Configuration;
import com.amazon.device.ads.DeviceInfo;
import com.amazon.device.ads.InternalAdRegistration;
import com.amazon.device.ads.Metrics;
import com.amazon.device.ads.SISRequest;
import com.amazon.device.ads.Utils;
import com.amazon.device.ads.WebRequest;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SISDeviceRequest
implements SISRequest {
    private String logTag;
    private Metrics.MetricType callMetricType;
    private String path;
    private AdvertisingIdentifier.Info advertisingIdentifierInfo;

    SISDeviceRequest() {
    }

    public SISDeviceRequest setLogTag(String logTag) {
        this.logTag = logTag;
        return this;
    }

    public SISDeviceRequest setCallMetricType(Metrics.MetricType callMetricType) {
        this.callMetricType = callMetricType;
        return this;
    }

    public SISDeviceRequest setPath(String path) {
        this.path = path;
        return this;
    }

    public SISDeviceRequest setAdvertisingIdentifierInfo(AdvertisingIdentifier.Info advertisingIdentifierInfo) {
        this.advertisingIdentifierInfo = advertisingIdentifierInfo;
        return this;
    }

    @Override
    public String getLogTag() {
        return this.logTag;
    }

    @Override
    public Metrics.MetricType getCallMetricType() {
        return this.callMetricType;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public WebRequest.QueryStringParameters getQueryParameters() {
        WebRequest.QueryStringParameters queryStringParameters = new WebRequest.QueryStringParameters();
        queryStringParameters.putUrlEncoded("dt", DeviceInfo.getDeviceType());
        queryStringParameters.putUrlEncoded("app", InternalAdRegistration.getInstance().getRegistrationInfo().getAppName());
        queryStringParameters.putUrlEncoded("aud", Configuration.getInstance().getString(Configuration.ConfigOption.SIS_DOMAIN));
        queryStringParameters.putUrlEncoded("ua", Utils.getURLEncodedString(DeviceInfo.getUserAgentString()));
        queryStringParameters.putUrlEncoded("dinfo", Utils.getURLEncodedString(SISDeviceRequest.getDInfoProperty()));
        queryStringParameters.putUrlEncoded("pkg", Utils.getURLEncodedString(InternalAdRegistration.getInstance().getAppInfo().getPackageInfoJSONString()));
        if (this.advertisingIdentifierInfo.hasAdvertisingIdentifier()) {
            queryStringParameters.putUrlEncoded("idfa", this.advertisingIdentifierInfo.getAdvertisingIdentifier());
            queryStringParameters.putUrlEncoded("oo", SISDeviceRequest.convertOptOutBooleanToStringInt(this.advertisingIdentifierInfo.isLimitAdTrackingEnabled()));
        } else {
            DeviceInfo deviceInfo = InternalAdRegistration.getInstance().getDeviceInfo();
            queryStringParameters.putUrlEncoded("sha1_mac", deviceInfo.getMacSha1());
            queryStringParameters.putUrlEncoded("sha1_serial", deviceInfo.getSerialSha1());
            queryStringParameters.putUrlEncoded("sha1_udid", deviceInfo.getUdidSha1());
            queryStringParameters.putUrlEncodedIfTrue("badMac", "true", deviceInfo.isMacBad());
            queryStringParameters.putUrlEncodedIfTrue("badSerial", "true", deviceInfo.isSerialBad());
            queryStringParameters.putUrlEncodedIfTrue("badUdid", "true", deviceInfo.isUdidBad());
        }
        String adIdTransition = AdvertisingIdentifier.getAndClearTransition();
        queryStringParameters.putUrlEncodedIfTrue("aidts", adIdTransition, adIdTransition != null);
        return queryStringParameters;
    }

    private static String convertOptOutBooleanToStringInt(boolean optOut) {
        return optOut ? "1" : "0";
    }

    protected AdvertisingIdentifier.Info getAdvertisingIdentifierInfo() {
        return this.advertisingIdentifierInfo;
    }

    public static String getDInfoProperty() {
        String deviceInfoProperty = String.format("{\"make\":\"%s\",\"model\":\"%s\",\"os\":\"%s\",\"osVersion\":\"%s\"}", DeviceInfo.getMake(), DeviceInfo.getModel(), DeviceInfo.getOS(), DeviceInfo.getOSVersion());
        return deviceInfoProperty;
    }

    @Override
    public HashMap<String, String> getPostParameters() {
        return null;
    }
}

