/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import com.amazon.device.ads.AdData;
import com.amazon.device.ads.AdProperties;
import com.amazon.device.ads.AdRenderer;
import com.amazon.device.ads.AdUtils;
import com.amazon.device.ads.IAdController;
import com.amazon.device.ads.Log;
import com.amazon.device.ads.MraidView;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MraidRenderer
extends AdRenderer
implements MraidView.OnCloseListener,
MraidView.OnExpandListener,
MraidView.OnReadyListener,
MraidView.OnSpecialUrlClickListener {
    private static final String LOG_TAG = "MraidRenderer";
    protected MraidView mraidView_;
    private WebView webView_;

    protected MraidRenderer(AdData ad, IAdController controller, WebView webView, Context context) {
        super(ad, controller, context);
        this.webView_ = webView;
    }

    @Override
    protected boolean getAdState(AdRenderer.AdState c) {
        if (this.mraidView_ == null) {
            Log.w(LOG_TAG, "Unable to retrieve ad state.");
            return false;
        }
        switch (c) {
            case EXPANDED: {
                return this.mraidView_.getDisplayController().isExpanded();
            }
        }
        return false;
    }

    @Override
    protected boolean render() {
        if (this.isAdViewDestroyed()) {
            return false;
        }
        this.mraidView_ = this.createNewMraidView();
        if (this.mraidView_.getShouldForceRenderFailure()) {
            return false;
        }
        if (!this.mraidView_.loadHtmlData(this.adData.getCreative())) {
            return false;
        }
        this.renderMraidView();
        return true;
    }

    protected MraidView createNewMraidView() {
        return new MraidView(this, this.controller.getWindowWidth(), this.controller.getWindowHeight(), this.getScalingMultiplier(), this.context, this.webView_);
    }

    @SuppressLint(value={"InlinedApi"})
    protected void renderMraidView() {
        this.mraidView_.setOnReadyListener(this);
        this.mraidView_.setOnSpecialUrlClickListener(this);
        this.mraidView_.setOnExpandListener(this);
        this.mraidView_.setOnCloseListener(this);
        this.controller.getAdLayout().removeAllViews();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1, 17);
        this.controller.getAdLayout().addView((View)this.mraidView_, (ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    protected void removeView() {
        if (!this.viewRemoved && !this.isDestroyed) {
            try {
                this.controller.getAdLayout().removeAllViews();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.viewRemoved = true;
        }
    }

    @Override
    protected void destroy() {
        if (this.mraidView_ != null) {
            this.mraidView_.destroy();
            this.mraidView_ = null;
            this.isDestroyed = true;
        }
        this.webView_ = null;
    }

    @Override
    protected void prepareToGoAway() {
        if (this.mraidView_ != null) {
            this.mraidView_.prepareToGoAway();
        }
    }

    @Override
    protected void adLoaded(AdProperties props) {
        super.adLoaded(props);
    }

    @Override
    protected boolean sendCommand(String command, Map<String, String> args) {
        Log.d(LOG_TAG, "sendCommand: %s", command);
        if (command.equals("close") && this.mraidView_ != null && this.mraidView_.getDisplayController().isExpanded()) {
            this.mraidView_.getDisplayController().close();
            return true;
        }
        return false;
    }

    @Override
    public void onReady(MraidView view) {
        this.adLoaded(this.adData.getProperties());
    }

    @Override
    public void onExpand(MraidView view) {
        if (!this.isAdViewRemoved()) {
            this.controller.adExpanded();
        }
    }

    @Override
    public void onClose(MraidView view, MraidView.ViewState newViewState) {
        if (!this.isAdViewRemoved()) {
            this.controller.adClosedExpansion();
        }
    }

    @Override
    protected boolean shouldReuse() {
        return false;
    }

    @Override
    public void onPageFinished() {
        if (this.mraidView_ == null) {
            Log.w(LOG_TAG, "Call to onPageFinished() ignored because view is null.");
            return;
        }
        this.mraidView_.onPageFinished();
    }

    @Override
    public boolean launchExternalBrowserForLink(String url) {
        if (this.isAdViewRenderable()) {
            return AdUtils.launchActivityForIntentLink(url, this.context);
        }
        return false;
    }

    @Override
    public void onSpecialUrlClick(MraidView view, String url) {
        if (this.isAdViewRenderable()) {
            this.getSpecialUrlExecutor().execute(url);
        }
    }
}

