/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.Log;
import com.amazon.device.ads.MraidCommand;
import com.amazon.device.ads.MraidView;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MraidCommandLogCat
extends MraidCommand {
    private static final String MRAID_LOG_TAG = "MRAIDLog";

    MraidCommandLogCat(Map<String, String> params, MraidView view) {
        super(params, view);
    }

    @Override
    void execute() {
        int level = this.getIntFromParamsForKey("level");
        String log = this.getStringFromParamsForKey("log");
        if (level == -1) {
            return;
        }
        if (log == null || log.length() == 0) {
            return;
        }
        switch (level) {
            case 3: {
                Log.d(MRAID_LOG_TAG, log);
                break;
            }
            case 2: {
                Log.v(MRAID_LOG_TAG, log);
                break;
            }
            case 5: {
                Log.w(MRAID_LOG_TAG, log);
                break;
            }
            case 6: {
                Log.e(MRAID_LOG_TAG, log);
                break;
            }
            default: {
                Log.i(MRAID_LOG_TAG, log);
            }
        }
    }
}

