/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.ads;

import com.amazon.device.ads.MraidView;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MraidCommand {
    protected Map<String, String> mParams;
    protected MraidView mView;

    MraidCommand(Map<String, String> params, MraidView view) {
        this.mParams = params;
        this.mView = view;
    }

    abstract void execute();

    protected int getIntFromParamsForKey(String key) {
        String s = this.mParams.get(key);
        if (s == null) {
            return -1;
        }
        try {
            return Integer.parseInt(s, 10);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    protected String getStringFromParamsForKey(String key) {
        return this.mParams.get(key);
    }

    protected float getFloatFromParamsForKey(String key) {
        String s = this.mParams.get(key);
        if (s == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(key);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    protected boolean getBooleanFromParamsForKey(String key) {
        return "true".equals(this.mParams.get(key));
    }

    protected Integer[] getIntArrayFromParamsForKey(String key) {
        String s = this.mParams.get(key);
        if (s == null) {
            return null;
        }
        String[] sv = s.split(",");
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (String v : sv) {
            try {
                ret.add(Integer.parseInt(v, 10));
            }
            catch (NumberFormatException e) {
                ret.add(-1);
            }
        }
        return ret.toArray(new Integer[ret.size()]);
    }
}

